/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jv.number.PdColor;
import jv.number.PdColor_Dialog;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsSlotLayout;

public class PdColor_IP
extends PsPanel
implements ActionListener,
MouseListener {
    protected PdColor m_color;
    protected int[] m_rgbOld = new int[3];
    protected int[] m_rgbNew = new int[3];
    protected static final int LENGTH = 3;
    protected int m_min = 0;
    protected int m_max = 255;
    protected PdColor_Dialog m_dialog;
    protected PsPanel m_pColor;
    protected TextField[] m_text;

    public PdColor_IP() {
        this.setLayout(new PsSlotLayout(6));
        this.m_lTitle = new Label();
        this.add("2", this.m_lTitle);
        this.m_pColor = new PsPanel(new BorderLayout());
        this.m_pColor.setBorderType(2);
        this.m_pColor.addMouseListener(this);
        this.m_pColor.setBackColor(Color.red);
        this.add("1", this.m_pColor);
        PsPanel psPanel = new PsPanel(new GridLayout(1, 3));
        this.add("3", psPanel);
        this.m_text = new TextField[3];
        for (int i = 0; i < 3; ++i) {
            this.m_text[i] = new TextField("0");
            this.m_text[i].addActionListener(this);
            psPanel.add(this.m_text[i]);
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_color = (PdColor)psUpdateIf;
        for (int i = 0; i < 3; ++i) {
            this.m_rgbOld[0] = this.m_color.getEntry(i);
        }
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_color == null) {
            PsDebug.warning("missing color");
            return true;
        }
        if (object == this.m_color) {
            this.setEnabled(this.m_color.isEnabled());
            this.setTitle(this.m_color.getName());
            for (int i = 0; i < 3; ++i) {
                this.m_rgbNew[i] = this.m_color.getEntry(i);
                PsPanel.setText(this.m_text[i], String.valueOf(this.m_rgbNew[i]));
            }
            this.m_pColor.setBackColor(this.m_color.getColor());
            this.m_pColor.repaint();
            return true;
        }
        return false;
    }

    public Color getColor() {
        return new Color(this.m_rgbNew[0], this.m_rgbNew[1], this.m_rgbNew[2]);
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        PsPanel.setEnabled(this.m_lTitle, bl);
        PsPanel.setEnabled(this.m_pColor, bl);
        for (int i = 0; i < 3; ++i) {
            PsPanel.setEnabled(this.m_text[i], bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_color == null) {
            PsDebug.warning("no color assigned, return");
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_dialog) {
            this.m_dialog = null;
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (object != this.m_text[i]) continue;
            PsDebug.notify("text[" + i + "] chosen");
            String string = this.m_text[i].getText();
            if (string == null || string.equals("")) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n < this.m_min || this.m_max < n) {
                    PsDebug.warning("wrong format");
                    PsPanel.setText(this.m_text[i], String.valueOf(this.m_rgbNew[i]));
                    return;
                }
                this.m_rgbNew[i] = n;
                this.m_color.setEntry(i, this.m_rgbNew[i]);
                this.m_pColor.setBackColor(this.m_color.getColor());
                this.m_pColor.repaint();
                PsDebug.notify("setValue=" + this.m_rgbNew[i]);
                this.m_color.update(null);
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format = " + string);
                PsPanel.setText(this.m_text[i], String.valueOf(this.m_color.getEntry(i)));
            }
            return;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_dialog != null) {
            return;
        }
        this.m_dialog = new PdColor_Dialog(this.m_color);
        this.m_dialog.addActionListener(this);
        ((Component)this.m_dialog).setVisible(true);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

