/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.number.PuString;
import jv.object.PsDebug;

public class PsXmlNode
implements Serializable {
    protected String m_type;
    protected Hashtable m_attribute;
    protected String m_content;
    protected String m_contentEnd;
    protected StringBuffer m_contentBuffer;
    protected Vector m_mixedContent;
    protected PsXmlNode m_father;
    protected PsXmlNode m_sibling;
    protected PsXmlNode m_child;
    private PsXmlNode m_lastChild;
    private boolean m_bIsExpanded;
    protected boolean m_bMixedMode;

    public PsXmlNode(String string) {
        this.m_type = string;
        this.m_bIsExpanded = true;
        this.m_bMixedMode = false;
    }

    public boolean isMixedMode() {
        return this.m_bMixedMode;
    }

    public void setMixedMode(boolean bl) {
        this.m_bMixedMode = bl;
    }

    public void addMixedContent(Object object) {
        if (this.m_mixedContent == null) {
            this.m_mixedContent = new Vector();
        }
        this.m_mixedContent.addElement(object);
    }

    public Enumeration getMixedContent() {
        if (this.m_mixedContent == null) {
            return null;
        }
        return this.m_mixedContent.elements();
    }

    public PsXmlNode[] getChildren() {
        int n = this.getNumChildren();
        if (n == 0) {
            return null;
        }
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[n];
        PsXmlNode psXmlNode = this.m_child;
        for (int i = 0; i < n; ++i) {
            psXmlNodeArray[i] = psXmlNode;
            psXmlNode = psXmlNode.m_sibling;
        }
        return psXmlNodeArray;
    }

    public PsXmlNode[] getChildren(String string) {
        Vector<PsXmlNode> vector = null;
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            if (psXmlNode.m_type.equals(string)) {
                if (vector == null) {
                    vector = new Vector<PsXmlNode>();
                }
                vector.addElement(psXmlNode);
            }
            psXmlNode = psXmlNode.m_sibling;
        }
        if (vector != null) {
            Object[] objectArray = new PsXmlNode[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public boolean hasChild(String string) {
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            String string2 = psXmlNode.m_type;
            if (string2 != null && string2.equals(string)) {
                return true;
            }
            psXmlNode = psXmlNode.m_sibling;
        }
        return false;
    }

    public boolean removeChild(String string) {
        PsXmlNode psXmlNode = null;
        PsXmlNode psXmlNode2 = this.m_child;
        while (psXmlNode2 != null) {
            String string2 = psXmlNode2.m_type;
            if (string2 == null || !string2.equals(string)) {
                psXmlNode = psXmlNode2;
                psXmlNode2 = psXmlNode2.m_sibling;
                continue;
            }
            if (psXmlNode == null) {
                this.m_child = psXmlNode2.m_sibling;
            } else {
                psXmlNode.m_sibling = psXmlNode2.m_sibling;
            }
            if (this.m_lastChild == psXmlNode2) {
                this.m_lastChild = psXmlNode;
            }
            psXmlNode2.m_father = null;
            psXmlNode2.m_sibling = null;
            return true;
        }
        return false;
    }

    public PsXmlNode getChild(String string) {
        Object object;
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            object = psXmlNode.m_type;
            if (object != null && ((String)object).equals(string)) {
                return psXmlNode;
            }
            psXmlNode = psXmlNode.m_sibling;
        }
        psXmlNode = this.m_child;
        while (psXmlNode != null) {
            object = psXmlNode.getChild(string);
            if (object != null) {
                return object;
            }
            psXmlNode = psXmlNode.m_sibling;
        }
        return null;
    }

    public PsXmlNode addChild(String string, String string2) {
        PsXmlNode psXmlNode = this.addChild(string);
        if (psXmlNode == null) {
            return null;
        }
        psXmlNode.setContent(string2);
        return psXmlNode;
    }

    public PsXmlNode addChild(String string, boolean bl) {
        return this.addChild(string, String.valueOf(bl));
    }

    public PsXmlNode addChild(String string, double d) {
        return this.addChild(string, String.valueOf(d));
    }

    public PsXmlNode addChild(String string, float f) {
        return this.addChild(string, String.valueOf(f));
    }

    public PsXmlNode addChild(String string, int n) {
        return this.addChild(string, String.valueOf(n));
    }

    public PsXmlNode addChild(String string) {
        if (PuString.isEmpty(string)) {
            return null;
        }
        return this.addChild(new PsXmlNode(string));
    }

    public PsXmlNode addChild(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            PsDebug.warning("missing child argument");
            return null;
        }
        psXmlNode.setFather(this);
        if (this.m_child == null) {
            this.m_child = psXmlNode;
            this.m_lastChild = psXmlNode;
        } else {
            this.m_lastChild.m_sibling = psXmlNode;
            this.m_lastChild = psXmlNode;
        }
        return psXmlNode;
    }

    public PsXmlNode getChild() {
        return this.m_child;
    }

    public void removeChildren() {
        this.m_child = null;
        this.m_lastChild = null;
    }

    public void setChild(PsXmlNode psXmlNode) {
        if (psXmlNode != null) {
            psXmlNode.setFather(this);
        }
        this.m_child = psXmlNode;
        this.m_lastChild = psXmlNode;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public boolean isExpanded() {
        return this.m_bIsExpanded;
    }

    public void setExpanded(boolean bl) {
        this.m_bIsExpanded = bl;
    }

    public void expand(boolean bl) {
        this.m_bIsExpanded = bl;
    }

    public PsXmlNode getFather() {
        return this.m_father;
    }

    public void setFather(PsXmlNode psXmlNode) {
        this.m_father = psXmlNode;
    }

    public PsXmlNode getSibling() {
        return this.m_sibling;
    }

    public void setSibling(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            this.m_sibling = null;
            return;
        }
        this.m_sibling = psXmlNode;
        psXmlNode.setFather(this.m_father);
    }

    public int getNumChildren() {
        int n = 0;
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            ++n;
            psXmlNode = psXmlNode.m_sibling;
        }
        return n;
    }

    public boolean contentEndsWith(char c) {
        if (this.m_contentEnd == null) {
            return false;
        }
        return this.m_contentEnd.charAt(this.m_contentEnd.length() - 1) == c;
    }

    public boolean hasContent() {
        return this.m_content != null || this.m_contentBuffer != null;
    }

    public String getContent() {
        if (this.m_contentBuffer != null) {
            this.m_content = this.m_contentBuffer.toString();
            this.m_contentBuffer = null;
        }
        return this.m_content;
    }

    public void setContent(String string) {
        if (this.m_contentBuffer != null) {
            this.m_contentBuffer = null;
        }
        this.m_content = string;
        this.m_contentEnd = string;
    }

    public void appendContent(String string) {
        if (string == null) {
            return;
        }
        if (this.m_contentBuffer == null) {
            if (this.m_content == null) {
                this.m_content = string;
            } else if (this.m_content.length() < 100) {
                this.m_content = this.m_content.concat(string);
            } else {
                this.m_contentBuffer = new StringBuffer(this.m_content + string);
                this.m_content = null;
            }
        } else {
            this.m_contentBuffer.append(string);
        }
        this.m_contentEnd = string;
    }

    public void addAttribute(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if (this.m_attribute == null) {
            this.m_attribute = new Hashtable();
        }
        this.m_attribute.put(string, string2);
    }

    public Hashtable getAttributes() {
        return this.m_attribute;
    }

    public String getAttribute(String string) {
        if (string == null || this.m_attribute == null) {
            return null;
        }
        return (String)this.m_attribute.get(string);
    }

    public void removeAttribute(String string) {
        if (string == null || this.m_attribute == null) {
            return;
        }
        this.m_attribute.remove(string);
    }

    public static StringBuffer writeNode(StringBuffer stringBuffer, PsXmlNode psXmlNode, String string) {
        String string2;
        Object object;
        Object object2;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer("");
        }
        if (psXmlNode == null) {
            return stringBuffer;
        }
        String string3 = "\t";
        if (string == null) {
            string = "";
            string3 = "";
        }
        stringBuffer.append(string + "<" + psXmlNode.m_type);
        Hashtable hashtable = psXmlNode.getAttributes();
        if (hashtable != null) {
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string2 = psXmlNode.getAttribute((String)object);
                stringBuffer.append(" " + (String)object + "=\"" + string2 + "\"");
            }
        }
        if (!psXmlNode.isMixedMode()) {
            object2 = psXmlNode.getContent();
            object = psXmlNode.getChild();
            if (PuString.isEmpty((String)object2) && object == null) {
                stringBuffer.append("/>\n");
            } else {
                stringBuffer.append(">");
                boolean bl = true;
                int n = -1;
                if (object2 != null) {
                    n = ((String)object2).indexOf(10);
                }
                if (object2 != null && n > -1 || object != null) {
                    bl = false;
                    stringBuffer.append("\n");
                }
                if (object2 != null) {
                    int n2 = 0;
                    String string4 = string + string3;
                    if (n != -1) {
                        do {
                            stringBuffer.append(string4 + ((String)object2).substring(n2, n + 1));
                            n2 = n + 1;
                        } while ((n = ((String)object2).indexOf(10, n + 1)) != -1);
                        if (n2 < ((String)object2).length()) {
                            stringBuffer.append(string4 + ((String)object2).substring(n2, ((String)object2).length()) + "\n");
                        }
                    } else {
                        if (!bl) {
                            stringBuffer.append(string4);
                        }
                        stringBuffer.append((String)object2);
                        if (!bl) {
                            stringBuffer.append("\n");
                        }
                    }
                }
                if (object != null) {
                    stringBuffer = PsXmlNode.writeNode(stringBuffer, (PsXmlNode)object, string + string3);
                    PsXmlNode psXmlNode2 = ((PsXmlNode)object).m_sibling;
                    while (psXmlNode2 != null) {
                        stringBuffer = PsXmlNode.writeNode(stringBuffer, psXmlNode2, string + string3);
                        psXmlNode2 = psXmlNode2.m_sibling;
                    }
                }
                if (!bl) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("</" + psXmlNode.m_type + ">\n");
            }
        } else {
            object2 = psXmlNode.getMixedContent();
            if (object2 == null || !object2.hasMoreElements()) {
                stringBuffer.append("/>\n");
            } else {
                stringBuffer.append(">");
                boolean bl = true;
                string2 = "";
                string = "";
                while (object2.hasMoreElements()) {
                    Object object3;
                    Object e = object2.nextElement();
                    if (e == null) continue;
                    if (e instanceof String) {
                        object3 = (String)e;
                        int n = ((String)object3).indexOf(10);
                        if (n > -1 || psXmlNode.getChild() != null) {
                            bl = false;
                        }
                        int n3 = 0;
                        String string5 = string + string2;
                        if (n != -1) {
                            do {
                                stringBuffer.append(string5 + ((String)object3).substring(n3, n + 1));
                                n3 = n + 1;
                            } while ((n = ((String)object3).indexOf(10, n + 1)) != -1);
                            if (n3 >= ((String)object3).length()) continue;
                            stringBuffer.append(string5 + ((String)object3).substring(n3, ((String)object3).length()) + "\n");
                            continue;
                        }
                        if (((String)object3).length() == 1 && (((String)object3).equals(".") || ((String)object3).equals(",") || ((String)object3).equals("?") || ((String)object3).equals("!") || ((String)object3).equals(";") || ((String)object3).equals(":"))) {
                            if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
                                stringBuffer.setLength(stringBuffer.length() - 1);
                            }
                            stringBuffer.append((String)object3 + "\n");
                            continue;
                        }
                        if (!bl) {
                            stringBuffer.append(string5);
                        }
                        stringBuffer.append((String)object3);
                        continue;
                    }
                    object3 = (PsXmlNode)e;
                    stringBuffer = PsXmlNode.writeNode(stringBuffer, (PsXmlNode)object3, string + string2);
                }
                if (!bl) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("</" + psXmlNode.m_type + ">\n");
            }
        }
        return stringBuffer;
    }

    public static boolean writeNode(Writer writer, PsXmlNode psXmlNode, String string) throws IOException {
        String string2;
        Object object;
        Object object2;
        if (writer == null) {
            PsDebug.warning("Missing writer to save data to.");
            return false;
        }
        if (psXmlNode == null) {
            return true;
        }
        String string3 = "\t";
        if (string == null) {
            string = "";
            string3 = "";
        }
        writer.write(string + "<" + psXmlNode.m_type);
        Hashtable hashtable = psXmlNode.getAttributes();
        if (hashtable != null) {
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string2 = psXmlNode.getAttribute((String)object);
                writer.write(" " + (String)object + "=\"" + string2 + "\"");
            }
        }
        if (!psXmlNode.isMixedMode()) {
            object2 = psXmlNode.getContent();
            object = psXmlNode.getChild();
            if (PuString.isEmpty((String)object2) && object == null) {
                writer.write("/>\n");
            } else {
                writer.write(">");
                boolean bl = true;
                int n = -1;
                if (object2 != null) {
                    n = ((String)object2).indexOf(10);
                }
                if (object2 != null && n > -1 || object != null) {
                    bl = false;
                    writer.write("\n");
                }
                if (object2 != null) {
                    int n2 = 0;
                    String string4 = string + string3;
                    if (n != -1) {
                        do {
                            writer.write(string4 + ((String)object2).substring(n2, n + 1));
                            n2 = n + 1;
                        } while ((n = ((String)object2).indexOf(10, n + 1)) != -1);
                        if (n2 < ((String)object2).length()) {
                            writer.write(string4 + ((String)object2).substring(n2, ((String)object2).length()) + "\n");
                        }
                    } else {
                        if (!bl) {
                            writer.write(string4);
                        }
                        writer.write((String)object2);
                        if (!bl) {
                            writer.write("\n");
                        }
                    }
                }
                if (object != null) {
                    PsXmlNode.writeNode(writer, (PsXmlNode)object, string + string3);
                    PsXmlNode psXmlNode2 = ((PsXmlNode)object).m_sibling;
                    while (psXmlNode2 != null) {
                        PsXmlNode.writeNode(writer, psXmlNode2, string + string3);
                        psXmlNode2 = psXmlNode2.m_sibling;
                    }
                }
                if (!bl) {
                    writer.write(string);
                }
                writer.write("</" + psXmlNode.m_type + ">\n");
            }
        } else {
            object2 = psXmlNode.getMixedContent();
            if (object2 == null || !object2.hasMoreElements()) {
                writer.write("/>\n");
            } else {
                writer.write(">");
                boolean bl = true;
                string2 = "";
                string = "";
                while (object2.hasMoreElements()) {
                    Object object3;
                    Object e = object2.nextElement();
                    if (e == null) continue;
                    if (e instanceof String) {
                        object3 = (String)e;
                        int n = ((String)object3).indexOf(10);
                        if (n > -1 || psXmlNode.getChild() != null) {
                            bl = false;
                        }
                        int n3 = 0;
                        String string5 = string + string2;
                        if (n != -1) {
                            do {
                                writer.write(string5 + ((String)object3).substring(n3, n + 1));
                                n3 = n + 1;
                            } while ((n = ((String)object3).indexOf(10, n + 1)) != -1);
                            if (n3 >= ((String)object3).length()) continue;
                            writer.write(string5 + ((String)object3).substring(n3, ((String)object3).length()) + "\n");
                            continue;
                        }
                        if (!bl) {
                            writer.write(string5);
                        }
                        writer.write((String)object3);
                        continue;
                    }
                    object3 = (PsXmlNode)e;
                    PsXmlNode.writeNode(writer, (PsXmlNode)object3, string + string2);
                }
                if (!bl) {
                    writer.write(string);
                }
                writer.write("</" + psXmlNode.m_type + ">\n");
            }
        }
        return true;
    }
}

