/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PuData;
import jv.vecmath.PuMath;

public class PdVector
extends P_Vector
implements Cloneable {
    public double[] m_data;

    public Object clone() {
        PdVector pdVector = null;
        pdVector = (PdVector)super.clone();
        if (pdVector == null) {
            return null;
        }
        if (this.m_data != null) {
            pdVector.m_data = (double[])this.m_data.clone();
        }
        return pdVector;
    }

    public static double[][] getEntries(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            return null;
        }
        int n = pdVectorArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = pdVectorArray[i].getEntries();
        }
        return dArrayArray;
    }

    public static PdVector[][] alloc(int n, int n2, int n3) {
        PdVector[][] pdVectorArray = new PdVector[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                pdVectorArray[i][j] = new PdVector(n3);
            }
        }
        return pdVectorArray;
    }

    public static PdVector[] realloc(PdVector[] pdVectorArray, int n, int n2) {
        int n3;
        int n4;
        if (pdVectorArray != null && pdVectorArray.length == n) {
            for (int i = 0; i < pdVectorArray.length; ++i) {
                if (pdVectorArray[i] == null) {
                    pdVectorArray[i] = new PdVector(n2);
                    continue;
                }
                if (pdVectorArray[i].m_data != null && pdVectorArray[i].m_data.length == n2) continue;
                pdVectorArray[i].setSize(n2);
            }
            return pdVectorArray;
        }
        PdVector[] pdVectorArray2 = new PdVector[n];
        if (pdVectorArray == null) {
            n4 = 0;
        } else {
            n4 = Math.min(pdVectorArray.length, n);
            System.arraycopy(pdVectorArray, 0, pdVectorArray2, 0, n4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (pdVectorArray2[n3] == null) {
                pdVectorArray2[n3] = new PdVector(n2);
                continue;
            }
            if (pdVectorArray2[n3].m_data != null && pdVectorArray2[n3].m_data.length == n2) continue;
            pdVectorArray2[n3].setSize(n2);
        }
        for (n3 = n4; n3 < n; ++n3) {
            pdVectorArray2[n3] = new PdVector(n2);
        }
        return pdVectorArray2;
    }

    public static PdVector[] alloc(int n, int n2) {
        return PdVector.realloc(null, n, n2);
    }

    public static PdVector[] realloc(PdVector[] pdVectorArray, int n) {
        int n2;
        int n3;
        if (pdVectorArray != null && pdVectorArray.length == n) {
            for (int i = 0; i < pdVectorArray.length; ++i) {
                if (pdVectorArray[i] != null) continue;
                pdVectorArray[i] = new PdVector(0);
            }
            return pdVectorArray;
        }
        PdVector[] pdVectorArray2 = new PdVector[n];
        if (pdVectorArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(pdVectorArray.length, n);
            System.arraycopy(pdVectorArray, 0, pdVectorArray2, 0, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                if (pdVectorArray2[n2] != null) continue;
                pdVectorArray2[n2] = new PdVector(0);
            }
        }
        for (n2 = n3; n2 < n; ++n2) {
            pdVectorArray2[n2] = new PdVector(0);
        }
        return pdVectorArray2;
    }

    public static PdVector[] copyNew(double[][] dArray) {
        if (dArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int n = dArray.length;
        PdVector[] pdVectorArray = new PdVector[n];
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i] = new PdVector(dArray[i]);
        }
        return pdVectorArray;
    }

    public static PdVector[] copyNew(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdVector.copyNew(pdVectorArray, pdVectorArray.length);
    }

    public static PdVector[] copyNew(PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector[] pdVectorArray2 = new PdVector[n];
        for (int i = 0; i < n; ++i) {
            pdVectorArray2[i] = PdVector.copyNew(pdVectorArray[i]);
        }
        return pdVectorArray2;
    }

    public static boolean copy(PdVector[] pdVectorArray, int n, PdVector[] pdVectorArray2, int n2, int n3) {
        if (n3 == 0) {
            return true;
        }
        if (pdVectorArray == null || pdVectorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest", pdVectorArray);
            return false;
        }
        if (pdVectorArray2 == null || pdVectorArray2.length < n2 + n3) {
            PsDebug.warning("missing space in dataSrc", pdVectorArray2);
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            pdVectorArray[n + i].copy(pdVectorArray2[n2 + i]);
        }
        return true;
    }

    public static int getSameSize(PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length == 0) {
            return -1;
        }
        if (pdVectorArray[0] == null) {
            return -1;
        }
        if (pdVectorArray.length < n) {
            PsDebug.warning("used vectors larger than array size.");
            n = pdVectorArray.length;
        }
        int n2 = pdVectorArray[0].getSize();
        for (int i = 1; i < n; ++i) {
            if (n2 == pdVectorArray[i].getSize()) continue;
            n2 = -1;
            break;
        }
        return n2;
    }

    public static final boolean scale(PdVector[] pdVectorArray, PdVector[] pdVectorArray2, int n) {
        int n2;
        if (n == 0) {
            return true;
        }
        if (pdVectorArray2 == null || pdVectorArray2.length == 0 || pdVectorArray2.length < n || pdVectorArray2[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (pdVectorArray == null || pdVectorArray.length == 0) {
            PsDebug.warning("missing bnd argument");
            return false;
        }
        int n3 = pdVectorArray2[0].getSize();
        if (n3 != pdVectorArray[0].getSize()) {
            PsDebug.warning("first bnd and first vec have different size");
            return false;
        }
        PdVector pdVector = new PdVector(n3);
        PdVector pdVector2 = new PdVector(n3);
        PdVector.min(pdVector, pdVectorArray2, n);
        PdVector.max(pdVector2, pdVectorArray2, n);
        double[] dArray = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            double d = pdVector2.getEntry(n2) - pdVector.getEntry(n2);
            if (d < 1.0E-10) {
                PsDebug.warning("volume range of vectors is a single point, cannot scale.");
                return false;
            }
            dArray[n2] = (pdVectorArray[1].getEntry(n2) - pdVectorArray[0].getEntry(n2)) / d;
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < n3; ++i) {
                pdVectorArray2[n2].m_data[i] = (pdVectorArray2[n2].m_data[i] - pdVector.m_data[i]) * dArray[i] + pdVectorArray[0].m_data[i];
            }
        }
        return true;
    }

    public static final boolean min(PdVector pdVector, PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < n || pdVectorArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (pdVector == null || pdVector.m_data == null) {
            PsDebug.warning("missing min argument");
            return false;
        }
        int n2 = pdVector.getSize();
        double[] dArray = pdVector.m_data;
        pdVector.setConstant(Double.POSITIVE_INFINITY);
        for (int i = 0; i < n; ++i) {
            if (pdVectorArray[i] == null || pdVectorArray[i].m_data == null) continue;
            double[] dArray2 = pdVectorArray[i].m_data;
            int n3 = dArray2.length;
            if (n3 > n2) {
                n3 = n2;
            }
            for (int j = 0; j < n3; ++j) {
                if (!(dArray[j] > dArray2[j])) continue;
                dArray[j] = dArray2[j];
            }
        }
        return true;
    }

    public static final boolean max(PdVector pdVector, PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < n || pdVectorArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (pdVector == null || pdVector.m_data == null) {
            PsDebug.warning("missing max argument");
            return false;
        }
        if (n == 0) {
            pdVector.setConstant(0.0);
            return false;
        }
        int n2 = pdVector.getSize();
        double[] dArray = pdVector.m_data;
        pdVector.setConstant(Double.NEGATIVE_INFINITY);
        for (int i = 0; i < n; ++i) {
            if (pdVectorArray[i] == null || pdVectorArray[i].m_data == null) continue;
            double[] dArray2 = pdVectorArray[i].m_data;
            int n3 = dArray2.length;
            if (n3 > n2) {
                n3 = n2;
            }
            for (int j = 0; j < n3; ++j) {
                if (!(dArray[j] < dArray2[j])) continue;
                dArray[j] = dArray2[j];
            }
        }
        return true;
    }

    public boolean min(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument vector");
            return false;
        }
        int n = Math.min(this.getSize(), pdVector.getSize());
        double[] dArray = pdVector.m_data;
        for (int i = 0; i < n; ++i) {
            if (!(this.m_data[i] > dArray[i])) continue;
            this.m_data[i] = dArray[i];
        }
        return true;
    }

    public boolean max(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument vector");
            return false;
        }
        int n = Math.min(this.getSize(), pdVector.getSize());
        double[] dArray = pdVector.m_data;
        for (int i = 0; i < n; ++i) {
            if (!(this.m_data[i] < dArray[i])) continue;
            this.m_data[i] = dArray[i];
        }
        return true;
    }

    public static void setConstant(PdVector[] pdVectorArray, double d) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray[0] == null) {
            return;
        }
        for (int i = 0; i < pdVectorArray.length; ++i) {
            pdVectorArray[i].setConstant(d);
        }
    }

    public static void setConstant(PdVector[] pdVectorArray, double[] dArray) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray[0] == null) {
            return;
        }
        int n = pdVectorArray[0].m_data.length;
        if (n != dArray.length) {
            PsDebug.warning("arrays have different length");
            return;
        }
        for (int i = 0; i < pdVectorArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                pdVectorArray[i].m_data[j] = dArray[j];
            }
        }
    }

    public static void setConstant(PdVector[] pdVectorArray, PdVector pdVector) {
        if (pdVector == null || pdVector.m_data == null) {
            return;
        }
        PdVector.setConstant(pdVectorArray, pdVector.m_data);
    }

    public static void setConstant(PdVector pdVector, double d) {
        if (pdVector == null || pdVector.m_data == null) {
            return;
        }
        int n = pdVector.m_data.length;
        for (int i = 0; i < n; ++i) {
            pdVector.m_data[i] = d;
        }
    }

    public void setConstant(double d) {
        if (this.m_data == null) {
            return;
        }
        int n = this.m_data.length;
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = d;
        }
    }

    public static double getOrientation(PdVector[] pdVectorArray) {
        return PdVector.det(pdVectorArray);
    }

    public static double det(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length == 0) {
            PsDebug.warning("missing argument vector array");
            return 0.0;
        }
        int n = pdVectorArray.length;
        PdMatrix pdMatrix = new PdMatrix(n);
        for (int i = 0; i < n; ++i) {
            if (pdVectorArray[i] == null || pdVectorArray[i].getSize() < n) {
                PsDebug.warning("missing or invalid vector v[" + i + "]");
                return 0.0;
            }
            for (int j = 0; j < n; ++j) {
                pdMatrix.m_data[i][j] = pdVectorArray[i].m_data[j];
            }
        }
        return pdMatrix.det();
    }

    public static double det(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing argument vector");
            return 0.0;
        }
        if (pdVector.m_data.length != 3 || pdVector2.m_data.length != 3 || pdVector3.m_data.length != 3) {
            PsDebug.warning("all vectors must have dimesion==3.");
            return 0.0;
        }
        double d = (pdVector.m_data[1] * pdVector2.m_data[2] - pdVector.m_data[2] * pdVector2.m_data[1]) * pdVector3.m_data[0] + (-pdVector.m_data[0] * pdVector2.m_data[2] + pdVector.m_data[2] * pdVector2.m_data[0]) * pdVector3.m_data[1] + (pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0]) * pdVector3.m_data[2];
        return d;
    }

    public static double area(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        int n = pdVector.getSize();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (pdVector2.m_data[i] - pdVector.m_data[i]) * (pdVector2.m_data[i] - pdVector.m_data[i]);
            d2 += (pdVector2.m_data[i] - pdVector.m_data[i]) * (pdVector3.m_data[i] - pdVector.m_data[i]);
            d3 += (pdVector3.m_data[i] - pdVector.m_data[i]) * (pdVector3.m_data[i] - pdVector.m_data[i]);
        }
        double d4 = d * d3 - d2 * d2;
        if (d4 <= 0.0) {
            return 0.0;
        }
        return 0.5 * Math.sqrt(d4);
    }

    public static double area(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            PsDebug.warning("missing points");
            return 0.0;
        }
        if (pdVectorArray.length < 3) {
            PsDebug.warning("array must have length >=3", pdVectorArray);
            return 0.0;
        }
        double d = 0.0;
        for (int i = 2; i < pdVectorArray.length; ++i) {
            d += PdVector.area(pdVectorArray[0], pdVectorArray[i - 1], pdVectorArray[i]);
        }
        return d;
    }

    public static double angle(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        double d = pdVector.sqrDist(pdVector2);
        double d2 = pdVector.sqrDist(pdVector3);
        if (d == 0.0 || d2 == 0.0) {
            PsDebug.notify("triangle is degenerated");
            return 0.0;
        }
        double d3 = PdVector.dot(pdVector, pdVector2, pdVector3) / Math.sqrt(d * d2);
        if (d3 < -1.0) {
            d3 = -1.0;
        } else if (d3 > 1.0) {
            d3 = 1.0;
        }
        return Math.acos(d3) * 180.0 / Math.PI;
    }

    public static void angle(double[] dArray, PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdVector.angle(dArray, new PdVector[]{pdVector, pdVector2, pdVector3});
    }

    public static void angle(double[] dArray, PdVector[] pdVectorArray) {
        int n;
        int n2 = pdVectorArray.length;
        PdVector[] pdVectorArray2 = new PdVector[n2];
        for (n = 0; n < n2; ++n) {
            pdVectorArray2[n] = PdVector.subNew(pdVectorArray[(n + 1) % n2], pdVectorArray[n]);
            pdVectorArray2[n].normalize();
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = PdVector.dot(pdVectorArray2[(n - 1 + n2) % n2], pdVectorArray2[n]);
            if (dArray[n] < -1.0) {
                dArray[n] = -1.0;
            } else if (dArray[n] > 1.0) {
                dArray[n] = 1.0;
            }
            dArray[n] = Math.PI - Math.acos(dArray[n]);
        }
    }

    public static double angleWithOrientation(double[] dArray, PdVector[] pdVectorArray, int n) {
        int n2;
        if (dArray == null || pdVectorArray == null) {
            PsDebug.warning("missing angle or vertex array.");
            return 0.0;
        }
        if (dArray.length < n || pdVectorArray.length < n) {
            PsDebug.warning("angle or vertex array too small.");
            return 0.0;
        }
        if (pdVectorArray.length < 1 || pdVectorArray[0] == null) {
            PsDebug.warning("empty polygon, no vertex found.");
            return 0.0;
        }
        int n3 = pdVectorArray[0].getSize();
        PdVector[] pdVectorArray2 = new PdVector[n];
        PdVector pdVector = new PdVector(n3);
        PdVector pdVector2 = new PdVector(n3);
        for (n2 = 0; n2 < n; ++n2) {
            pdVectorArray2[n2] = PdVector.subNew(pdVectorArray[(n2 + 1) % n], pdVectorArray[n2]);
            pdVectorArray2[n2].normalize();
        }
        boolean bl = true;
        double d = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = (n2 - 1 + n) % n;
            dArray[n2] = PdVector.dot(pdVectorArray2[n4], pdVectorArray2[n2]);
            if (dArray[n2] < -1.0) {
                dArray[n2] = -1.0;
            } else if (dArray[n2] > 1.0) {
                dArray[n2] = 1.0;
            }
            dArray[n2] = Math.acos(dArray[n2]);
            if (!bl) {
                dArray[n2] = -dArray[n2];
            }
            d += dArray[n2];
            int n5 = (n2 + 1) % n;
            pdVector = pdVectorArray2[n4].orthogonalPart(pdVector, pdVectorArray2[n2]);
            if (!(PdVector.dot(pdVector2 = pdVectorArray2[n5].orthogonalPart(pdVector2, pdVectorArray2[n2]), pdVector) > 1.0E-10)) continue;
            bl = !bl;
        }
        if (d < 0.0) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = -dArray[n2];
            }
            d = -d;
        }
        return d;
    }

    public static double angle(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        double d = pdVector.sqrLength();
        double d2 = pdVector2.sqrLength();
        if (d == 0.0 || d2 == 0.0) {
            PsDebug.notify("vector with zero length");
            return 0.0;
        }
        double d3 = PdVector.dot(pdVector, pdVector2) / Math.sqrt(d * d2);
        if (d3 < -1.0) {
            d3 = -1.0;
        } else if (d3 > 1.0) {
            d3 = 1.0;
        }
        d3 = Math.acos(d3) * 180.0 / Math.PI;
        return d3;
    }

    public static double angleWithOrientation(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        double d = pdVector.length();
        double d2 = pdVector2.length();
        if (d < 1.0E-10 || d2 < 1.0E-10) {
            PsDebug.notify("vector with zero length");
            return 0.0;
        }
        double d3 = PdVector.dot(pdVector, pdVector2) / d / d2;
        if (d3 < -1.0) {
            d3 = -1.0;
        } else if (d3 > 1.0) {
            d3 = 1.0;
        }
        d3 = Math.acos(d3);
        if (pdVector.getSize() == 3) {
            if (PdVector.det(pdVector, pdVector2, pdVector3) < 0.0) {
                d3 = -d3;
            }
        } else {
            if (pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0] < 0.0) {
                d3 = -d3;
            }
            if (pdVector3.m_data[2] < 0.0) {
                d3 = -d3;
            }
        }
        return d3;
    }

    public static double dot(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        int n = pdVector.m_data.length;
        if (n != pdVector2.m_data.length) {
            PsDebug.warning("vectors have different dimension");
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += pdVector.m_data[i] * pdVector2.m_data[i];
        }
        return d;
    }

    public static double dot(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        int n = pdVector.m_data.length;
        if (n != pdVector2.m_data.length || n != pdVector3.m_data.length) {
            PsDebug.warning("vectors have incompatible size");
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (pdVector2.m_data[i] - pdVector.m_data[i]) * (pdVector3.m_data[i] - pdVector.m_data[i]);
        }
        return d;
    }

    public static double dotDir(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        if (pdVector == null || pdVector3 == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        int n = pdVector.m_data.length;
        if (n != pdVector3.m_data.length || n != pdVector2.m_data.length) {
            PsDebug.warning("vectors have incompatible size");
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += pdVector.m_data[i] * (pdVector2.m_data[i] - pdVector3.m_data[i]);
        }
        return d;
    }

    public static double sqrDist(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        int n = pdVector.m_data.length;
        if (n != pdVector2.m_data.length) {
            PsDebug.warning("vectors have incompatible size");
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = pdVector.m_data[i] - pdVector2.m_data[i];
            d += d2 * d2;
        }
        return d;
    }

    public static double dist(PdVector pdVector, PdVector pdVector2) {
        return Math.sqrt(PdVector.sqrDist(pdVector, pdVector2));
    }

    public static PdVector flatten(PdVector[] pdVectorArray) {
        return PdVector.flatten(pdVectorArray, null);
    }

    public static PdVector flatten(PdVector[] pdVectorArray, PdVector pdVector) {
        int n;
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument");
            return pdVector;
        }
        int n2 = pdVectorArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += pdVectorArray[n].m_data.length;
        }
        if (pdVector == null) {
            pdVector = new PdVector(n3);
        } else {
            pdVector.setSize(n3);
        }
        n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = pdVectorArray[i].m_data.length;
            for (int j = 0; j < n; ++j) {
                pdVector.m_data[n3++] = pdVectorArray[i].m_data[j];
            }
        }
        return pdVector;
    }

    public PdVector() {
        this(0);
    }

    public PdVector(int n) {
        this.m_data = new double[n];
    }

    public PdVector(double d) {
        this(1);
        this.m_data[0] = d;
    }

    public PdVector(double d, double d2) {
        this(2);
        this.m_data[0] = d;
        this.m_data[1] = d2;
    }

    public PdVector(double d, double d2, double d3) {
        this(3);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public PdVector(double d, double d2, double d3, double d4) {
        this(4);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        this.m_data[3] = d4;
    }

    public PdVector(double[] dArray) {
        this();
        this.set(dArray);
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int n) {
        if (this.m_data == null) {
            this.m_data = new double[n];
        } else if (this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
        return n;
    }

    public double[] getEntries() {
        return (double[])this.m_data.clone();
    }

    public double getEntry(int n) {
        if (n < 0 || this.m_data.length <= n) {
            PsDebug.warning("index out of range, index=" + n);
            return 0.0;
        }
        return this.m_data[n];
    }

    public void setEntry(int n, double d) {
        if (n < 0) {
            PsDebug.warning("index out of range, index=" + n);
            return;
        }
        if (this.m_data.length <= n) {
            this.setSize(n + 1);
        }
        this.m_data[n] = d;
    }

    public void setEntry(int n, int n2) {
        this.setEntry(n, (double)n2);
    }

    public double getFirstEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0.0;
        }
        return this.m_data[0];
    }

    public void setFirstEntry(double d) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[0] = d;
    }

    public double getLastEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0.0;
        }
        return this.m_data[this.m_data.length - 1];
    }

    public void setLastEntry(double d) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[this.m_data.length - 1] = d;
    }

    public int addEntry(double d) {
        int n = this.setSize(this.getSize() + 1);
        this.m_data[n - 1] = d;
        return n;
    }

    public void removeEntry(int n) {
        int n2 = this.getSize();
        if (n < 0 || n >= n2) {
            PsDebug.warning("Index out of range. Cannot delete vector index " + n);
            return;
        }
        for (int i = n + 1; i < n2; ++i) {
            this.m_data[i - 1] = this.m_data[i];
        }
        this.setSize(n2 - 1);
    }

    public void concat(PdVector pdVector) {
        int n = this.getSize();
        int n2 = pdVector.getSize();
        this.setSize(n + n2);
        this.copy(n, pdVector, 0, n2);
    }

    public void set(PdVector pdVector, int n, int n2) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pdVector.getSize() < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.m_data[i] = pdVector.m_data[n + i];
        }
    }

    public void set(double[] dArray, int n, int n2) {
        if (dArray == null || dArray.length < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.m_data[i] = dArray[n + i];
        }
    }

    public void set(double[] dArray, int n) {
        this.set(dArray, 0, n);
    }

    public void set(double[] dArray) {
        if (dArray == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(dArray, 0, dArray.length);
    }

    public void set(int[] nArray, int n, int n2) {
        if (nArray == null || nArray.length < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.m_data[i] = nArray[n + i];
        }
    }

    public void set(int[] nArray, int n) {
        this.set(nArray, 0, n);
    }

    public void set(int[] nArray) {
        if (nArray == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(nArray, 0, nArray.length);
    }

    public void set(double d) {
        if (this.m_data == null || this.m_data.length < 1) {
            this.setSize(1);
        }
        this.m_data[0] = d;
    }

    public void set(double d, double d2) {
        if (this.m_data == null || this.m_data.length < 2) {
            this.setSize(2);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
    }

    public void set(double d, double d2, double d3) {
        if (this.m_data == null || this.m_data.length < 3) {
            this.setSize(3);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public void set(double d, double d2, double d3, double d4) {
        if (this.m_data == null || this.m_data.length < 4) {
            this.setSize(4);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        this.m_data[3] = d4;
    }

    public int changeValue(int n, double d, double d2) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.m_data[i] != d) continue;
            this.m_data[i] = d2;
            ++n2;
        }
        return n2;
    }

    public int changeValue(double d, double d2) {
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (this.m_data[i] != d) continue;
            this.m_data[i] = d2;
            ++n;
        }
        return n;
    }

    public void shift(int n) {
        int n2 = this.m_data.length;
        if (n2 < 2) {
            return;
        }
        if (n > n2 - 1) {
            n %= n2;
        } else if (n < 1 - n2) {
            n = -(Math.abs(n) % n2);
        }
        if (n == 0) {
            return;
        }
        if (n > n2 / 2) {
            n -= n2;
        } else if (n < -n2 / 2) {
            n += n2;
        }
        if (n > 0) {
            int n3;
            double[] dArray = new double[n];
            for (n3 = 0; n3 < n; ++n3) {
                dArray[n3] = this.m_data[n2 - n + n3];
            }
            for (n3 = n2 - 1; n3 > n - 1; --n3) {
                this.m_data[n3] = this.m_data[n3 - n];
            }
            for (n3 = n - 1; n3 > -1; --n3) {
                this.m_data[n3] = dArray[n3];
            }
        } else {
            int n4;
            double[] dArray = new double[-n];
            for (n4 = 0; n4 < -n; ++n4) {
                dArray[n4] = this.m_data[n4];
            }
            for (n4 = 0; n4 < n2 + n; ++n4) {
                this.m_data[n4] = this.m_data[n4 - n];
            }
            for (n4 = 0; n4 < -n; ++n4) {
                this.m_data[n2 + n + n4] = dArray[n4];
            }
        }
    }

    public void invert(int n) {
        int n2 = n / 2;
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            double d = this.m_data[i];
            this.m_data[i] = this.m_data[n3];
            this.m_data[n3] = d;
            --n3;
        }
    }

    public void invert() {
        int n = this.m_data.length;
        int n2 = n / 2;
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            double d = this.m_data[i];
            this.m_data[i] = this.m_data[n3];
            this.m_data[n3] = d;
            --n3;
        }
    }

    public void add(double d) {
        if (this.m_data == null) {
            return;
        }
        int n = this.m_data.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            this.m_data[n3] = this.m_data[n3] + d;
        }
    }

    public void add(PdVector pdVector) {
        int n;
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if ((n = this.m_data.length) != pdVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.m_data[n2] = this.m_data[n2] + pdVector.m_data[i];
        }
    }

    public void add(double d, PdVector pdVector) {
        int n;
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if ((n = this.m_data.length) != pdVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.m_data[n2] = this.m_data[n2] + d * pdVector.m_data[i];
        }
    }

    public void add(PdVector pdVector, PdVector pdVector2) {
        int n;
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if ((n = this.m_data.length) != pdVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = pdVector.m_data[i] + pdVector2.m_data[i];
        }
    }

    public void sub(PdVector pdVector) {
        int n;
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if ((n = this.m_data.length) != pdVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.m_data[n2] = this.m_data[n2] - pdVector.m_data[i];
        }
    }

    public void sub(PdVector pdVector, PdVector pdVector2) {
        int n;
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if ((n = this.m_data.length) != pdVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = pdVector.m_data[i] - pdVector2.m_data[i];
        }
    }

    public static PdVector addNew(PdVector pdVector, PdVector pdVector2) {
        int n;
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int n2 = pdVector.getSize();
        if (n2 != (n = pdVector2.getSize())) {
            PsDebug.warning("different size of argument vectors");
            n2 = Math.min(n2, n);
        }
        PdVector pdVector3 = new PdVector(n2);
        pdVector3.add(pdVector, pdVector2);
        return pdVector3;
    }

    public static PdVector subNew(PdVector pdVector, PdVector pdVector2) {
        int n;
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int n2 = pdVector.getSize();
        if (n2 != (n = pdVector2.getSize())) {
            PsDebug.warning("different size of argument vectors");
            n2 = Math.min(n2, n);
        }
        PdVector pdVector3 = new PdVector(n2);
        pdVector3.sub(pdVector, pdVector2);
        return pdVector3;
    }

    public static PdVector copyNew(PdVector pdVector) {
        if (pdVector == null) {
            return null;
        }
        if (pdVector.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PdVector pdVector2 = new PdVector(pdVector.m_data.length);
        pdVector2.copy(pdVector);
        return pdVector2;
    }

    public boolean copy(int n, PdVector pdVector, int n2, int n3) {
        if (this.m_data.length < n + n3) {
            PsDebug.warning("missing space in this");
            return false;
        }
        if (this.m_data == null || this.m_data.length < n + n3) {
            this.setSize(n + n3);
        }
        System.arraycopy(pdVector.m_data, n2, this.m_data, n, n3);
        return true;
    }

    public void copy(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (pdVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        this.copyArray(pdVector);
        super.copy(pdVector);
    }

    public void copyArray(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (pdVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        int n = pdVector.m_data.length;
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n);
        }
        if (this.m_data.length > n) {
            for (int i = n; i < this.m_data.length; ++i) {
                this.m_data[i] = 0.0;
            }
        } else {
            n = this.m_data.length;
        }
        switch (n) {
            case 3: {
                if (this.m_data[2] != pdVector.m_data[2]) {
                    this.m_data[2] = pdVector.m_data[2];
                }
            }
            case 2: {
                if (this.m_data[1] != pdVector.m_data[1]) {
                    this.m_data[1] = pdVector.m_data[1];
                }
            }
            case 1: {
                if (this.m_data[0] == pdVector.m_data[0]) break;
                this.m_data[0] = pdVector.m_data[0];
                break;
            }
            default: {
                System.arraycopy(pdVector.m_data, 0, this.m_data, 0, n);
            }
        }
    }

    public void copyArray_fastTmp(PdVector pdVector) {
        int n = pdVector.m_data.length;
        switch (n) {
            case 4: {
                this.m_data[3] = pdVector.m_data[3];
            }
            case 3: {
                this.m_data[2] = pdVector.m_data[2];
            }
            case 2: {
                this.m_data[1] = pdVector.m_data[1];
            }
            case 1: {
                this.m_data[0] = pdVector.m_data[0];
                break;
            }
            case 0: {
                break;
            }
            default: {
                System.arraycopy(pdVector.m_data, 0, this.m_data, 0, n);
            }
        }
    }

    public void copy(double[] dArray, int n) {
        if (dArray == null) {
            PsDebug.warning("null vector 'anArray' passed");
            return;
        }
        int n2 = n;
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n2);
        }
        if (this.m_data.length > n2) {
            for (int i = n2; i < this.m_data.length; ++i) {
                this.m_data[i] = 0.0;
            }
        } else {
            n2 = this.m_data.length;
        }
        switch (n2) {
            case 3: {
                this.m_data[2] = dArray[2];
            }
            case 2: {
                this.m_data[1] = dArray[1];
            }
            case 1: {
                this.m_data[0] = dArray[0];
                break;
            }
            default: {
                System.arraycopy(dArray, 0, this.m_data, 0, n2);
            }
        }
    }

    public void copy(double[] dArray, int n, int n2) {
        if (dArray == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (dArray.length < n + n2) {
            PsDebug.warning("ind+size is bigger than array");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(n2);
        }
        int n3 = this.m_data.length;
        int n4 = Math.min(n3, n2);
        System.arraycopy(dArray, n, this.m_data, 0, n4);
        for (int i = n4; i < n3; ++i) {
            this.m_data[i] = 0.0;
        }
    }

    public void multScalar(double d) {
        int n = this.m_data.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            this.m_data[n3] = this.m_data[n3] * d;
        }
    }

    public void multScalar(PdVector pdVector, double d) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        int n = this.m_data.length;
        if (n != pdVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
        }
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = pdVector.m_data[i] * d;
        }
    }

    public PdVector leftMultMatrix(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            PsDebug.warning("missing argument");
            return this;
        }
        if (pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return this;
        }
        int n = this.m_data.length;
        double[] dArray = (double[])this.m_data.clone();
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                this.m_data[n2] = this.m_data[n2] + pdMatrix.m_data[i][j] * dArray[j];
            }
        }
        return this;
    }

    public void leftMultAffin(PdMatrix pdMatrix, PdVector pdVector, boolean bl) {
        int n;
        if (pdVector == null || pdMatrix == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this == pdVector) {
            PsDebug.warning("this must be different from argument");
            return;
        }
        int n2 = this.m_data.length;
        int n3 = pdVector.getSize();
        if (pdMatrix.m_iSize < n2 || pdMatrix.m_jSize - 1 != n3) {
            PsDebug.warning("argument matrix has incompatible sizes");
            return;
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                this.m_data[n] = pdMatrix.m_data[n][n3];
            }
        } else {
            this.setConstant(0.0);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                int n4 = n;
                this.m_data[n4] = this.m_data[n4] + pdMatrix.m_data[n][i] * pdVector.m_data[i];
            }
        }
    }

    public PdVector leftMultMatrix(PdMatrix pdMatrix, PdVector pdVector) {
        if (this == pdVector) {
            PsDebug.warning("this vector must be different from argument vector");
            return this;
        }
        if (this.m_data.length != pdMatrix.m_iSize) {
            this.setSize(pdMatrix.m_iSize);
        }
        for (int i = 0; i < pdMatrix.m_iSize; ++i) {
            this.m_data[i] = 0.0;
            for (int j = 0; j < pdVector.m_data.length; ++j) {
                int n = i;
                this.m_data[n] = this.m_data[n] + pdMatrix.m_data[i][j] * pdVector.m_data[j];
            }
        }
        return this;
    }

    public void rightMultMatrix(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int n = this.m_data.length;
        double[] dArray = (double[])this.m_data.clone();
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                this.m_data[n2] = this.m_data[n2] + dArray[j] * pdMatrix.m_data[j][i];
            }
        }
    }

    public void rightMultMatrix(PdVector pdVector, PdMatrix pdMatrix) {
        if (pdVector == null || pdMatrix == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this == pdVector) {
            PsDebug.warning("this vector must be different from argument vector");
            return;
        }
        if (this.m_data.length != pdMatrix.m_jSize) {
            this.setSize(pdMatrix.m_jSize);
        }
        for (int i = 0; i < pdMatrix.m_jSize; ++i) {
            this.m_data[i] = 0.0;
            for (int j = 0; j < pdMatrix.m_iSize; ++j) {
                int n = i;
                this.m_data[n] = this.m_data[n] + pdVector.m_data[j] * pdMatrix.m_data[j][i];
            }
        }
    }

    public double dot(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        int n = this.m_data.length;
        if (n != pdVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            n = Math.min(n, pdVector.m_data.length);
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.m_data[i] * pdVector.m_data[i];
        }
        return d;
    }

    public double sqrLength() {
        double d = 0.0;
        int n = this.m_data.length;
        for (int i = 0; i < n; ++i) {
            d += this.m_data[i] * this.m_data[i];
        }
        return d;
    }

    public double length() {
        return PdVector.length(this.m_data.length, this.m_data);
    }

    public static double length(int n, double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
        }
        return Math.sqrt(d);
    }

    public boolean normalize() {
        return this.setLength(1.0);
    }

    public boolean normalize(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        this.copyArray(pdVector);
        return this.normalize();
    }

    public boolean setLength(double d) {
        int n = this.getSize();
        if (n == 0) {
            return false;
        }
        double d2 = this.length();
        if (d2 < 1.0E-10) {
            this.setConstant(0.0);
            this.setEntry(n - 1, d);
            return false;
        }
        double d3 = d / d2;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            this.m_data[n3] = this.m_data[n3] * d3;
        }
        return true;
    }

    public static PdVector blendNew(double d, PdVector pdVector, double d2, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector pdVector3 = new PdVector(pdVector.getSize());
        pdVector3.blend(d, pdVector, d2, pdVector2);
        return pdVector3;
    }

    public static PdVector blendNew(double d, PdVector pdVector, double d2, PdVector pdVector2, double d3, PdVector pdVector3) {
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector pdVector4 = new PdVector(pdVector.getSize());
        pdVector4.blend(d, pdVector, d2, pdVector2, d3, pdVector3);
        return pdVector4;
    }

    public static PdVector blendNew(double d, PdVector pdVector, double d2, PdVector pdVector2, double d3, PdVector pdVector3, double d4, PdVector pdVector4) {
        if (pdVector == null || pdVector2 == null || pdVector3 == null || pdVector4 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector pdVector5 = new PdVector(pdVector.getSize());
        pdVector5.blend(d, pdVector, d2, pdVector2, d3, pdVector3, d4, pdVector4);
        return pdVector5;
    }

    public void blend(double d, PdVector pdVector, double d2, PdVector pdVector2) {
        int n;
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if ((n = this.m_data.length) != pdVector.m_data.length || n != pdVector2.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = d * pdVector.m_data[i] + d2 * pdVector2.m_data[i];
        }
    }

    public void blend(double d, PdVector pdVector, double d2, PdVector pdVector2, double d3, PdVector pdVector3) {
        int n;
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if ((n = this.m_data.length) != pdVector.m_data.length || n != pdVector2.m_data.length || n != pdVector3.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = d * pdVector.m_data[i] + d2 * pdVector2.m_data[i] + d3 * pdVector3.m_data[i];
        }
    }

    public void blend(double d, PdVector pdVector, double d2, PdVector pdVector2, double d3, PdVector pdVector3, double d4, PdVector pdVector4) {
        int n;
        if (pdVector == null || pdVector2 == null || pdVector3 == null || pdVector4 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if ((n = this.m_data.length) != pdVector.m_data.length || n != pdVector2.m_data.length || n != pdVector3.m_data.length || n != pdVector4.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = d * pdVector.m_data[i] + d2 * pdVector2.m_data[i] + d3 * pdVector3.m_data[i] + d4 * pdVector4.m_data[i];
        }
    }

    public void blendBase(PdVector pdVector, double d, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if (this.m_data.length != pdVector.m_data.length || this.m_data.length != pdVector2.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = pdVector.m_data[i] + d * pdVector2.m_data[i];
        }
    }

    public void blendBase(PdVector pdVector, double d, PdVector pdVector2, double d2, PdVector pdVector3) {
        int n;
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdVector.m_data.length);
        }
        if ((n = this.m_data.length) != pdVector.m_data.length || n != pdVector2.m_data.length || n != pdVector3.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = pdVector.m_data[i] + d * pdVector2.m_data[i] + d2 * pdVector3.m_data[i];
        }
    }

    public double dist(PdVector pdVector) {
        double d = 0.0;
        int n = this.m_data.length;
        for (int i = 0; i < n; ++i) {
            double d2 = this.m_data[i] - pdVector.m_data[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public double sqrDist(PdVector pdVector) {
        double d = 0.0;
        int n = this.m_data.length;
        for (int i = 0; i < n; ++i) {
            double d2 = this.m_data[i] - pdVector.m_data[i];
            d += d2 * d2;
        }
        return d;
    }

    public double max() {
        int n = this.m_data.length;
        if (n == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            if (!(this.m_data[i] > d)) continue;
            d = this.m_data[i];
        }
        return d;
    }

    public double maxAbs() {
        int n = this.m_data.length;
        if (n == 0) {
            return 0.0;
        }
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double d2 = Math.abs(this.m_data[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double min() {
        int n = this.m_data.length;
        if (n == 0) {
            return Double.POSITIVE_INFINITY;
        }
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            if (!(this.m_data[i] < d)) continue;
            d = this.m_data[i];
        }
        return d;
    }

    public int indexOfAbsMax() {
        int n = -1;
        double d = -1.0;
        int n2 = this.m_data.length;
        for (int i = 0; i < n2; ++i) {
            double d2 = Math.abs(this.m_data[i]);
            if (!(d2 > d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public int indexOfAbsMin() {
        int n = -1;
        double d = Double.POSITIVE_INFINITY;
        int n2 = this.m_data.length;
        for (int i = 0; i < n2; ++i) {
            double d2 = Math.abs(this.m_data[i]);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public int indexOfMax() {
        int n = -1;
        double d = Double.NEGATIVE_INFINITY;
        int n2 = this.m_data.length;
        for (int i = 0; i < n2; ++i) {
            if (!(this.m_data[i] > d)) continue;
            d = this.m_data[i];
            n = i;
        }
        return n;
    }

    public int indexOfMin() {
        int n = -1;
        double d = Double.POSITIVE_INFINITY;
        int n2 = this.m_data.length;
        for (int i = 0; i < n2; ++i) {
            if (!(this.m_data[i] < d)) continue;
            d = this.m_data[i];
            n = i;
        }
        return n;
    }

    public int indexOfValueInOrdering(double d) {
        int n = this.m_data.length;
        if (n == 0 || d < this.m_data[0]) {
            return -1;
        }
        int n2 = n - 1;
        if (d > this.m_data[n2]) {
            return n2;
        }
        int n3 = 0;
        while (n2 - n3 > 1) {
            int n4 = n3 + (n2 - n3) / 2;
            if (d > this.m_data[n4]) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        if (this.m_data[n3] >= d) {
            n2 = n3;
        }
        return n2;
    }

    public double sum() {
        int n = this.getSize();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.m_data[i];
        }
        return d;
    }

    public double average() {
        double d = this.sum();
        if (d == 0.0) {
            return 0.0;
        }
        return d / (double)this.getSize();
    }

    public double variance() {
        int n = this.getSize();
        if (n == 0) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = this.average();
        for (int i = 0; i < n; ++i) {
            d += PuMath.sqr(this.m_data[i] - d2);
        }
        return d / (double)n;
    }

    public PdVector sort(PdVector pdVector) {
        int n = this.getSize();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        } else if (pdVector.getSize() != n) {
            pdVector.setSize(n);
        }
        double[] dArray = pdVector.m_data;
        if (n < 10) {
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.m_data[i];
            }
            for (int i = n - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    if (!(dArray[j] > dArray[j + 1])) continue;
                    double d = dArray[j + 1];
                    dArray[j + 1] = dArray[j];
                    dArray[j] = d;
                }
            }
        } else {
            int[] nArray = new int[n];
            PuMath.heapsort(n, this.m_data, nArray);
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.m_data[nArray[i]];
            }
        }
        return pdVector;
    }

    public void sort() {
        int n = this.getSize();
        if (n < 10) {
            for (int i = n - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    if (!(this.m_data[j] > this.m_data[j + 1])) continue;
                    double d = this.m_data[j + 1];
                    this.m_data[j + 1] = this.m_data[j];
                    this.m_data[j] = d;
                }
            }
        } else {
            double[] dArray = (double[])this.m_data.clone();
            int[] nArray = new int[n];
            PuMath.heapsort(n, dArray, nArray);
            for (int i = 0; i < n; ++i) {
                this.m_data[i] = dArray[nArray[i]];
            }
        }
    }

    public boolean cross(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_data.length != 3) {
            return false;
        }
        int n = pdVector.getSize();
        int n2 = pdVector2.getSize();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (n == 3 && n2 == 3) {
            d = pdVector.m_data[1] * pdVector2.m_data[2] - pdVector.m_data[2] * pdVector2.m_data[1];
            d2 = -pdVector.m_data[0] * pdVector2.m_data[2] + pdVector.m_data[2] * pdVector2.m_data[0];
            d3 = pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0];
        } else if (n == 2 && n2 == 3) {
            d = pdVector.m_data[1] * pdVector2.m_data[2];
            d2 = -pdVector.m_data[0] * pdVector2.m_data[2];
            d3 = pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0];
        } else if (n == 3 && n2 == 2) {
            d = -pdVector.m_data[2] * pdVector2.m_data[1];
            d2 = pdVector.m_data[2] * pdVector2.m_data[0];
            d3 = pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0];
        } else if (n == 2 && n2 == 2) {
            d3 = pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0];
        } else {
            PsDebug.warning("wrong dimension of arguments: vSize = " + n + " wSize = " + n2, this);
            return false;
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        return true;
    }

    public static PdVector crossNew(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector pdVector3 = new PdVector(3);
        pdVector3.cross(pdVector, pdVector2);
        return pdVector3;
    }

    public void invStereoProj(double d, double d2) {
        if (this.m_data.length != 3) {
            return;
        }
        double d3 = 1.0 + d * d + d2 * d2;
        this.m_data[0] = 2.0 * d / d3;
        this.m_data[1] = 2.0 * d2 / d3;
        this.m_data[2] = (2.0 - d3) / d3;
    }

    public void orthogonalize(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        this.add(-this.dot(pdVector), pdVector);
    }

    public void orthonormalize(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        this.add(-this.dot(pdVector), pdVector);
        this.normalize();
    }

    public PdVector orthogonalPart(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        if (pdVector == null) {
            pdVector = new PdVector(this.getSize());
        }
        pdVector.blendBase(this, -this.dot(pdVector2), pdVector2);
        return pdVector;
    }

    public PdVector orthogonalPartWrtONB(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector pdVector3 = new PdVector(this.m_data.length);
        double d = this.dot(pdVector);
        double d2 = this.dot(pdVector2);
        for (int i = 0; i < this.m_data.length; ++i) {
            pdVector3.m_data[i] = this.m_data[i] - d * pdVector.m_data[i] - d2 * pdVector2.m_data[i];
        }
        return pdVector3;
    }

    public PdVector projectOntoONB(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null || pdVector2 == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector pdVector3 = new PdVector(this.m_data.length);
        double d = PdVector.dot(this, pdVector);
        double d2 = PdVector.dot(this, pdVector2);
        for (int i = 0; i < this.m_data.length; ++i) {
            pdVector3.m_data[i] = d * pdVector.m_data[i] + d2 * pdVector2.m_data[i];
        }
        return pdVector3;
    }

    public boolean normalOfPlane(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdVector pdVector4;
        if (pdVector == null || pdVector2 == null || pdVector3 == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        PdVector pdVector5 = PdVector.subNew(pdVector, pdVector2);
        if (!this.cross(pdVector5, pdVector4 = PdVector.subNew(pdVector, pdVector3))) {
            return false;
        }
        return this.normalize();
    }

    public void normalToVector(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (Math.abs(pdVector.sqrLength() - 1.0) > 1.0E-10) {
            PsDebug.warning("vector not normalized");
            pdVector.normalize();
        }
        this.setSize(pdVector.getSize());
        this.setConstant(1.0);
        this.m_data[pdVector.indexOfAbsMax()] = 0.0;
        this.orthonormalize(pdVector);
    }

    public static PdVector normalToVectorNew(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector pdVector2 = new PdVector(pdVector.getSize());
        pdVector2.normalToVector(pdVector);
        return pdVector2;
    }

    public boolean equals(double[] dArray) {
        int n = this.getSize();
        if (dArray == null && n == 0) {
            return true;
        }
        if (dArray == null) {
            return false;
        }
        if (n != dArray.length) {
            return false;
        }
        --n;
        while (n >= 0) {
            if (this.m_data[n] != dArray[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof PdVector) {
            return this.equals((PdVector)object);
        }
        if (object instanceof double[]) {
            return this.equals((double[])object);
        }
        return super.equals(object);
    }

    public boolean equals(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        return this.equals(pdVector.m_data);
    }

    public boolean equals(PdVector pdVector, double d) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.getSize() != pdVector.getSize()) {
            return false;
        }
        return PdVector.sqrDist(this, pdVector) <= d * d;
    }

    public boolean lesser(double[] dArray) {
        int n = this.getSize();
        if (dArray == null && n == 0) {
            return true;
        }
        if (dArray == null) {
            return false;
        }
        if (n != dArray.length) {
            return false;
        }
        --n;
        while (n >= 0) {
            if (this.m_data[n] >= dArray[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean lesser(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        return this.lesser(pdVector.m_data);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PdVector ***********\n");
        int n = this.getSize();
        stringBuffer.append("\t size\t = " + n + "\n");
        if (n > 0) {
            stringBuffer.append("\t m_data = (" + String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[i]));
            }
            stringBuffer.append(")\n");
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {}\n");
        } else {
            stringBuffer.append("\t m_data = null\n");
        }
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.getSize();
        if (n > 0) {
            stringBuffer.append("\t {" + String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[i]));
            }
            stringBuffer.append("},");
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {},");
        } else {
            stringBuffer.append("\t m_data = null,");
        }
        stringBuffer.append("\t Attr = (" + this.getBits() + ")\n");
        return stringBuffer.toString();
    }

    public void removeSuccessiveDuplicates() {
        int n = this.getSize();
        int n2 = 1;
        for (int i = 1; i < n; ++i) {
            if (this.m_data[i] == this.m_data[i - 1]) continue;
            this.m_data[n2] = this.m_data[i];
            ++n2;
        }
        this.setSize(n2);
    }
}

