/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.common;

import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.project.PvViewerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PiVector;
import jvx.curve.PgTube;
import vgp.curve.common.PnAsymptOde;
import vgp.curve.common.PnGeodesicOde;
import vgp.curve.common.PnPrincipalCurvatureOde;
import vgp.curve.common.PnShadeOde;
import vgp.curve.common.PnSurfaceOde;
import vgp.surface.common.PgSurface;
import vgp.surface.common.PgSurfaceDescr;

public class PjCurve
extends PjProject {
    public static final int GEODESIC = 0;
    public static final int SHADOW = 1;
    public static final int ASYMPTOTIC = 2;
    public static final int PRINCIPAL_CURVATURE = 3;
    public static final String BASE_SURFACE_NAME = "vgp.surface.common.PgSurface_";
    protected static final double initialLength = 20.0;
    protected static final int initialDiscr = 100;
    protected PgSurface m_geom = new PgSurface(3);
    protected PgPolygon m_curve;
    protected PgTube m_tube;
    protected String m_defaultName = "Torus";
    protected String m_surfaceName;
    protected double m_startU;
    protected double m_startV;
    protected int m_selectedCurve = 0;
    protected PnSurfaceOde m_ode;
    protected PuDouble m_length;
    protected PuInteger m_discr;
    protected PuDouble m_angle;
    protected PuDouble m_thickness;
    protected PuInteger m_tubeDiscr;
    static /* synthetic */ Class class$vgp$curve$common$PjCurve;

    public PjCurve() {
        super("Curves On Surfaces");
        this.m_geom.showElements(false);
        this.m_geom.setParent((PsUpdateIf)this);
        this.m_curve = new PgPolygon(3);
        this.m_curve.setName("Curve");
        this.m_tube = new PgTube(3);
        this.m_tube.setName("Tube");
        this.m_tube.setPolygon(this.m_curve);
        this.m_length = new PuDouble("Length", (PsUpdateIf)this);
        this.m_discr = new PuInteger("Polygon Discr", (PsUpdateIf)this);
        this.m_angle = new PuDouble("Direction", (PsUpdateIf)this);
        this.m_thickness = new PuDouble("Thickness", (PsUpdateIf)this);
        this.m_tubeDiscr = new PuInteger("Tube Discr", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$common$PjCurve == null ? (class$vgp$curve$common$PjCurve = PjCurve.class$("vgp.curve.common.PjCurve")) : class$vgp$curve$common$PjCurve)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addGeometry((PgGeometryIf)this.m_curve);
        this.addGeometry((PgGeometryIf)this.m_tube);
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.m_tube.setDiscr(6);
        this.m_tube.setThickness(0.1);
        this.m_length.setDefBounds(0.1, 200.0, 1.0, 5.0);
        this.m_length.setDefValue(20.0);
        this.m_length.init();
        this.m_discr.setDefBounds(2, 400, 1, 5);
        this.m_discr.setDefValue(100);
        this.m_discr.init();
        this.m_angle.setDefBounds(0.0, Math.PI * 2, 0.1, 0.5);
        this.m_angle.setDefValue(1.0);
        this.m_angle.init();
        this.m_thickness.setDefBounds(0.05, 2.0, 0.05, 0.2);
        this.m_thickness.setDefValue(this.m_tube.getThickness().getValue());
        this.m_thickness.init();
        this.m_tubeDiscr.setDefBounds(2, 10, 1, 2);
        this.m_tubeDiscr.setDefValue(6);
        this.m_tubeDiscr.init();
        this.selectCurve(this.m_selectedCurve);
        this.setSurfaceName(this.m_defaultName);
    }

    public void start() {
        PvViewerIf pvViewerIf = this.getViewer();
        String string = pvViewerIf.getParameter("SurfaceName");
        if (string == null) {
            string = this.m_defaultName;
        }
        this.setSurfaceName(string);
        super.start();
    }

    public boolean update(Object object) {
        if (object == this.m_length) {
            this.calculateCurve();
            return true;
        }
        if (object == this.m_discr) {
            this.calculateCurve();
            return true;
        }
        if (object == this.m_angle) {
            this.calculateCurve();
            return true;
        }
        if (object == this.m_thickness) {
            this.m_tube.setThickness(this.m_thickness.getValue());
            return this.m_tube.update((Object)this.m_curve);
        }
        if (object == this.m_tubeDiscr) {
            this.m_tube.setDiscr(this.m_tubeDiscr.getValue());
            return this.m_tube.update((Object)this.m_curve);
        }
        if (object == this.m_geom) {
            this.calculateCurve();
            return true;
        }
        return super.update(object);
    }

    public String getSurfaceName() {
        return this.m_surfaceName;
    }

    public boolean setSurfaceName(String string) {
        if (string == null) {
            return false;
        }
        if (!this.m_geom.setSurfaceName(string, BASE_SURFACE_NAME)) {
            if (!this.m_geom.setSurfaceName(this.m_defaultName, BASE_SURFACE_NAME)) {
                PsDebug.warning((String)("Even could not find default class = vgp.surface.common.PgSurface_" + this.m_defaultName));
                return false;
            }
            this.m_surfaceName = this.m_defaultName;
        } else {
            this.m_surfaceName = string;
        }
        PgSurfaceDescr pgSurfaceDescr = this.m_geom.getDescr();
        if (this.m_ode != null) {
            this.m_ode.setSurface(pgSurfaceDescr);
        }
        this.m_startU = (2.0 * pgSurfaceDescr.getUMax() + 3.0 * pgSurfaceDescr.getUMin()) / 5.0;
        this.m_startV = (2.0 * pgSurfaceDescr.getVMax() + 3.0 * pgSurfaceDescr.getVMin()) / 5.0;
        this.update((Object)this);
        this.m_geom.computeSurface();
        this.m_geom.update((Object)this.m_geom);
        this.calculateCurve();
        this.fitDisplays();
        return true;
    }

    public boolean selectCurve(int n) {
        this.m_selectedCurve = n;
        switch (this.m_selectedCurve) {
            case 1: {
                this.m_ode = new PnShadeOde();
                this.m_curve.setName("Shadow Line");
                break;
            }
            case 2: {
                this.m_ode = new PnAsymptOde();
                this.m_curve.setName("Asymptotic");
                break;
            }
            case 3: {
                this.m_ode = new PnPrincipalCurvatureOde();
                this.m_curve.setName("Principal Curv");
                break;
            }
            default: {
                this.m_ode = new PnGeodesicOde();
                this.m_curve.setName("Geodesic");
            }
        }
        this.m_ode.setSurface(this.m_geom.getDescr());
        return true;
    }

    public void calculateCurve() {
        if (this.m_geom == null) {
            return;
        }
        double[] dArray = new double[]{this.m_startU, this.m_startV, Math.cos(this.m_angle.getValue()), Math.sin(this.m_angle.getValue())};
        double d = this.m_discr.getValue();
        double d2 = this.m_length.getValue();
        if (d > 0.0) {
            d2 /= d;
        }
        this.m_ode.setInitialData(0.0, dArray, d2, this.m_length.getValue());
        this.m_ode.solve(this.m_curve);
        this.m_curve.update((Object)this.m_curve);
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        int n;
        PsDebug.notify((String)("pos = " + pvPickEvent.getVertex().toShortString()));
        if (this.m_geom == null || pvPickEvent.getGeometry() != this.m_geom) {
            return;
        }
        PgSurfaceDescr pgSurfaceDescr = this.m_geom.getDescr();
        int n2 = pgSurfaceDescr.getNumULines();
        int n3 = pgSurfaceDescr.getNumVLines();
        double d = (pgSurfaceDescr.getUMax() - pgSurfaceDescr.getUMin()) / (-1.0 + (double)n2);
        double d2 = (pgSurfaceDescr.getVMax() - pgSurfaceDescr.getVMin()) / (-1.0 + (double)n3);
        int n4 = pvPickEvent.getElementInd();
        if (n4 == -1) {
            return;
        }
        PiVector[] piVectorArray = this.m_geom.getElements();
        int n5 = pvPickEvent.getElementSubInd();
        PdBary pdBary = pvPickEvent.getBary();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray2[0] = pgSurfaceDescr.getVMin() + (double)(piVectorArray[n4].m_data[0] % n3) * d2;
        dArray[0] = pgSurfaceDescr.getUMin() + (double)(piVectorArray[n4].m_data[0] / n3) * d;
        for (n = 0; n < 2; ++n) {
            dArray2[n + 1] = pgSurfaceDescr.getVMin() + (double)(piVectorArray[n4].m_data[n5 + n] % n3) * d2;
            dArray[n + 1] = pgSurfaceDescr.getUMin() + (double)(piVectorArray[n4].m_data[n5 + n] / n3) * d;
        }
        this.m_startV = 0.0;
        this.m_startU = 0.0;
        for (n = 0; n < 3; ++n) {
            this.m_startV += pdBary.m_data[n] * dArray2[n];
            this.m_startU += pdBary.m_data[n] * dArray[n];
        }
        this.calculateCurve();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

