/*
 * Decompiled with CFR 0.152.
 */
package vgp.imageSource;

import java.awt.Color;
import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.object.PsUpdateIf;
import jvx.imageDisplay.PiImageSource;

public class PiDomainImage
extends PiImageSource {
    private PuComplex[] m_pixIter;
    protected PuDouble m_angleOffset;
    static /* synthetic */ Class class$vgp$imageSource$PiDomainImage;

    public PiDomainImage() {
        this.setName("Domain Image");
        this.m_pixIter = new PuComplex[0];
        this.m_angleOffset = new PuDouble("Angle Offset");
        this.m_angleOffset.addUpdateListener((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$imageSource$PiDomainImage == null ? (class$vgp$imageSource$PiDomainImage = PiDomainImage.class$("vgp.imageSource.PiDomainImage")) : class$vgp$imageSource$PiDomainImage)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_pixIter = null;
        this.m_angleOffset.setDefValue(0.0);
        this.m_angleOffset.setDefBounds(0.0, Math.PI * 2, 0.01, 0.1);
        this.m_angleOffset.init();
        this.setDomainBounds(-1.0, -1.0, 1.0, 1.0);
        this.m_blockSize.setValue(1);
    }

    public boolean update(Object object) {
        if (object == this.m_angleOffset) {
            this.compute();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public boolean setImageSize(int n, int n2) {
        if (!super.setImageSize(n, n2)) {
            return false;
        }
        this.m_pixIter = new PuComplex[this.m_imageWidth * this.m_imageHeight];
        for (int i = this.m_imageWidth * this.m_imageHeight - 1; i >= 0; --i) {
            this.m_pixIter[i] = new PuComplex();
        }
        return true;
    }

    public synchronized void compute() {
        if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
            return;
        }
        int n = this.m_blockSize.getValue();
        double d = this.m_domainBounds.m_data[0];
        double d2 = this.m_domainBounds.m_data[2];
        double d3 = this.m_domainBounds.m_data[1];
        double d4 = this.m_domainBounds.m_data[3];
        this.compute(this.m_pixIter, this.m_imageWidth, this.m_imageHeight, n, d, d3, d2, d4);
        this.computeColors();
    }

    private void compute(PuComplex[] puComplexArray, int n, int n2, int n3, double d, double d2, double d3, double d4) {
        if (n <= 1 || n2 <= 1) {
            return;
        }
        PuComplex puComplex = new PuComplex();
        PuComplex puComplex2 = new PuComplex();
        double d5 = (double)n3 * (d3 - d) / ((double)n - 1.0);
        double d6 = (double)n3 * (d4 - d2) / ((double)n2 - 1.0);
        int n4 = 0;
        double d7 = d4 - d6 / 2.0;
        for (int i = 0; i < n2; i += n3) {
            int n5;
            int n6;
            int n7;
            int n8 = n4;
            double d8 = d + d5 / 2.0;
            for (n7 = 0; n7 < n; n7 += n3) {
                puComplex.set(d8 - 1.0, d7);
                puComplex.mult(puComplex);
                puComplex2.set(d8 + 1.0, d7);
                puComplex2.mult(puComplex2);
                puComplex2.mult(puComplex);
                n6 = Math.min(n3, n - n7);
                for (n5 = 0; n5 < n6; ++n5) {
                    puComplexArray[n4++].copy(puComplex2);
                }
                d8 += d5;
            }
            n7 = Math.min(n3, n2 - i) - 1;
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = n8;
                for (int j = 0; j < n; ++j) {
                    puComplexArray[n4++].copy(puComplexArray[n5++]);
                }
            }
            d7 -= d6;
        }
    }

    public void computeColors() {
        if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
            return;
        }
        int n = this.m_imageWidth * this.m_imageHeight;
        this.computeColors(this.m_pix.m_data, this.m_pixIter, n, this.m_angleOffset.getValue(), this.m_imageWidth, this.m_imageHeight, this.m_blockSize.getValue());
        super.computeColors();
    }

    private void computeColors(int[] nArray, PuComplex[] puComplexArray, int n, double d, int n2, int n3, int n4) {
        int n5 = 0;
        for (int i = 0; i < n3; i += n4) {
            int n6;
            int n7 = n5;
            for (n6 = 0; n6 < n2; n6 += n4) {
                PuComplex puComplex = puComplexArray[n5];
                int n8 = this.getColorImpl(puComplex.re, puComplex.im, d);
                int n9 = Math.min(n4, n2 - n6);
                for (int j = 0; j < n9; ++j) {
                    nArray[n5++] = n8;
                }
            }
            n6 = Math.min(n4, n3 - i) - 1;
            for (int j = 0; j < n6; ++j) {
                System.arraycopy(nArray, n7, nArray, n5, n2);
                n5 += n2;
            }
        }
    }

    protected void computeColors(int[] nArray, PuComplex[] puComplexArray, int n, double d) {
        for (int i = 0; i < n; ++i) {
            PuComplex puComplex = puComplexArray[i];
            nArray[i] = this.getColorImpl(puComplex.re, puComplex.im, d);
        }
    }

    private int getColorImpl(double d, double d2, double d3) {
        double d4 = (d3 + Math.atan2(d2, d)) / (Math.PI * 2) + 0.5;
        double d5 = Math.sqrt(d * d + d2 * d2);
        d4 -= Math.floor(d4);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        f = d4 < 0.25 ? (float)(0.0 + 4.0 * d4 * 0.25) : (d4 < 0.5 ? (float)(0.25 + 4.0 * (d4 - 0.25) * 0.25) : (d4 < 0.75 ? (float)(0.5 + 4.0 * (d4 - 0.5) * 0.25) : (float)(0.75 + 4.0 * (d4 - 0.75) * 0.25)));
        if (d5 < Double.MIN_VALUE) {
            f3 = 0.0f;
            f2 = 0.0f;
        } else {
            f3 = 1.0f;
            f2 = 1.0f;
        }
        return Color.HSBtoRGB(f, f2, f3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

