/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_Costa
extends PgWeierstrassDescr {
    private final double m_defaultRadius = 4.0;
    private final double m_defaultRadius2 = 6.0;
    protected PuDouble m_dRadius;
    protected PuDouble m_dRadius2;
    private double m_radius = 4.0;
    private double m_radius2 = 6.0;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_Costa;

    public PgWeierstrass_Costa() {
        super(2, 3);
        this.setName("Costa Surface");
        this.m_dRadius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_dRadius2 = new PuDouble("Radius2", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_Costa == null ? (class$vgp$minimal$weier$PgWeierstrass_Costa = PgWeierstrass_Costa.class$("vgp.minimal.weier.PgWeierstrass_Costa")) : class$vgp$minimal$weier$PgWeierstrass_Costa)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(7);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 10);
        this.m_numLines[1].setDefValue(7);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_numLines[2].setDefBounds(3, 65, 1, 10);
        this.m_numLines[2].setDefValue(7);
        this.m_numLines[2].init();
        this.addParameter((PsObject)this.m_numLines[2]);
        this.m_dRadius.setDefBounds(0.2, 10.0, 0.1, 1.0);
        this.m_dRadius.setDefValue(4.0);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_dRadius2.setDefBounds(0.2, 10.0, 0.1, 1.0);
        this.m_dRadius2.setDefValue(6.0);
        this.m_dRadius2.init();
        this.addParameter((PsObject)this.m_dRadius2);
        this.setDomain(0, 0.0, Math.PI, 0.0, 4.0);
        this.setDomain(1, 0.0, 6.0, 0.0, Math.PI);
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = this.m_dRadius.getValue();
            this.setVMax(0, this.m_radius);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRadius2) {
            this.m_radius2 = this.m_dRadius2.getValue();
            this.setUMax(1, this.m_radius2);
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public int getNumULines(int n) {
        if (n == 0) {
            return this.m_numLines[0].getValue();
        }
        return this.m_numLines[1].getValue();
    }

    public int getNumVLines(int n) {
        if (n == 0) {
            return this.m_numLines[2].getValue();
        }
        return this.m_numLines[0].getValue();
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        PuComplex puComplex2 = n == 0 ? PuComplex.polarToRect((double)Math.exp(-puComplex.im * puComplex.im / this.m_radius), (double)(puComplex.re * puComplex.re / Math.PI)) : PuComplex.polarToRect((double)Math.exp(puComplex.re * puComplex.re / this.m_radius2), (double)(puComplex.im * puComplex.im / Math.PI));
        puComplex2.sub(PuComplex.ONE);
        puComplex2.mult(PuComplex.I);
        PuComplex puComplex3 = PuComplex.mult((PuComplex)PuComplex.sqrt((PuComplex)PuComplex.I), (PuComplex)PuComplex.sqrt((PuComplex)puComplex2));
        return puComplex3;
    }

    public PuComplex w(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.sub((PuComplex)PuComplex.sqr((PuComplex)puComplex), (PuComplex)PuComplex.ONE);
        puComplex2 = PuComplex.mult((PuComplex)PuComplex.sqrt((PuComplex)PuComplex.mult((PuComplex)puComplex2, (PuComplex)PuComplex.NEG_I)), (PuComplex)PuComplex.sqrt((PuComplex)PuComplex.I));
        puComplex2 = PuComplex.mult((PuComplex)puComplex2, (PuComplex)PuComplex.sqrt((PuComplex)puComplex));
        puComplex2.mult(PuComplex.I);
        return puComplex2;
    }

    public PuComplex f(PuComplex puComplex) {
        if (puComplex.re == 0.0 && puComplex.im == 0.0) {
            return PuComplex.ZERO;
        }
        return PuComplex.div((PuComplex)puComplex, (PuComplex)this.w(puComplex));
    }

    public PuComplex g(PuComplex puComplex) {
        double d = -0.96776;
        if (puComplex.re == 0.0 && puComplex.im == 0.0) {
            return PuComplex.ZERO;
        }
        return PuComplex.div((PuComplex)new PuComplex(d), (PuComplex)this.w(puComplex));
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(1, 3, 0, 0);
        }
        if (piVector == null) {
            this.connectPart(5, 2, 7, 2);
        }
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 2;
        }
        return 8;
    }

    public void getReflections(PiVector piVector) {
        if (piVector == null) {
            this.reflectPart(1, 0, 3);
            this.reflectPart(2, 0, 2);
            this.reflectPart(3, 2, 3);
            this.reflectPart(4, 3, 2);
            this.reflectPart(5, 4, 3);
            this.reflectPart(6, 1, 2);
            this.reflectPart(7, 6, 3);
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (this.equals(piVector, 0)) {
            if (n == 0) {
                piVector2.m_data[1] = 0;
                piVector2.m_data[3] = 0;
            } else if (n == 1) {
                piVector2.m_data[0] = 1;
                piVector2.m_data[2] = 0;
            }
        }
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return true;
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

