/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import java.util.Enumeration;
import java.util.Vector;
import jv.function.PuFunction;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.surface.PgDomainDescr;
import vgp.surface.common.PdMatrVecUVBuff;
import vgp.surface.common.PdMatrixUVBuff;
import vgp.surface.common.PdVectorUVBuff;

public abstract class PgSurfaceDescr
extends PgDomainDescr {
    public static final String BASE_SURFACE_NAME = "vgp.surface.common.PgSurface_";
    protected static final String[] CLASS_SURFACE = new String[]{"Boy", "Breather", "BreatherPQ", "Catalan", "CatenoidHelicoid", "CatenoidHelicoidScene", "Cliffordtorus", "Cone", "ConicType", "Cylinder", "Dini", "DupinCycloid", "DupinScene", "Ellipsoid", "EllipticParaboloid", "Enneper", "FootballBarrel", "Fresnel1", "Fresnel2", "Henneberg", "Hopftorus", "HyperbolicHelicoid", "HyperbolicParaboloid", "HyperboloidScene", "HyperboloidType", "KleinBottle", "Kuen", "LawsonHelicoid", "LowerHyperboloid", "MoebiusStrip", "OuterHyperboloid", "PseudoSphere", "Sievert", "Sphere", "StereographicSphere", "Tannery", "Torus", "UpperHyperboloid", "Zoll"};
    public static final int BOY = 0;
    public static final int BREATHER = 1;
    public static final int BREATHER_PQ = 2;
    public static final int CATALAN = 3;
    public static final int CATENOID_HELICOID = 4;
    public static final int CATENOID_HELICOID_SCENE = 5;
    public static final int CLIFFORD_TORUS = 6;
    public static final int CONE = 7;
    public static final int CONIC_TYPE = 8;
    public static final int CYLINDER = 9;
    public static final int DINI = 10;
    public static final int DUPIN_CYCLOID = 11;
    public static final int DUPIN_SCENE = 12;
    public static final int ELLIPSOID = 13;
    public static final int ELLIPTIC_PARABOLOID = 14;
    public static final int ENNEPER = 15;
    public static final int FOOTBALL_BARREL = 16;
    public static final int FRESNEL1 = 17;
    public static final int FRESNEL2 = 18;
    public static final int HENNEBERG = 19;
    public static final int S3_HOPFTORUS = 20;
    public static final int H3_HYPERBOLIC_HELICOID = 21;
    public static final int HYPERBOLIC_PARABLOID = 22;
    public static final int HYPERBOLOID_SCENE = 23;
    public static final int HYPERBOLOID_TYPE = 24;
    public static final int KLEINBOTTLE = 25;
    public static final int KUEN = 26;
    public static final int S3_LAWSON_HELICOID = 27;
    public static final int LOWER_HYPERBOLOID = 28;
    public static final int MOEBIUS_STRIP = 29;
    public static final int OUTER_HYPERBOLOID = 30;
    public static final int PSEUDOSPHERE = 31;
    public static final int SIEVERT = 32;
    public static final int SPHERE = 33;
    public static final int STEREOGRAPHIC_SPHERE = 34;
    public static final int TANNERY = 35;
    public static final int TORUS = 36;
    public static final int UPPER_HYPERBOLOID = 37;
    public static final int ZOLL = 38;
    protected static final String[] CLASS_SCENE = new String[]{"CatenoidHelicoidScene:CatenoidHelicoid;CatenoidHelicoid;CatenoidHelicoid:;eM;eM:,,1;,2,1;,2,1", "DupinScene:DupinCycloid;Torus;Sphere:l;e;e:;;,r", "HyperboloidScene:OuterHyperboloid;UpperHyperboloid;LowerHyperboloid:l;l;l:;,,y;,,y"};
    protected String m_nameID;
    protected Vector m_parm;
    protected int m_numVariables = 2;
    protected int m_numFunctions = 3;
    protected PuFunction m_function;
    protected int m_defaultAmbientSpace;
    protected int m_ambientSpace;
    protected int m_defaultAmbientProj;
    protected int m_ambientProj;
    protected boolean m_bUseFunctionExpression;
    protected PdVectorUVBuff m_f;
    private PdVectorUVBuff m_df_dU;
    private PdVectorUVBuff m_df_dV;
    private PdMatrixUVBuff m_df;
    private PdVectorUVBuff m_ddf_dUdU;
    private PdVectorUVBuff m_ddf_dUdV;
    private PdVectorUVBuff m_ddf_dVdV;
    private PdMatrixUVBuff m_firstFundamental;
    private PdMatrixUVBuff m_secondFundamental;
    private PdMatrixUVBuff m_weingarten;
    private PdMatrVecUVBuff m_christoffel;
    private PdVectorUVBuff m_normal;
    private PdVectorUVBuff m_dN_dU;
    private PdVectorUVBuff m_dN_dV;
    private PdMatrixUVBuff m_dN;
    static /* synthetic */ Class class$vgp$surface$common$PgSurfaceDescr;

    public PgSurfaceDescr() {
        super(2);
        int n;
        String string = ((Object)((Object)this)).getClass().getName();
        if (!PuString.isEmpty((String)string) && (n = string.indexOf(95)) > 0) {
            this.m_nameID = string.substring(n + 1);
        }
        this.m_defaultAmbientSpace = 3;
        this.m_defaultAmbientProj = 0;
        this.useFunctionExpression(false);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurfaceDescr == null ? (class$vgp$surface$common$PgSurfaceDescr = PgSurfaceDescr.class$("vgp.surface.common.PgSurfaceDescr")) : class$vgp$surface$common$PgSurfaceDescr)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setAmbientSpace(this.m_defaultAmbientSpace);
        this.setAmbientProjection(this.m_defaultAmbientProj);
        if (this.m_parm != null) {
            this.m_parm.removeAllElements();
        }
        if (this.m_function != null) {
            this.m_function.init();
        }
    }

    protected String getNameID() {
        return this.m_nameID;
    }

    public Object clone() {
        PgSurfaceDescr pgSurfaceDescr = (PgSurfaceDescr)((Object)super.clone());
        if (pgSurfaceDescr == null) {
            return null;
        }
        if (this.m_parm != null) {
            pgSurfaceDescr.m_parm = (Vector)this.m_parm.clone();
        }
        if (this.m_function != null) {
            pgSurfaceDescr.setFunction((PuFunction)this.m_function.clone());
        }
        pgSurfaceDescr.m_f = null;
        pgSurfaceDescr.m_df_dU = null;
        pgSurfaceDescr.m_df_dV = null;
        pgSurfaceDescr.m_df = null;
        pgSurfaceDescr.m_ddf_dUdU = null;
        pgSurfaceDescr.m_ddf_dUdV = null;
        pgSurfaceDescr.m_ddf_dVdV = null;
        pgSurfaceDescr.m_firstFundamental = null;
        pgSurfaceDescr.m_secondFundamental = null;
        pgSurfaceDescr.m_weingarten = null;
        pgSurfaceDescr.m_christoffel = null;
        pgSurfaceDescr.m_normal = null;
        pgSurfaceDescr.m_dN_dU = null;
        pgSurfaceDescr.m_dN_dV = null;
        pgSurfaceDescr.m_dN = null;
        return pgSurfaceDescr;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgSurfaceDescr)) {
            return;
        }
        PgSurfaceDescr pgSurfaceDescr = (PgSurfaceDescr)psObject;
        this.m_parm = pgSurfaceDescr.m_parm != null ? (Vector)pgSurfaceDescr.m_parm.clone() : null;
        PuFunction puFunction = pgSurfaceDescr.getFunction();
        if (this.m_function != null) {
            this.m_function.copy((PsObject)puFunction);
        } else if (puFunction != null) {
            this.setFunction((PuFunction)puFunction.clone());
        } else {
            this.m_function = null;
        }
        this.m_f = null;
        this.m_df_dU = null;
        this.m_df_dV = null;
        this.m_df = null;
        this.m_ddf_dUdU = null;
        this.m_ddf_dUdV = null;
        this.m_ddf_dVdV = null;
        this.m_firstFundamental = null;
        this.m_secondFundamental = null;
        this.m_weingarten = null;
        this.m_christoffel = null;
        this.m_normal = null;
        this.m_dN_dU = null;
        this.m_dN_dV = null;
        this.m_dN = null;
    }

    public int getAmbientSpace() {
        return this.m_ambientSpace;
    }

    public void setAmbientSpace(int n) {
        this.m_ambientSpace = n;
    }

    public int getAmbientProjection() {
        return this.m_ambientProj;
    }

    public void setAmbientProjection(int n) {
        this.m_ambientProj = n;
    }

    public int getDimOfSurface() {
        return this.m_numFunctions;
    }

    public void setDimOfSurface(int n) {
        if (this.m_function != null && this.m_function.getNumFunctions() != n) {
            this.m_function.setNumFunctions(n);
        }
        this.m_numFunctions = n;
        this.m_f = null;
    }

    public static String[] getListOfSurfaces() {
        return CLASS_SURFACE;
    }

    public static String[] getListOfScenes() {
        return CLASS_SCENE;
    }

    public PuFunction getFunction() {
        return this.m_function;
    }

    public boolean setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing function");
            return false;
        }
        this.m_function = null;
        this.setDimOfSurface(puFunction.getNumFunctions());
        this.m_function = puFunction;
        this.m_function.setParent((PsUpdateIf)this);
        return true;
    }

    public boolean useFunctionExpression() {
        return this.m_bUseFunctionExpression;
    }

    public void useFunctionExpression(boolean bl) {
        this.m_bUseFunctionExpression = bl;
    }

    public boolean isUPeriodic() {
        return false;
    }

    public boolean isVPeriodic() {
        return false;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_function) {
            this.useFunctionExpression(true);
            return super.update(null);
        }
        return super.update(object);
    }

    public void addParameter(PsObject psObject) {
        if (psObject == null) {
            return;
        }
        if (this.m_parm == null) {
            this.m_parm = new Vector();
        }
        if (this.m_parm.contains(psObject)) {
            PsDebug.warning((String)("parameter already registered in list, parm = " + psObject.getName()));
            return;
        }
        this.m_parm.addElement(psObject);
    }

    public PsObject getParameter(String string) {
        if (this.m_parm == null || this.m_parm.isEmpty()) {
            PsDebug.warning((String)"empty parameter list");
            return null;
        }
        Enumeration enumeration = this.m_parm.elements();
        while (enumeration.hasMoreElements()) {
            PsObject psObject = (PsObject)enumeration.nextElement();
            if (!string.equals(psObject.getName())) continue;
            return psObject;
        }
        return null;
    }

    public Enumeration getParameters() {
        if (this.m_parm == null) {
            return null;
        }
        return this.m_parm.elements();
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        this.useFunctionExpression(true);
        return false;
    }

    protected PdVector calc_df_dU(double d, double d2) {
        double d3 = (this.m_uMax.getValue() - this.m_uMin.getValue()) / ((double)this.m_numULines.getValue() - 1.0);
        PdVector pdVector = this.eval(d - d3, d2);
        PdVector pdVector2 = this.eval(d + d3, d2);
        pdVector2.sub(pdVector);
        pdVector2.multScalar(1.0 / (2.0 * d3));
        return pdVector2;
    }

    protected PdVector calc_df_dV(double d, double d2) {
        double d3 = (this.m_vMax.getValue() - this.m_vMin.getValue()) / ((double)this.m_numVLines.getValue() - 1.0);
        PdVector pdVector = this.eval(d, d2 - d3);
        PdVector pdVector2 = this.eval(d, d2 + d3);
        pdVector2.sub(pdVector);
        pdVector2.multScalar(1.0 / (2.0 * d3));
        return pdVector2;
    }

    protected PdMatrix calc_df(double d, double d2) {
        PdMatrix pdMatrix = new PdMatrix(this.m_numFunctions, 2);
        pdMatrix.setColumn(0, this.df_dU(d, d2));
        pdMatrix.setColumn(1, this.df_dV(d, d2));
        return pdMatrix;
    }

    protected PdVector calc_ddf_dUdU(double d, double d2) {
        double d3 = (this.m_uMax.getValue() - this.m_uMin.getValue()) / ((double)this.m_numULines.getValue() - 1.0);
        PdVector pdVector = this.df_dU(d - d3, d2);
        PdVector pdVector2 = this.df_dU(d + d3, d2);
        pdVector2.sub(pdVector);
        pdVector2.multScalar(1.0 / (2.0 * d3));
        return pdVector2;
    }

    protected PdVector calc_ddf_dUdV(double d, double d2) {
        double d3 = (this.m_uMax.getValue() - this.m_uMin.getValue()) / ((double)this.m_numULines.getValue() - 1.0);
        PdVector pdVector = this.df_dV(d - d3, d2);
        PdVector pdVector2 = this.df_dV(d + d3, d2);
        pdVector2.sub(pdVector);
        pdVector2.multScalar(1.0 / (2.0 * d3));
        return pdVector2;
    }

    protected PdVector calc_ddf_dVdV(double d, double d2) {
        double d3 = (this.m_vMax.getValue() - this.m_vMin.getValue()) / ((double)this.m_numVLines.getValue() - 1.0);
        PdVector pdVector = this.df_dV(d, d2 - d3);
        PdVector pdVector2 = this.df_dV(d, d2 + d3);
        pdVector2.sub(pdVector);
        pdVector2.multScalar(1.0 / (2.0 * d3));
        return pdVector2;
    }

    protected PdMatrix calc_firstFundamental(double d, double d2) {
        PdVector pdVector = this.df_dU(d, d2);
        PdVector pdVector2 = this.df_dV(d, d2);
        double d3 = PdVector.dot((PdVector)pdVector, (PdVector)pdVector);
        double d4 = PdVector.dot((PdVector)pdVector, (PdVector)pdVector2);
        double d5 = PdVector.dot((PdVector)pdVector2, (PdVector)pdVector2);
        pdVector.setSize(2);
        pdVector2.setSize(2);
        pdVector.set(d3, d4);
        pdVector2.set(d4, d5);
        PdMatrix pdMatrix = new PdMatrix(2);
        pdMatrix.setRow(0, pdVector);
        pdMatrix.setRow(1, pdVector2);
        return pdMatrix;
    }

    protected PdMatrix[] calc_christoffel(double d, double d2) {
        PdVector pdVector = this.df_dU(d, d2);
        PdVector pdVector2 = this.df_dV(d, d2);
        PdVector pdVector3 = this.ddf_dUdU(d, d2);
        PdVector pdVector4 = this.ddf_dVdV(d, d2);
        PdVector pdVector5 = this.ddf_dUdV(d, d2);
        PdMatrix pdMatrix = this.firstFundamental(d, d2);
        if (Math.abs(pdMatrix.m_data[0][0] * pdMatrix.m_data[1][1] - pdMatrix.m_data[0][1] * pdMatrix.m_data[1][0]) < 1.0E-10) {
            return null;
        }
        pdMatrix.invert();
        PdVector pdVector6 = new PdVector(2);
        pdVector6.set(PdVector.dot((PdVector)pdVector3, (PdVector)pdVector), PdVector.dot((PdVector)pdVector3, (PdVector)pdVector2));
        pdVector6.leftMultMatrix(pdMatrix);
        PdVector pdVector7 = new PdVector(2);
        pdVector7.set(PdVector.dot((PdVector)pdVector5, (PdVector)pdVector), PdVector.dot((PdVector)pdVector5, (PdVector)pdVector2));
        pdVector7.leftMultMatrix(pdMatrix);
        PdVector pdVector8 = new PdVector(2);
        pdVector8.set(PdVector.dot((PdVector)pdVector4, (PdVector)pdVector), PdVector.dot((PdVector)pdVector4, (PdVector)pdVector2));
        pdVector8.leftMultMatrix(pdMatrix);
        PdMatrix[] pdMatrixArray = new PdMatrix[2];
        pdVector.setSize(2);
        for (int i = 0; i < 2; ++i) {
            pdMatrixArray[i] = new PdMatrix(2);
            pdVector.set(pdVector6.getEntry(i), pdVector7.getEntry(i));
            pdMatrixArray[i].setRow(0, pdVector);
            pdVector.set(pdVector7.getEntry(i), pdVector8.getEntry(i));
            pdMatrixArray[i].setRow(1, pdVector);
        }
        return pdMatrixArray;
    }

    protected PdVector calc_normal(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.cross(this.df_dU(d, d2), this.df_dV(d, d2));
        pdVector.normalize();
        return pdVector;
    }

    protected PdVector calc_dN_dU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        PdMatrix pdMatrix = this.dN(d, d2);
        pdVector.set(pdMatrix.m_data[0][0], pdMatrix.m_data[1][0], pdMatrix.m_data[2][0]);
        return pdVector;
    }

    protected PdVector calc_dN_dV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        PdMatrix pdMatrix = this.dN(d, d2);
        pdVector.set(pdMatrix.m_data[0][1], pdMatrix.m_data[1][1], pdMatrix.m_data[2][1]);
        return pdVector;
    }

    protected PdMatrix calc_dN(double d, double d2) {
        PdMatrix pdMatrix = this.df(d, d2);
        pdMatrix.multScalar(-1.0);
        pdMatrix.rightMult(this.weingarten(d, d2));
        return pdMatrix;
    }

    protected PdMatrix calc_secondFundamental(double d, double d2) {
        PdVector pdVector = this.normal(d, d2);
        double d3 = PdVector.dot((PdVector)this.ddf_dUdU(d, d2), (PdVector)pdVector);
        double d4 = PdVector.dot((PdVector)this.ddf_dUdV(d, d2), (PdVector)pdVector);
        double d5 = PdVector.dot((PdVector)this.ddf_dVdV(d, d2), (PdVector)pdVector);
        PdVector pdVector2 = new PdVector(2);
        PdVector pdVector3 = new PdVector(2);
        pdVector2.set(d3, d4);
        pdVector3.set(d4, d5);
        PdMatrix pdMatrix = new PdMatrix(2);
        pdMatrix.setRow(0, pdVector2);
        pdMatrix.setRow(1, pdVector3);
        return pdMatrix;
    }

    protected PdMatrix calc_weingarten(double d, double d2) {
        PdMatrix pdMatrix = this.firstFundamental(d, d2);
        if (Math.abs(pdMatrix.m_data[0][0] * pdMatrix.m_data[1][1] - pdMatrix.m_data[0][1] * pdMatrix.m_data[1][0]) < 1.0E-10) {
            return null;
        }
        pdMatrix.invert();
        pdMatrix.rightMult(this.secondFundamental(d, d2));
        return pdMatrix;
    }

    public PdVector eval(PdVector pdVector, double d, double d2) {
        if (pdVector == null) {
            pdVector = new PdVector(this.m_numFunctions);
        }
        if (pdVector.getSize() < this.m_numFunctions) {
            pdVector.setSize(this.m_numFunctions);
        }
        if (this.m_f == null) {
            this.m_f = new PdVectorUVBuff();
            this.m_f.data = new PdVector(this.m_numFunctions);
            this.m_f.u = d + 1.0;
        }
        if (this.m_f.u != d || this.m_f.v != d2) {
            if (!this.useFunctionExpression()) {
                if (!this.calc_f(this.m_f.data, d, d2)) {
                    return null;
                }
            } else if (this.m_function != null) {
                double[] dArray = new double[]{d, d2};
                this.m_function.eval(this.m_f.data.m_data, dArray);
            }
            this.m_f.u = d;
            this.m_f.v = d2;
        }
        pdVector.copy(this.m_f.data);
        return pdVector;
    }

    private PdVector eval(double d, double d2) {
        PdVector pdVector = new PdVector(this.m_numFunctions);
        if (this.eval(pdVector, d, d2) == null) {
            return null;
        }
        return pdVector;
    }

    public final PdVector df_dU(double d, double d2) {
        if (this.m_df_dU == null) {
            this.m_df_dU = new PdVectorUVBuff();
            this.m_df_dU.u = d + 1.0;
        }
        if (this.m_df_dU.u != d || this.m_df_dU.v != d2) {
            this.m_df_dU.data = this.calc_df_dU(d, d2);
            this.m_df_dU.u = d;
            this.m_df_dU.v = d2;
        }
        return PdVector.copyNew((PdVector)this.m_df_dU.data);
    }

    public final PdVector df_dV(double d, double d2) {
        if (this.m_df_dV == null) {
            this.m_df_dV = new PdVectorUVBuff();
            this.m_df_dV.u = d + 1.0;
        }
        if (this.m_df_dV.u != d || this.m_df_dV.v != d2) {
            this.m_df_dV.data = this.calc_df_dV(d, d2);
            this.m_df_dV.u = d;
            this.m_df_dV.v = d2;
        }
        return PdVector.copyNew((PdVector)this.m_df_dV.data);
    }

    public final PdMatrix df(double d, double d2) {
        if (this.m_df == null) {
            this.m_df = new PdMatrixUVBuff();
            this.m_df.u = d + 1.0;
        }
        if (this.m_df.u != d || this.m_df.v != d2) {
            this.m_df.data = this.calc_df(d, d2);
            this.m_df.u = d;
            this.m_df.v = d2;
        }
        PdMatrix pdMatrix = new PdMatrix(this.m_numFunctions, 2);
        pdMatrix.copy(this.m_df.data);
        return pdMatrix;
    }

    public final PdVector ddf_dUdU(double d, double d2) {
        if (this.m_ddf_dUdU == null) {
            this.m_ddf_dUdU = new PdVectorUVBuff();
            this.m_ddf_dUdU.u = d + 1.0;
        }
        if (this.m_ddf_dUdU.u != d || this.m_ddf_dUdU.v != d2) {
            this.m_ddf_dUdU.data = this.calc_ddf_dUdU(d, d2);
            this.m_ddf_dUdU.u = d;
            this.m_ddf_dUdU.v = d2;
        }
        return PdVector.copyNew((PdVector)this.m_ddf_dUdU.data);
    }

    public final PdVector ddf_dUdV(double d, double d2) {
        if (this.m_ddf_dUdV == null) {
            this.m_ddf_dUdV = new PdVectorUVBuff();
            this.m_ddf_dUdV.u = d + 1.0;
        }
        if (this.m_ddf_dUdV.u != d || this.m_ddf_dUdV.v != d2) {
            this.m_ddf_dUdV.data = this.calc_ddf_dUdV(d, d2);
            this.m_ddf_dUdV.u = d;
            this.m_ddf_dUdV.v = d2;
        }
        return PdVector.copyNew((PdVector)this.m_ddf_dUdV.data);
    }

    public final PdVector ddf_dVdV(double d, double d2) {
        if (this.m_ddf_dVdV == null) {
            this.m_ddf_dVdV = new PdVectorUVBuff();
            this.m_ddf_dVdV.u = d + 1.0;
        }
        if (this.m_ddf_dVdV.u != d || this.m_ddf_dVdV.v != d2) {
            this.m_ddf_dVdV.data = this.calc_ddf_dVdV(d, d2);
            this.m_ddf_dVdV.u = d;
            this.m_ddf_dVdV.v = d2;
        }
        return PdVector.copyNew((PdVector)this.m_ddf_dVdV.data);
    }

    public final PdVector normal(double d, double d2) {
        if (this.m_normal == null) {
            this.m_normal = new PdVectorUVBuff();
            this.m_normal.u = d + 1.0;
        }
        if (this.m_normal.u != d || this.m_normal.v != d2) {
            this.m_normal.data = this.calc_normal(d, d2);
            this.m_normal.u = d;
            this.m_normal.v = d2;
        }
        return PdVector.copyNew((PdVector)this.m_normal.data);
    }

    public final PdVector dN_dU(double d, double d2) {
        if (this.m_dN_dU == null) {
            this.m_dN_dU = new PdVectorUVBuff();
            this.m_dN_dU.u = d + 1.0;
        }
        if (this.m_dN_dU.u != d || this.m_dN_dU.v != d2) {
            this.m_dN_dU.data = this.calc_dN_dU(d, d2);
            this.m_dN_dU.u = d;
            this.m_dN_dU.v = d2;
        }
        return PdVector.copyNew((PdVector)this.m_dN_dU.data);
    }

    public final PdVector dN_dV(double d, double d2) {
        if (this.m_dN_dV == null) {
            this.m_dN_dV = new PdVectorUVBuff();
            this.m_dN_dV.u = d + 1.0;
        }
        if (this.m_dN_dV.u != d || this.m_dN_dV.v != d2) {
            this.m_dN_dV.data = this.calc_dN_dV(d, d2);
            this.m_dN_dV.u = d;
            this.m_dN_dV.v = d2;
        }
        return PdVector.copyNew((PdVector)this.m_dN_dV.data);
    }

    public final PdMatrix dN(double d, double d2) {
        if (this.m_dN == null) {
            this.m_dN = new PdMatrixUVBuff();
            this.m_dN.u = d + 1.0;
        }
        if (this.m_dN.u != d || this.m_dN.v != d2) {
            this.m_dN.data = this.calc_dN(d, d2);
            this.m_dN.u = d;
            this.m_dN.v = d2;
        }
        PdMatrix pdMatrix = new PdMatrix(3, 2);
        pdMatrix.copy(this.m_dN.data);
        return pdMatrix;
    }

    public final PdMatrix firstFundamental(double d, double d2) {
        if (this.m_firstFundamental == null) {
            this.m_firstFundamental = new PdMatrixUVBuff();
            this.m_firstFundamental.u = d + 1.0;
        }
        if (this.m_firstFundamental.u != d || this.m_firstFundamental.v != d2) {
            this.m_firstFundamental.data = this.calc_firstFundamental(d, d2);
            this.m_firstFundamental.u = d;
            this.m_firstFundamental.v = d2;
        }
        PdMatrix pdMatrix = new PdMatrix(2);
        pdMatrix.copy(this.m_firstFundamental.data);
        return pdMatrix;
    }

    public final PdMatrix secondFundamental(double d, double d2) {
        if (this.m_secondFundamental == null) {
            this.m_secondFundamental = new PdMatrixUVBuff();
            this.m_secondFundamental.u = d + 1.0;
        }
        if (this.m_secondFundamental.u != d || this.m_secondFundamental.v != d2) {
            this.m_secondFundamental.data = this.calc_secondFundamental(d, d2);
            this.m_secondFundamental.u = d;
            this.m_secondFundamental.v = d2;
        }
        PdMatrix pdMatrix = new PdMatrix(2);
        pdMatrix.copy(this.m_secondFundamental.data);
        return pdMatrix;
    }

    public final PdMatrix weingarten(double d, double d2) {
        if (this.m_weingarten == null) {
            this.m_weingarten = new PdMatrixUVBuff();
            this.m_weingarten.u = d + 1.0;
        }
        if (this.m_weingarten.u != d || this.m_weingarten.v != d2) {
            this.m_weingarten.data = this.calc_weingarten(d, d2);
            this.m_weingarten.u = d;
            this.m_weingarten.v = d2;
        }
        if (this.m_weingarten.data == null) {
            return null;
        }
        PdMatrix pdMatrix = new PdMatrix(2);
        pdMatrix.copy(this.m_weingarten.data);
        return pdMatrix;
    }

    public final PdMatrix[] christoffel(double d, double d2) {
        if (this.m_christoffel == null) {
            this.m_christoffel = new PdMatrVecUVBuff();
            this.m_christoffel.u = d + 1.0;
        }
        if (this.m_christoffel.u != d || this.m_christoffel.v != d2) {
            this.m_christoffel.data = this.calc_christoffel(d, d2);
            this.m_christoffel.u = d;
            this.m_christoffel.v = d2;
        }
        if (this.m_christoffel.data == null) {
            return null;
        }
        PdMatrix[] pdMatrixArray = new PdMatrix[2];
        for (int i = 0; i < 2; ++i) {
            pdMatrixArray[i] = new PdMatrix(2);
            pdMatrixArray[i].copy(this.m_christoffel.data[i]);
        }
        return pdMatrixArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

