/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.function.PuFunction;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_Cylinder
extends PgSurfaceDescr {
    private double m_defRadius = 0.2;
    protected PuDouble m_radius;
    static /* synthetic */ Class class$vgp$surface$common$PgSurface_Cylinder;

    public PgSurface_Cylinder() {
        this.setName("Cylinder");
        this.m_radius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_function = new PuFunction(2, 3);
        this.m_function.setName("Coordinate Functions");
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_Cylinder == null ? (class$vgp$surface$common$PgSurface_Cylinder = PgSurface_Cylinder.class$("vgp.surface.common.PgSurface_Cylinder")) : class$vgp$surface$common$PgSurface_Cylinder)) {
            this.init();
        }
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 2;
    }

    public void init() {
        super.init();
        this.setSize(-Math.PI, -1.0, Math.PI, 1.0);
        this.setDiscr(17, 17);
        this.m_radius.setDefBounds(0.0, 4.0 * this.m_defRadius, 0.01, 0.1);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        this.addParameter((PsObject)this.m_radius);
        this.m_function.setExpression(0, "r*cos(u)");
        this.m_function.setExpression(1, "r*sin(u)");
        this.m_function.setExpression(2, "v");
        this.m_function.addParameter("r", this.m_radius.getValue());
        this.setFunction(this.m_function);
        this.useFunctionExpression(false);
    }

    public boolean update(Object object) {
        if (object == this.m_radius) {
            this.m_function.setParameter("r", this.m_radius.getValue());
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        pdVector.set(this.m_radius.getValue() * Math.cos(d), this.m_radius.getValue() * Math.sin(d), d2);
        return true;
    }

    protected PdVector calc_df_dU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(-this.m_radius.getValue() * Math.sin(d), this.m_radius.getValue() * Math.cos(d), 0.0);
        return pdVector;
    }

    protected PdVector calc_df_dV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(0.0, 0.0, 1.0);
        return pdVector;
    }

    protected PdVector calc_ddf_dUdU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(-this.m_radius.getValue() * Math.cos(d), -this.m_radius.getValue() * Math.sin(d), 0.0);
        return pdVector;
    }

    protected PdVector calc_ddf_dVdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(0.0, 0.0, 0.0);
        return pdVector;
    }

    protected PdVector calc_ddf_dUdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        pdVector.set(0.0, 0.0, 0.0);
        return pdVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

