/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.gui;

import java.awt.Rectangle;
import jv.geom.PgElementSet;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvApplet;
import jv.project.PvDisplayOverlayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;
import jvx.gui.PuColorBar;
import jvx.gui.PuColorBarCanvas;

public class PaDisplayOverlay
extends PvApplet
implements PsUpdateIf {
    protected PuColorBar m_colorBar;
    protected PuColorBarCanvas m_colorBarCanvas;
    protected PgElementSet m_geom;
    protected PdVector m_elementValues;

    public String getAppletInfo() {
        return "Name: " + ((Object)((Object)this)).getClass().getName() + "\r\nAuthor: Konrad Polthier\r\nVersion: 1.00\r\nApplet shows usage of external overlay canvas inside a JavaView display\r\n";
    }

    public Rectangle getSizeOfFrame() {
        return new Rectangle(375, 5, 640, 512);
    }

    public PjProject getProject() {
        return null;
    }

    public void run() {
        this.m_geom = new PgElementSet(3);
        this.m_geom.computeSphere(20, 20, 1.0);
        this.m_geom.makeElementNormals();
        this.m_geom.showEdges(false);
        this.m_geom.showElementColors(true);
        this.m_colorBar = new PuColorBar(true, true, true);
        this.m_colorBar.setParent((PsUpdateIf)this);
        this.initColorBar(this.m_geom);
        this.colorizeGeometry(this.m_geom);
        PvDisplay pvDisplay = (PvDisplay)super.getDisplay();
        pvDisplay.addOverlay((PvDisplayOverlayIf)this.m_colorBar.getCanvas());
        pvDisplay.addGeometry((PgGeometryIf)this.m_geom);
        super.run();
    }

    private void initColorBar(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumElements();
        this.m_elementValues = new PdVector(n);
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            PiVector piVector = pgElementSet.getElement(i);
            int n2 = piVector.getSize();
            this.m_elementValues.m_data[i] = 0.0;
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                this.m_elementValues.m_data[n3] = this.m_elementValues.m_data[n3] + pgElementSet.getVertex((int)piVector.m_data[j]).m_data[2];
            }
            int n4 = i;
            this.m_elementValues.m_data[n4] = this.m_elementValues.m_data[n4] / (double)n2;
            if (this.m_elementValues.m_data[i] > d2) {
                d2 = this.m_elementValues.m_data[i];
            }
            if (!(this.m_elementValues.m_data[i] < d)) continue;
            d = this.m_elementValues.m_data[i];
        }
        this.m_colorBar.setMinValue(d);
        this.m_colorBar.setMaxValue(d2);
    }

    private void colorizeGeometry(PgElementSet pgElementSet) {
        if (pgElementSet == null || this.m_elementValues == null) {
            return;
        }
        int n = pgElementSet.getNumElements();
        for (int i = 0; i < n; ++i) {
            pgElementSet.setElementColor(i, this.m_colorBar.getColor(this.m_elementValues.m_data[i]));
            if (this.m_colorBar.isMarked(this.m_elementValues.m_data[i])) {
                pgElementSet.setTagElement(i, 1);
                continue;
            }
            pgElementSet.clearTagElement(i, 1);
        }
    }

    public PsUpdateIf getFather() {
        return null;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
    }

    public boolean update(Object object) {
        if (object == this.m_colorBar) {
            this.colorizeGeometry(this.m_geom);
            this.m_geom.update((Object)this.m_geom);
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        PvApplet.main((PvApplet)new PaDisplayOverlay(), (String[])stringArray);
    }
}

