/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.lsystem;

import java.util.Stack;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import vgp.tutor.lsystem.LSystem;

public class PjLSystem
extends PjProject {
    protected String m_descr;
    protected PuDouble m_delta;
    protected PuInteger m_numIterations;
    protected PgPolygonSet m_polySet;
    protected LSystem m_lsystem = new LSystem();
    protected boolean m_bAutoFit;
    protected boolean m_bCurrentState;
    static /* synthetic */ Class class$vgp$tutor$lsystem$PjLSystem;

    public PjLSystem() {
        super("L-System Explorer");
        this.m_polySet = new PgPolygonSet(2);
        this.m_polySet.setName("My L-System");
        this.m_delta = new PuDouble("Angle", (PsUpdateIf)this);
        this.m_numIterations = new PuInteger("Num Iterations", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$lsystem$PjLSystem == null ? (class$vgp$tutor$lsystem$PjLSystem = PjLSystem.class$("vgp.tutor.lsystem.PjLSystem")) : class$vgp$tutor$lsystem$PjLSystem)) {
            this.init();
        }
    }

    public void init() {
        this.m_delta.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_delta.setDefValue(90.0);
        this.m_delta.init();
        this.m_numIterations.setDefBounds(0, 10, 1, 1);
        this.m_numIterations.setDefValue(1);
        this.m_numIterations.init();
        this.m_bAutoFit = true;
        this.m_bCurrentState = false;
    }

    public void start() {
        this.recompute();
        this.addGeometry((PgGeometryIf)this.m_polySet);
        this.selectGeometry((PgGeometryIf)this.m_polySet);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.selectCamera(1);
        if (this.m_bAutoFit) {
            pvDisplayIf.fit();
        }
        this.update((Object)this);
    }

    public boolean update(Object object) {
        if (object == null) {
            return true;
        }
        if (object == this.m_delta) {
            this.makePolygonSet(this.m_delta.getValue());
            this.m_polySet.update((Object)this.m_polySet);
            return true;
        }
        if (object == this.m_numIterations) {
            this.m_lsystem.iterate(this.m_numIterations.getValue());
            this.m_descr = this.m_lsystem.getTree();
            this.makePolygonSet(this.m_delta.getValue());
            this.m_polySet.update((Object)this.m_polySet);
            if (this.m_bAutoFit) {
                this.fitDisplays();
            }
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void recompute() {
        this.m_lsystem.iterate(this.m_numIterations.getValue());
        this.m_descr = this.m_lsystem.getTree();
        this.makePolygonSet(this.m_delta.getValue());
        this.m_polySet.update((Object)this.m_polySet);
    }

    private void makePolygonSet(double d) {
        int n = 1000;
        int n2 = 10;
        int n3 = 50;
        this.m_polySet.setNumPolygons(n2);
        this.m_polySet.setNumPolygons(0);
        this.m_polySet.setNumVertices(n);
        this.m_polySet.setNumVertices(0);
        d *= Math.PI / 180;
        Stack<PdVector> stack = new Stack<PdVector>();
        Stack<PiVector> stack2 = new Stack<PiVector>();
        Stack<Integer> stack3 = new Stack<Integer>();
        int n4 = this.m_descr.length();
        double d2 = 0.2;
        PdVector pdVector = new PdVector(3);
        PiVector piVector = new PiVector(n3);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.5707963267948966;
        pdVector.set(d3, d4, d5);
        int n5 = this.m_polySet.addVertex(pdVector);
        int n6 = 0;
        piVector.setEntry(n6++, n5);
        block7: for (int i = 0; i < n4; ++i) {
            switch (this.m_descr.charAt(i)) {
                case 'F': {
                    d5 = pdVector.getEntry(2);
                    d3 = pdVector.getEntry(0) + d2 * Math.cos(d5);
                    d4 = pdVector.getEntry(1) + d2 * Math.sin(d5);
                    pdVector.set(d3, d4, d5);
                    n5 = this.m_polySet.addVertex(pdVector);
                    if (n6 >= piVector.getSize()) {
                        piVector.setSize(2 * n6);
                    }
                    piVector.setEntry(n6++, n5);
                    continue block7;
                }
                case '[': {
                    stack.push(pdVector);
                    pdVector = PdVector.copyNew((PdVector)pdVector);
                    stack2.push(piVector);
                    stack3.push(new Integer(n6));
                    piVector = new PiVector(n3);
                    n6 = 0;
                    piVector.setEntry(n6++, n5);
                    continue block7;
                }
                case ']': {
                    piVector.setSize(n6);
                    this.m_polySet.addPolygon(piVector);
                    pdVector = (PdVector)stack.pop();
                    piVector = (PiVector)stack2.pop();
                    Integer n7 = (Integer)stack3.pop();
                    n6 = n7;
                    n5 = piVector.getEntry(n6 - 1);
                    continue block7;
                }
                case '+': {
                    pdVector.setEntry(2, pdVector.getEntry(2) + d);
                    continue block7;
                }
                case '-': {
                    pdVector.setEntry(2, pdVector.getEntry(2) - d);
                    continue block7;
                }
            }
        }
        piVector.setSize(n6);
        this.m_polySet.addPolygon(piVector);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

