/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.polygonSet;

import java.awt.Color;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjPolygonSet
extends PjProject {
    protected PgPolygonSet m_geom;
    protected int m_numULines;
    protected int m_numVLines;
    static /* synthetic */ Class class$vgp$tutor$polygonSet$PjPolygonSet;

    public PjPolygonSet() {
        super("Polygon Set on Torus Demo");
        this.m_numVLines = this.m_numULines = 10;
        this.m_geom = new PgPolygonSet(3);
        this.m_geom.setName("Torus as PolygonSet");
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$polygonSet$PjPolygonSet == null ? (class$vgp$tutor$polygonSet$PjPolygonSet = PjPolygonSet.class$("vgp.tutor.polygonSet.PjPolygonSet")) : class$vgp$tutor$polygonSet$PjPolygonSet)) {
            this.init();
        }
    }

    public void init() {
        this.m_geom.setGlobalVertexColor(Color.yellow);
        this.m_geom.setGlobalVertexSize(4.0);
        this.m_geom.setGlobalVertexNormalColor(Color.red);
        this.m_geom.setGlobalPolygonColor(new Color(25, 20, 200));
        this.m_geom.setGlobalPolygonSize(4.0);
        this.m_geom.showPolygonColors(true);
        this.m_geom.assurePolygonColors();
        this.m_geom.showPolygonEndArrow(true);
        this.computeLines();
    }

    public void start() {
        PsDebug.notify((String)"computing torus as element set");
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        super.start();
    }

    public void computeLines() {
        this.m_geom.setNumVertices(this.m_numULines * (this.m_numULines + 1) / 2);
        this.m_geom.setNumPolygons(this.m_numULines);
        this.m_geom.assureVertexNormals();
        double d = 1.0;
        double d2 = 2.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.m_numULines > 1) {
            d3 = Math.PI * 2 / (-1.0 + (double)this.m_numULines);
        }
        if (this.m_numVLines > 1) {
            d4 = Math.PI * 2 / (-1.0 + (double)this.m_numVLines);
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PdVector[] pdVectorArray2 = this.m_geom.getVertexNormals();
        int n = 0;
        for (int i = 0; i < this.m_numULines; ++i) {
            int n2 = (int)((float)(i * 255) / ((float)this.m_numULines - 1.0f));
            this.m_geom.setPolygonColor(i, new Color(n2, 255 - n2, 0));
            double d5 = d3 * (double)i;
            PiVector piVector = this.m_geom.getPolygon(i);
            piVector.setSize(this.m_numULines - i);
            for (int j = 0; j < this.m_numULines - i; ++j) {
                double d6 = Math.PI + d4 * (double)j;
                pdVectorArray[n].m_data[0] = Math.cos(d5) * (d * Math.cos(d6) + d2);
                pdVectorArray[n].m_data[1] = Math.sin(d5) * (d * Math.cos(d6) + d2);
                pdVectorArray[n].m_data[2] = d * Math.sin(d6);
                pdVectorArray2[n].m_data[0] = Math.cos(d5) * Math.cos(d6);
                pdVectorArray2[n].m_data[1] = Math.sin(d5) * Math.cos(d6);
                pdVectorArray2[n].m_data[2] = Math.sin(d6);
                piVector.m_data[j] = n++;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

