/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jvx.geom.PwModel;

public class PwModelTwoParm
extends PwModel {
    protected PuDouble m_faceParameter;
    protected PuDouble m_edgeParameter;
    protected PuDouble m_vertexParameter;
    private boolean m_bUpdateSender = false;
    protected boolean m_bSnubMode = false;
    protected boolean m_bProjectToSphere = false;
    protected boolean m_bIdentify = true;
    protected boolean m_bSetColors = false;
    protected Color m_vColor = Color.red;
    protected Color m_eColor = Color.yellow;
    protected Color m_fColor = Color.blue;
    static /* synthetic */ Class class$jvx$geom$PwModelTwoParm;

    public PwModelTwoParm() {
        this.m_faceParameter = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Face"), (PsUpdateIf)this);
        this.m_edgeParameter = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Edge"), (PsUpdateIf)this);
        this.m_vertexParameter = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Vertex"), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwModelTwoParm == null ? (class$jvx$geom$PwModelTwoParm = PwModelTwoParm.class$("jvx.geom.PwModelTwoParm")) : class$jvx$geom$PwModelTwoParm)) {
            this.init();
        }
    }

    public void init() {
        this.m_faceParameter.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_faceParameter.setDefValue(0.0);
        this.m_faceParameter.init();
        this.m_edgeParameter.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_edgeParameter.setDefValue(0.0);
        this.m_edgeParameter.init();
        this.m_vertexParameter.setDefBounds(0.0, 1.0, 0.01, 0.05);
        this.m_vertexParameter.setDefValue(1.0);
        this.m_vertexParameter.init();
    }

    public void setParameters(double d, double d2, double d3) {
        this.m_bUpdateSender = true;
        this.m_vertexParameter.setValue(d);
        this.m_faceParameter.setValue(d2);
        this.m_edgeParameter.setValue(d3);
        this.m_bUpdateSender = false;
        if (d3 + d == 0.0) {
            d3 = 0.5;
            d = 0.5;
        }
        double d4 = d3 + d;
        this.computeModeling(d2, d3 / (2.0 * d4));
        this.update(null);
    }

    public boolean update(Object object) {
        if (this.m_bUpdateSender) {
            return true;
        }
        if (object == this.m_faceParameter || object == this.m_edgeParameter || object == this.m_vertexParameter) {
            double d;
            this.m_bUpdateSender = true;
            double d2 = this.m_faceParameter.getValue();
            double d3 = this.m_edgeParameter.getValue();
            double d4 = this.m_vertexParameter.getValue();
            if (object == this.m_faceParameter) {
                if (d3 + d4 == 0.0) {
                    d3 = 0.5;
                    d4 = 0.5;
                }
                d = d3 + d4;
                this.m_edgeParameter.setValue(d3 *= (1.0 - d2) / d);
                this.m_vertexParameter.setValue(d4 *= (1.0 - d2) / d);
            } else if (object == this.m_edgeParameter) {
                if (d2 + d4 == 0.0) {
                    d2 = 0.5;
                    d4 = 0.5;
                }
                d = d2 + d4;
                this.m_faceParameter.setValue(d2 *= (1.0 - d3) / d);
                this.m_vertexParameter.setValue(d4 *= (1.0 - d3) / d);
            } else {
                if (d3 + d2 == 0.0) {
                    d3 = 0.5;
                    d2 = 0.5;
                }
                d = d3 + d2;
                this.m_edgeParameter.setValue(d3 *= (1.0 - d4) / d);
                this.m_faceParameter.setValue(d2 *= (1.0 - d4) / d);
            }
            this.update((Object)this);
            this.m_bUpdateSender = false;
            if (d3 + d4 == 0.0) {
                d3 = 0.5;
                d4 = 0.5;
            }
            d = d3 + d4;
            this.computeModeling(d2, d3 / (2.0 * d));
            this.update(null);
            return true;
        }
        return super.update(object);
    }

    protected void computeModeling() {
        double d = this.m_vertexParameter.getValue();
        double d2 = this.m_faceParameter.getValue();
        double d3 = this.m_edgeParameter.getValue();
        if (d3 + d == 0.0) {
            d3 = 0.5;
            d = 0.5;
        }
        double d4 = d3 + d;
        this.computeModeling(d2, d3 / (2.0 * d4));
    }

    protected void computeModeling(double d, double d2) {
        this.m_elementSet.copy((PsObject)this.m_geomSave);
        int n = 0;
        int n2 = 0;
        if (this.m_bSetColors) {
            n = ((PgElementSet)this.m_geomSave).getNumElements();
            n2 = ((PgElementSet)this.m_geomSave).getNumVertices();
        }
        if (this.m_bSnubMode) {
            PwModel.snubTruncate(this.m_elementSet, d, d2);
        } else {
            PwModel.rhombiTruncate(this.m_elementSet, d, d2);
        }
        if (this.m_bSetColors) {
            int n3;
            this.m_elementSet.assureElementColors();
            this.m_elementSet.showElementColors(true);
            for (n3 = 0; n3 < n; ++n3) {
                this.m_elementSet.setElementColor(n3, this.m_fColor);
            }
            for (n3 = n; n3 < n + n2; ++n3) {
                this.m_elementSet.setElementColor(n3, this.m_vColor);
            }
            for (n3 = n + n2; n3 < this.m_elementSet.getNumElements(); ++n3) {
                this.m_elementSet.setElementColor(n3, this.m_eColor);
            }
        }
        if (this.m_bIdentify) {
            PuCleanMesh.identifyVertices((PgPointSet)this.m_elementSet, (double)1.0E-10);
        }
        if (this.m_bProjectToSphere) {
            this.m_elementSet.projectToSphere(new PdVector(0.0, 0.0, 0.0), 1.0);
        }
        this.m_elementSet.update((Object)this.m_elementSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

