/*
 * Decompiled with CFR 0.152.
 */
package jvx.gui;

import java.awt.Color;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jvx.gui.PuColorBarCanvas;
import jvx.number.PuColorMapBoolean;
import jvx.number.PuColorMapIf;
import jvx.number.PuColorMapJv;
import jvx.number.PuColorMapTriple;

public class PuColorBar
extends PsObject {
    public final int COLOR_MAP_JAVAVIEW = 0;
    public final int COLOR_MAP_3COLS = 1;
    public final int COLOR_MAP_BOOLEAN = 2;
    public final int INTERP_CONSTANT_LEFT = 0;
    public final int INTERP_CONSTANT_RIGHT = 1;
    public final int INTERP_LINEAR = 2;
    protected PuColorMapIf m_colorTable;
    protected double m_transformMin;
    protected double m_transformMax = 1.0;
    protected double m_minValue;
    protected double m_maxValue = 1.0;
    protected double m_minMark;
    protected double m_maxMark;
    protected final int DEFAULT_COLOR_MAP = 0;
    protected Color m_backColor = Color.lightGray;
    protected Color m_markColor = Color.magenta;
    protected boolean m_allowMark;
    protected boolean m_allowContextMenu;
    protected boolean m_hasControls;
    protected boolean m_isEnabled = true;
    static /* synthetic */ Class class$jvx$gui$PuColorBar;

    public PuColorBar() {
        this(false, true, true);
    }

    public PuColorBar(boolean bl) {
        this(bl, true, true);
    }

    public PuColorBar(boolean bl, boolean bl2, boolean bl3) {
        this.m_allowMark = bl2;
        this.m_allowContextMenu = bl3;
        this.m_hasControls = bl;
        this.setColorTable(0);
        if (((Object)((Object)this)).getClass() == (class$jvx$gui$PuColorBar == null ? (class$jvx$gui$PuColorBar = PuColorBar.class$("jvx.gui.PuColorBar")) : class$jvx$gui$PuColorBar)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public boolean update(Object object) {
        return super.update(object);
    }

    public PuColorBarCanvas getCanvas() {
        PuColorBarCanvas puColorBarCanvas = new PuColorBarCanvas();
        puColorBarCanvas.setParent((PsUpdateIf)this);
        return puColorBarCanvas;
    }

    public void setTransformMin(double d) {
        this.m_transformMin = d;
    }

    public void setTransformMax(double d) {
        this.m_transformMax = d;
    }

    public void setMinValue(double d) {
        this.m_minValue = d;
    }

    public void setMaxValue(double d) {
        this.m_maxValue = d;
    }

    public void setBounds(double d, double d2) {
        this.m_minValue = d;
        this.m_maxValue = d2;
    }

    public void setMinMark(double d) {
        this.m_minMark = d;
    }

    public void setMaxMark(double d) {
        this.m_maxMark = d;
    }

    public void setColorTable(PuColorMapIf puColorMapIf) {
        this.m_colorTable = puColorMapIf;
    }

    public void setColorTable(int n) {
        switch (n) {
            case 0: {
                this.setColorTable(new PuColorMapJv());
                break;
            }
            case 1: {
                this.setColorTable(new PuColorMapTriple());
                break;
            }
            case 2: {
                this.setColorTable(new PuColorMapBoolean());
                break;
            }
            default: {
                PsDebug.warning((String)"Index out of range.");
            }
        }
    }

    public void setBackColor(Color color) {
        this.m_backColor = color;
    }

    public Color getBackColor() {
        return this.m_backColor;
    }

    public void setMarkColor(Color color) {
        this.m_markColor = color;
    }

    public Color getMarkColor() {
        return this.m_markColor;
    }

    public void allowMark(boolean bl) {
        this.m_allowMark = bl;
    }

    public boolean isMarkAllowed() {
        return this.m_allowMark;
    }

    public void allowContextMenu(boolean bl) {
        this.m_allowContextMenu = bl;
    }

    public boolean isContextMenuAllowed() {
        return this.m_allowContextMenu;
    }

    public double transformAbsoluteValueToColorIndex(double d) {
        return this.transformUnitValueToColorIndex(this.transformAbsoluteToUnitValue(d));
    }

    protected double transformAbsoluteToUnitValue(double d) {
        if (this.m_maxValue - this.m_minValue <= 1.0E-10) {
            return 0.0;
        }
        return (d - this.m_minValue) / (this.m_maxValue - this.m_minValue);
    }

    protected double transformUnitValueToColorIndex(double d) {
        if (d <= this.m_transformMin) {
            return 0.0;
        }
        if (d >= this.m_transformMax) {
            return 1.0;
        }
        return (d - this.m_transformMin) / (this.m_transformMax - this.m_transformMin);
    }

    protected double transformUnitToAbsoluteValue(double d) {
        if (Math.abs(this.m_maxValue - this.m_minValue) <= 1.0E-10) {
            return this.m_minValue;
        }
        return this.m_minValue + (this.m_maxValue - this.m_minValue) * d;
    }

    public Color getColor(double d) {
        if (Double.isNaN(d) || d == Double.MIN_VALUE) {
            return this.m_backColor;
        }
        return this.m_colorTable.getColor(this.transformAbsoluteValueToColorIndex(d));
    }

    public boolean isMarked(double d) {
        double d2 = this.transformAbsoluteToUnitValue(d);
        return d2 >= this.m_minMark && d2 < this.m_maxMark;
    }

    public void setEnabled(boolean bl) {
        this.m_isEnabled = bl;
        this.update((Object)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

