/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgMaLoader
extends PgAbstractLoader {
    protected PdVector m_boundingBoxMin;
    protected PdVector m_boundingBoxMax;
    protected String[] m_axesLabels;
    protected String m_axesStyle;
    protected Vector m_geomVec;
    protected Vector m_geomColor;
    protected Vector m_geomStyle;
    protected Vector m_geomTitle;
    protected int m_numGeoms;

    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open((String)string);
        if (bufferedReader == null) {
            PsDebug.warning((String)("could not open = " + string));
            return null;
        }
        PgMaLoader pgMaLoader = new PgMaLoader();
        PgJvxSrc[] pgJvxSrcArray = pgMaLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pgJvxSrcArray != null) {
            for (int i = 0; i < pgJvxSrcArray.length; ++i) {
                if (pgJvxSrcArray[i] == null || pgJvxSrcArray[i].getName() != null) continue;
                pgJvxSrcArray[i].setName(PsUtil.getFileBaseName((String)string) + "[" + i + "]");
            }
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        this.m_bIsAnimation = false;
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        this.m_geomVec = new Vector();
        this.m_numGeoms = 0;
        boolean bl = this.parse(bufferedReader);
        if (!bl) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        if (this.m_numGeoms == 0) {
            PsDebug.warning((String)"missing geometries");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[this.m_numGeoms];
        int n = 0;
        int n2 = 0;
        PdVector pdVector = this.m_geomVec.elements();
        while (pdVector.hasMoreElements()) {
            pgJvxSrcArray[n2] = (PgJvxSrc)pdVector.nextElement();
            if (n == 0) {
                n = pgJvxSrcArray[n2].getDimOfVertices();
            } else if (n != pgJvxSrcArray[n2].getDimOfVertices()) {
                n = -1;
            }
            switch (pgJvxSrcArray[n2].getType()) {
                case 30: {
                    pgJvxSrcArray[n2].showVertices(true);
                    break;
                }
                case 33: {
                    pgJvxSrcArray[n2].assureNeighbours();
                    break;
                }
            }
            ++n2;
        }
        if (n == 2) {
            this.m_displayOption = new PvDisplayOption();
            this.m_displayOption.setNumCameras(1);
            this.m_displayOption.setCameraProjection(0, 1);
            this.m_displayOption.setCameraInterest(0, new PdVector(0.0, 0.0, 0.0));
            this.m_displayOption.setCameraPosition(0, new PdVector(0.0, 0.0, 1.0));
            this.m_displayOption.setCurrentCamera(1);
            this.m_displayOption.setAxesLabel(this.m_axesLabels);
            this.m_displayOption.setOption(6, true);
            this.m_displayOption.setOption(9, true);
            if (this.m_axesStyle != null) {
                this.m_displayOption.setOption(5, !this.m_axesStyle.equals("none"));
                if (this.m_axesStyle.equalsIgnoreCase("frame")) {
                    this.m_displayOption.setAxesType(6);
                } else if (this.m_axesStyle.equalsIgnoreCase("box") || this.m_axesStyle.equalsIgnoreCase("boxed")) {
                    this.m_displayOption.setAxesType(6);
                    this.m_displayOption.setOption(12, true);
                } else if (this.m_axesStyle.equalsIgnoreCase("normal")) {
                    this.m_displayOption.setAxesType(3);
                } else {
                    this.m_displayOption.setAxesType(-1);
                }
            } else {
                this.m_displayOption.setOption(5, true);
                this.m_displayOption.setAxesType(3);
            }
            this.m_displayOption.setOption(3, true);
        } else if (n == 3) {
            this.m_displayOption = new PvDisplayOption();
            this.m_displayOption.setNumCameras(1);
            this.m_displayOption.setCameraPosition(0, new PdVector(1.3, -2.4, 2.0));
            this.m_displayOption.setCameraProjection(0, 0);
            pdVector = new PdVector(3);
            pdVector.setConstant(0.5);
            this.m_displayOption.setCameraInterest(0, pdVector);
            this.m_displayOption.setEnabledCameraClip(0, false);
            this.m_displayOption.setCameraFieldOfView(0, 0.0);
            this.m_displayOption.setCameraRoll(0, 0.0);
            this.m_displayOption.setCurrentCamera(0);
            this.m_displayOption.setCameraNearClip(0, 0.0);
            this.m_displayOption.setCameraFarClip(0, 0.0);
            this.m_displayOption.setAxesLabel(this.m_axesLabels);
            this.m_displayOption.setOption(6, true);
            this.m_displayOption.setOption(9, true);
            if (this.m_axesStyle != null) {
                this.m_displayOption.setOption(5, !this.m_axesStyle.equals("none"));
                if (this.m_axesStyle.equalsIgnoreCase("frame")) {
                    this.m_displayOption.setAxesType(1);
                } else if (this.m_axesStyle.equalsIgnoreCase("box") || this.m_axesStyle.equalsIgnoreCase("boxed")) {
                    this.m_displayOption.setAxesType(2);
                    this.m_displayOption.setOption(12, true);
                } else if (this.m_axesStyle.equalsIgnoreCase("normal")) {
                    this.m_displayOption.setAxesType(0);
                } else {
                    this.m_displayOption.setAxesType(-1);
                }
            } else {
                this.m_displayOption.setOption(5, false);
                this.m_displayOption.setAxesType(-1);
            }
            this.m_displayOption.setOption(3, true);
        }
        return pgJvxSrcArray;
    }

    private boolean parse(BufferedReader bufferedReader) {
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        int n;
        int n2;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        this.m_numGeoms = pgJvxSrcArray.length;
        for (int i = 0; i < this.m_numGeoms; ++i) {
            if (pgJvxSrcArray[i] != null) continue;
            PsDebug.warning((String)("missing geometry[" + i + "]"));
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("//Maya ASCII 4.0 scene\n");
        writer.write("//Produced with JavaView v." + PsConfig.getVersion() + "\n");
        writer.write("//JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + "\n");
        writer.write("//by " + PsConfig.getAuthors() + "\n");
        writer.write("//   File Format           = Maya ASCII 4.0\n");
        writer.write("//   Date                  = " + new Date().toString() + "\n");
        writer.write("//   Scene Title           = " + pgJvxSrc.getTitle() + "\n");
        writer.write("//   Number of Geometries  = " + this.m_numGeoms + "\n");
        for (n2 = 0; n2 < this.m_numGeoms; ++n2) {
            pgJvxSrc = pgJvxSrcArray[n2];
            writer.write("//   Geometry[" + String.valueOf(n2) + "]           = " + pgJvxSrc.getName() + "\n");
            int n3 = pgJvxSrc.getNumVertices();
            writer.write("//   Number of Vertices    = " + n3 + "\n");
            n = pgJvxSrc.getNumElements();
            if (n <= 0) continue;
            writer.write("//   Number of Elements    = " + n + "\n");
        }
        writer.write("//End of Header\n");
        writer.write("requires maya \"4.0\";\n");
        n2 = pgJvxSrcArray[0].getDimOfVertices();
        for (n = 0; n < this.m_numGeoms; ++n) {
            int n4;
            int n5;
            PdVector[][] pdVectorArray;
            pgJvxSrc = pgJvxSrcArray[n];
            String string = pgJvxSrc.getName();
            writer.write("createNode transform -n \"" + string + "P\";\n");
            writer.write("createNode mesh -n \"" + string + "\" -p \"" + string + "P\";\n");
            PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
            int n6 = pgJvxSrc.getNumVertices();
            int n7 = pgJvxSrc.getNumElements();
            boolean bl = false;
            boolean bl2 = false;
            if (pgJvxSrc.isShowingElementTexture()) {
                int n8;
                bl2 = true;
                pdVectorArray = pgJvxSrc.getElementTextures();
                writer.write("setAttr \".uvst[0].uvsn\" -type \"string\" \"map1\";\n");
                n5 = 0;
                for (n8 = 0; n8 < n7; ++n8) {
                    n5 += pgJvxSrc.getElement(n8).getSize();
                }
                writer.write("setAttr -s " + n5 + " \".uvst[0].uvsp[0:" + (n5 - 1) + "]\" -type \"float2\"\n");
                for (n8 = 0; n8 < n7; ++n8) {
                    int n9 = pgJvxSrc.getElement(n8).getSize();
                    for (n4 = 0; n4 < n9; ++n4) {
                        writer.write(String.valueOf(pdVectorArray[n8][(n4 + 1) % n9].m_data[0]) + " " + String.valueOf(pdVectorArray[n8][(n4 + 1) % n9].m_data[1]));
                        if (n8 != n7 - 1 || n4 != n9 - 1) {
                            writer.write("\n");
                            continue;
                        }
                        writer.write(";\n");
                    }
                }
                writer.write("setAttr \".cuvs\" -type \"string\" \"map1\";\n");
            }
            if (!bl2 && pgJvxSrc.isShowingVertexTexture()) {
                bl = true;
                pdVectorArray = pgJvxSrc.getVertexTextures();
                writer.write("setAttr \".uvst[0].uvsn\" -type \"string\" \"map1\";\n");
                writer.write("setAttr -s " + n6 + " \".uvst[0].uvsp[0:" + (n6 - 1) + "]\" -type \"float2\"\n");
                for (n5 = 0; n5 < n6; ++n5) {
                    writer.write(String.valueOf(pdVectorArray[n5].m_data[0]) + " " + String.valueOf(pdVectorArray[n5].m_data[1]));
                    if (n5 != n6 - 1) {
                        writer.write("\n");
                        continue;
                    }
                    writer.write(";\n");
                }
                writer.write("setAttr \".cuvs\" -type \"string\" \"map1\";\n");
            }
            writer.write("setAttr -s " + n6 + " \".vt[0:" + (n6 - 1) + "]\"\n");
            for (int i = 0; i < n6; ++i) {
                for (n5 = 0; n5 < n2; ++n5) {
                    if (Math.abs(pdVectorArray2[i].m_data[n5]) < 1.0E-10) {
                        writer.write("0.0");
                    } else {
                        writer.write(String.valueOf(pdVectorArray2[i].m_data[n5]));
                    }
                    if (n5 != n2 - 1) {
                        writer.write(" ");
                        continue;
                    }
                    if (i != n6 - 1) {
                        writer.write("\n");
                        continue;
                    }
                    writer.write(";\n");
                }
            }
            if (n7 > 0) {
                int n10;
                PiVector piVector;
                int n11;
                PiVector[] piVectorArray = pgJvxSrc.getElements();
                PiVector[] piVectorArray2 = pgJvxSrc.getNeighbours();
                PiVector[] piVectorArray3 = new PiVector[n7];
                Vector<PiVector> vector = new Vector<PiVector>();
                int n12 = 0;
                for (n11 = 0; n11 < n7; ++n11) {
                    piVectorArray3[n11] = new PiVector(piVectorArray[n11].getSize() + 1);
                }
                for (n11 = 0; n11 < n7; ++n11) {
                    piVector = piVectorArray[n11];
                    PiVector piVector2 = piVectorArray2[n11];
                    piVectorArray3[n11].m_data[0] = n4 = piVector.getSize();
                    for (n10 = 0; n10 < n4; ++n10) {
                        if (piVector2.m_data[n10] != -1 && piVector2.m_data[n10] <= n11) continue;
                        int n13 = piVector.m_data[(n10 + 1) % n4];
                        int n14 = piVector.m_data[(n10 + 2) % n4];
                        PiVector piVector3 = new PiVector(n13, n14);
                        piVectorArray3[n11].m_data[n10 + 1] = n12;
                        piVectorArray3[n11].m_data[n10 + 1] = n12;
                        vector.addElement(piVector3);
                        if (piVector2.m_data[n10] != -1) {
                            PiVector piVector4 = piVectorArray[piVector2.m_data[n10]];
                            int n15 = piVector.getSize();
                            for (int i = 0; i < n15; ++i) {
                                if (piVector4.m_data[(i + 1) % n15] == n13 && piVector4.m_data[(i + 2) % n15] == n14) {
                                    piVectorArray3[piVector2.m_data[n10]].m_data[i + 1] = n12;
                                    break;
                                }
                                if (piVector4.m_data[(i + 1) % n15] != n14 || piVector4.m_data[(i + 2) % n15] != n13) continue;
                                piVectorArray3[piVector2.m_data[n10]].m_data[i + 1] = -1 - n12;
                                break;
                            }
                        }
                        ++n12;
                    }
                }
                writer.write("setAttr -s " + n12 + " \".ed[0:" + (n12 - 1) + "]\"\n");
                for (n11 = 0; n11 < n12; ++n11) {
                    writer.write(((PiVector)vector.elementAt((int)n11)).m_data[0] + " " + ((PiVector)vector.elementAt((int)n11)).m_data[1] + " 0");
                    if (n11 != n12 - 1) {
                        writer.write("\n");
                        continue;
                    }
                    writer.write(";\n");
                }
                n11 = 0;
                writer.write("setAttr -s " + n7 + " \".fc[0:" + (n7 - 1) + "]\" -type \"polyFaces\"\n");
                for (n10 = 0; n10 < n7; ++n10) {
                    int n16;
                    piVector = piVectorArray3[n10];
                    n4 = piVector.getSize();
                    writer.write("f");
                    for (n16 = 0; n16 < n4; ++n16) {
                        writer.write(" " + piVector.m_data[n16]);
                    }
                    if (bl2) {
                        writer.write("\nmu 0 " + (n4 - 1));
                        for (n16 = 0; n16 < n4 - 1; ++n16) {
                            writer.write(" " + (n11 + n16));
                        }
                        n11 += n4 - 1;
                    } else if (bl) {
                        writer.write("\nmu 0 " + (n4 - 1));
                        for (n16 = 0; n16 < n4 - 1; ++n16) {
                            writer.write(" " + piVectorArray[n10].m_data[(n16 + 1) % (n4 - 1)]);
                        }
                    }
                    if (n10 != n7 - 1) {
                        writer.write("\n");
                        continue;
                    }
                    writer.write(";\n");
                }
            }
            if (!bl && !bl2) continue;
            writer.write("createNode file -n \"tex\";\n");
            writer.write("setAttr \".ftn\" -type \"string\" \"" + pgJvxSrc.getTextureImageName() + "\";\n");
            writer.write("createNode place2dTexture -n \"place2dTexture1\";\n");
            writer.write("connectAttr \"tex.oc\" \":lambert1.c\";\n");
            writer.write("connectAttr \"" + string + ".iog\" \":initialShadingGroup.dsm\" -na;\n");
        }
        return true;
    }
}

