/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.DataOutputStream;
import java.io.IOException;
import jv.object.PsObject;

class PsU3dBlock
extends PsObject {
    public int m_blockType;
    public int m_blockSize;
    public int m_dataSize;
    public int m_metaDataSize;

    PsU3dBlock() {
    }

    public int getSize() {
        this.computeSize();
        return 12 + 4 * ((this.m_dataSize + 3) / 4) + 4 * ((this.m_metaDataSize + 3) / 4);
    }

    public void computeSize() {
    }

    public void write(DataOutputStream dataOutputStream) {
        this.writeUInt32(dataOutputStream, this.m_blockType);
        this.writeUInt32(dataOutputStream, this.m_dataSize);
        this.writeUInt32(dataOutputStream, this.m_metaDataSize);
    }

    protected void writeUInt8(DataOutputStream dataOutputStream, int n) {
        try {
            dataOutputStream.write((byte)n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeUInt16(DataOutputStream dataOutputStream, int n) {
        try {
            dataOutputStream.write((byte)n);
            dataOutputStream.write((byte)(n >>> 8));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeUInt32(DataOutputStream dataOutputStream, int n) {
        try {
            dataOutputStream.write((byte)n);
            dataOutputStream.write((byte)(n >>> 8));
            dataOutputStream.write((byte)(n >>> 16));
            dataOutputStream.write((byte)(n >>> 24));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeUInt64(DataOutputStream dataOutputStream, long l) {
        try {
            dataOutputStream.write((byte)l);
            dataOutputStream.write((byte)(l >>> 8));
            dataOutputStream.write((byte)(l >>> 16));
            dataOutputStream.write((byte)(l >>> 24));
            dataOutputStream.write((byte)(l >>> 32));
            dataOutputStream.write((byte)(l >>> 40));
            dataOutputStream.write((byte)(l >>> 48));
            dataOutputStream.write((byte)(l >>> 56));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeFloat32(DataOutputStream dataOutputStream, float f) {
        int n = Float.floatToIntBits(f);
        try {
            dataOutputStream.write((byte)n);
            dataOutputStream.write((byte)(n >>> 8));
            dataOutputStream.write((byte)(n >>> 16));
            dataOutputStream.write((byte)(n >>> 24));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeFloat64(DataOutputStream dataOutputStream, double d) {
        long l = Double.doubleToLongBits(d);
        try {
            dataOutputStream.write((byte)l);
            dataOutputStream.write((byte)(l >>> 8));
            dataOutputStream.write((byte)(l >>> 16));
            dataOutputStream.write((byte)(l >>> 24));
            dataOutputStream.write((byte)(l >>> 32));
            dataOutputStream.write((byte)(l >>> 40));
            dataOutputStream.write((byte)(l >>> 48));
            dataOutputStream.write((byte)(l >>> 56));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int writeString(DataOutputStream dataOutputStream, String string) {
        this.writeUInt16(dataOutputStream, string.length());
        int n = (2 + string.length()) % 4;
        try {
            dataOutputStream.writeBytes(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    protected void writePaddingBytes(DataOutputStream dataOutputStream, int n) {
        if (n % 4 == 0) {
            return;
        }
        try {
            for (int i = n; i < 4; ++i) {
                dataOutputStream.write(0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

