/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnStiffConformal;

public class PnConfEnergy
extends PnEnergy {
    static /* synthetic */ Class class$jvx$numeric$PnConfEnergy;

    public PnConfEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnConfEnergy == null ? (class$jvx$numeric$PnConfEnergy = PnConfEnergy.class$("jvx.numeric.PnConfEnergy")) : class$jvx$numeric$PnConfEnergy)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return;
        }
        super.initSurface(pgElementSet, pgElementSet2);
        this.m_stiffMatrix.init(pgElementSet, pgElementSet2);
    }

    private void initStiff(PdVector pdVector) {
        if (this.m_surface == null) {
            return;
        }
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n = 0;
        for (int i = 0; i < this.m_nop; ++i) {
            for (int j = 0; j < this.m_dim; ++j) {
                pdVectorArray[i].m_data[j] = pdVector.m_data[n++];
            }
        }
        this.m_stiffMatrix.init(this.m_domain, this.m_surface);
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (pgElementSet.isConforming() != pgElementSet2.isConforming()) {
            PsDebug.error((String)"domain and surface have different conformality", (Object)((Object)this));
            return false;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)("domain=" + pgElementSet.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (pgElementSet2.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + pgElementSet2.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet2);
        }
        this.m_stiffMatrix = this.m_domain.isConforming() ? new PnStiffConformal(pgElementSet, pgElementSet2) : new PnStiffConformal(pgElementSet, pgElementSet2);
        return true;
    }

    public double eval(PdVector pdVector) {
        this.initStiff(pdVector);
        if (!this.m_bNormal) {
            PdVector pdVector2 = new PdVector(this.m_dim);
            int n = 0;
            for (int i = 0; i < this.m_nop; ++i) {
                int n2;
                for (n2 = 0; n2 < this.m_dim; ++n2) {
                    pdVector2.m_data[n2] = pdVector.m_data[n + n2];
                }
                pdVector2.normalize();
                for (n2 = 0; n2 < this.m_dim; ++n2) {
                    pdVector.m_data[n + n2] = pdVector2.m_data[n2];
                }
                n += this.m_dim;
            }
        }
        return super.eval(pdVector);
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        this.initStiff(pdVector);
        if (!this.m_bNormal && this.m_surface.hasVertexNormals()) {
            PdVector[] pdVectorArray = this.m_surface.getVertexNormals();
            int n = 0;
            for (int i = 0; i < this.m_nop; ++i) {
                for (int j = 0; j < this.m_dim; ++j) {
                    pdVectorArray[i].m_data[j] = pdVector.m_data[n + j];
                }
                pdVectorArray[i].normalize();
                n += this.m_dim;
            }
        }
        return super.evalGradient(pdVector, pdVector2);
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        PsDebug.warning((String)"method not implemented yet");
        return pdMatrix;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

