/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;

public class PnTranslationRK
extends PnGeodesicRK {
    protected double[][][] m_ABT;
    protected PdBaryDir[][] m_base;

    public PnTranslationRK(PgElementSet pgElementSet) {
        super(pgElementSet);
        this.m_ABT = new double[pgElementSet.getNumElements()][3][3];
        this.m_base = new PdBaryDir[pgElementSet.getNumElements()][3];
    }

    public void setVectorField(int[] nArray, PdBaryDir[] pdBaryDirArray, int[] nArray2) {
        int n = this.m_geom.getNumVertices();
        for (int i = 0; i < n; ++i) {
            PiVector piVector = new PiVector();
            PiVector piVector2 = new PiVector();
            PdVector pdVector = new PdVector();
            double d = PwBary.getTransRepresentationValues(this.m_geom, nArray[i], pdBaryDirArray[i], nArray2[i], piVector, piVector2, pdVector);
            double d2 = PwBary.norm(this.m_geom, nArray[i], pdBaryDirArray[i], false);
            int n2 = piVector.getSize();
            for (int j = 0; j < n2; ++j) {
                int n3 = piVector.getEntry(j);
                int n4 = piVector2.getEntry(j);
                this.m_ABT[n3][n4][0] = pdVector.getEntry(j);
                this.m_ABT[n3][n4][1] = d;
                this.m_ABT[n3][n4][2] = d2;
                this.m_base[n3][n4] = new PdBaryDir(3);
                this.m_base[n3][n4].m_data[n4] = -1.0;
                this.m_base[n3][n4].m_data[(n4 + 1) % 3] = 1.0;
                this.m_base[n3][n4].m_data[(n4 + 2) % 3] = 0.0;
                double d3 = PwBary.norm(this.m_geom, n3, this.m_base[n3][n4], false);
                if (d3 < 1.0E-10) {
                    PsDebug.warning((String)"Edges degenerated");
                    continue;
                }
                this.m_base[n3][n4].multScalar(1.0 / d3);
            }
        }
    }

    public void eval(int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        try {
            int n2;
            pdBaryDir.setSize(3);
            PdBaryDir[] pdBaryDirArray = new PdBaryDir[3];
            for (n2 = 0; n2 < 3; ++n2) {
                double d;
                pdBaryDir.m_data[n2] = 0.0;
                pdBaryDirArray[n2] = new PdBaryDir(3);
                pdBaryDirArray[n2].m_data[n2] = -1.0;
                pdBaryDirArray[n2].m_data[(n2 + 1) % 3] = 0.0;
                pdBaryDirArray[n2].m_data[(n2 + 1) % 3] = 0.0;
                for (int i = 0; i < 3; ++i) {
                    int n3 = i;
                    pdBaryDirArray[n2].m_data[n3] = pdBaryDirArray[n2].m_data[n3] + pdBary.m_data[i];
                }
                double d2 = PwBary.norm(this.m_geom, n, pdBaryDirArray[n2], false);
                if (d2 < 1.0E-10) {
                    pdBaryDirArray[n2].m_data[n2] = -1.0;
                    pdBaryDirArray[n2].m_data[(n2 + 1) % 3] = 0.0;
                    pdBaryDirArray[n2].m_data[(n2 + 2) % 3] = 1.0;
                    d = PwBary.getOrientedAngle(this.m_geom, n, this.m_base[n][n2], pdBaryDirArray[n2], false);
                    d /= 2.0;
                } else {
                    d = PwBary.getOrientedAngle(this.m_geom, n, this.m_base[n][n2], pdBaryDirArray[n2], false);
                }
                double d3 = d - Math.PI * 2 / this.m_ABT[n][n2][1] * (this.m_ABT[n][n2][0] + d);
                PwBary.rotateInElement(this.m_geom, n, this.m_base[n][n2], d3, pdBaryDirArray[n2], false);
                pdBaryDirArray[n2].multScalar(this.m_ABT[n][n2][2]);
            }
            for (n2 = 0; n2 < 3; ++n2) {
                for (int i = 0; i < 3; ++i) {
                    int n4 = n2;
                    pdBaryDir.m_data[n4] = pdBaryDir.m_data[n4] + pdBary.m_data[i] * pdBaryDirArray[i].m_data[n2];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            PsDebug.warning((String)"Invalid vector field.");
        }
        catch (NullPointerException nullPointerException) {
            PsDebug.warning((String)"Invalid vector field or missing outdir.");
        }
    }
}

