/*
 * Decompiled with CFR 0.152.
 */
package jvx.primitive;

import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.surface.PgDomainDescr;

public class PgSphere
extends PgElementSet {
    protected PgDomainDescr m_domainDescr;
    protected PuFunction m_function;
    protected PdVector m_baseDef;
    protected PdVector m_base;
    protected double m_radiusDef;
    protected PuDouble m_radius;
    static /* synthetic */ Class class$jvx$primitive$PgSphere;

    public PgSphere() {
        super(3);
        this.setName("Sphere");
        this.setTag(10);
        this.m_domainDescr = new PgDomainDescr(2);
        this.m_domainDescr.setParent((PsUpdateIf)this);
        this.m_domainDescr.setName(PsConfig.getMessage((boolean)true, (int)45000, (String)"Domain"));
        this.m_domainDescr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        this.m_domainDescr.setSize(0.0, -1.5707963267948966, Math.PI * 2, 1.5707963267948966);
        this.m_domainDescr.setDiscr(25, 15);
        this.m_function = new PuFunction(2, 3);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName(PsConfig.getMessage((boolean)true, (int)45000, (String)"Sphere"));
        this.m_function.setVariables(new String[]{"u", "v"});
        this.m_function.addParameter("r1", 1.0);
        this.m_function.addParameter("x", 0.0);
        this.m_function.addParameter("y", 0.0);
        this.m_function.addParameter("z", 0.0);
        this.m_function.setExpression(0, "x+r1*cos(u)*cos(v)");
        this.m_function.setExpression(1, "y+r1*sin(u)*cos(v)");
        this.m_function.setExpression(2, "z+r1*sin(v)");
        this.m_baseDef = new PdVector(3);
        this.m_base = new PdVector(3);
        this.m_radiusDef = 1.0;
        this.m_radius = new PuDouble(PsConfig.getMessage((boolean)true, (int)54000, (String)"Radius"), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$primitive$PgSphere == null ? (class$jvx$primitive$PgSphere = PgSphere.class$("jvx.primitive.PgSphere")) : class$jvx$primitive$PgSphere)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_domainDescr.init();
        this.m_base.copy(this.m_baseDef);
        this.m_radius.setDefBounds(0.0, 10.0 * this.m_radiusDef, this.m_radiusDef / 10.0, this.m_radiusDef);
        this.m_radius.setDefValue(this.m_radiusDef);
        this.m_radius.init();
    }

    public Object clone() {
        PgSphere pgSphere = (PgSphere)((Object)super.clone());
        pgSphere.m_domainDescr = (PgDomainDescr)((Object)this.m_domainDescr.clone());
        pgSphere.m_domainDescr.setParent((PsUpdateIf)pgSphere);
        pgSphere.m_function = (PuFunction)this.m_function.clone();
        pgSphere.m_function.setParent((PsUpdateIf)pgSphere);
        pgSphere.m_base = (PdVector)this.m_base.clone();
        pgSphere.m_baseDef = (PdVector)this.m_baseDef.clone();
        pgSphere.m_radius = (PuDouble)this.m_radius.clone();
        pgSphere.m_radius.setParent((PsUpdateIf)pgSphere);
        return pgSphere;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PgSphere)) {
            return;
        }
        PgSphere pgSphere = (PgSphere)psObject;
        this.m_domainDescr.copy(pgSphere.m_domainDescr);
        this.m_function.copy((PsObject)pgSphere.m_function);
        this.m_base.copy(pgSphere.m_base);
        this.m_baseDef.copy(pgSphere.m_baseDef);
        this.m_radius.copy(pgSphere.m_radius);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgSphere *********\n");
        stringBuffer.append(this.m_domainDescr.toString());
        stringBuffer.append(this.m_base.toString());
        stringBuffer.append(this.m_radius.toString());
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object == null) {
            return super.update(null);
        }
        if (object == this) {
            this.compute();
            return super.update(object);
        }
        if (object == this.m_domainDescr) {
            return this.update((Object)this);
        }
        if (object == this.m_function) {
            return this.update((Object)this);
        }
        if (object == this.m_radius) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    public PgDomainDescr getDomainDescr() {
        return this.m_domainDescr;
    }

    public void setDomainDescr(PgDomainDescr pgDomainDescr) {
        if (pgDomainDescr == null) {
            PsDebug.warning((String)"missing argument domainDescr");
            return;
        }
        this.m_domainDescr.copy(pgDomainDescr);
    }

    public double getRadius() {
        return this.m_radius.getValue();
    }

    public void setRadius(double d) {
        this.m_radiusDef = d;
        this.m_radius.setValue(d);
    }

    public PdVector getBase() {
        return this.m_base;
    }

    public void setBase(PdVector pdVector) {
        this.m_baseDef.copy(pdVector);
        this.m_base.copy(pdVector);
    }

    public void compute() {
        this.m_function.setParameter("r1", this.m_radius.getValue());
        this.m_function.setParameter("x", this.m_base.getEntry(0));
        this.m_function.setParameter("y", this.m_base.getEntry(1));
        this.m_function.setParameter("z", this.m_base.getEntry(2));
        int n = this.m_domainDescr.getNumULines();
        int n2 = this.m_domainDescr.getNumVLines();
        this.setNumVertices(n * n2);
        double[] dArray = new double[2];
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.m_domainDescr.eval(dArray, i, j);
                this.m_function.eval(pdVector.m_data, dArray);
                this.setVertex(n3, pdVector);
                ++n3;
            }
        }
        this.setDimOfElements(4);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
        this.makeElementNormals();
        this.makeVertexNormals();
        this.makeVertexTextureFromUV();
    }

    public boolean makeVertexTextureFromUV() {
        if (((PgPointSet)this).m_numVertices == 0) {
            return true;
        }
        if (this.m_domainDescr == null) {
            return true;
        }
        int n = this.m_domainDescr.getNumULines();
        int n2 = this.m_domainDescr.getNumVLines();
        return this.makeVertexTextureFromUV(n, n2, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

