/*
 * Decompiled with CFR 0.152.
 */
package jvx.primitive;

import java.awt.Color;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;

public class PuIntervalDescr
extends PsObject {
    protected PuDouble m_uMin;
    protected PuDouble m_uMax;
    private double m_defUMin = -20.0;
    private double m_defUMax = 20.0;
    private double[] m_savedSize = null;
    private double[] m_maxSize = null;
    protected PuInteger m_discr;
    private int m_defNumULines;
    private int m_savedNumULines = this.m_defNumULines = 9;
    protected boolean m_bShowULine = false;
    protected double m_stripSize = 0.1;
    static /* synthetic */ Class class$jvx$primitive$PuIntervalDescr;

    public PuIntervalDescr() {
        this.m_uMin = new PuDouble(PsConfig.getMessage((int)54000), (PsUpdateIf)this);
        this.m_uMax = new PuDouble(PsConfig.getMessage((int)54001), (PsUpdateIf)this);
        this.m_discr = new PuInteger(PsConfig.getMessage((boolean)true, (int)54000, (String)"Discretization"), (PsUpdateIf)this);
        this.m_savedSize = new double[2];
        if (((Object)((Object)this)).getClass() == (class$jvx$primitive$PuIntervalDescr == null ? (class$jvx$primitive$PuIntervalDescr = PuIntervalDescr.class$("jvx.primitive.PuIntervalDescr")) : class$jvx$primitive$PuIntervalDescr)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.showULine(false);
        if (this.m_maxSize != null) {
            this.m_uMin.setDefBounds(this.m_maxSize[0], this.m_maxSize[1], 0.1, 1.0);
            this.m_uMax.setDefBounds(this.m_maxSize[0], this.m_maxSize[1], 0.1, 1.0);
        } else {
            this.m_uMin.setDefBounds(this.m_defUMin - 2.0 * (this.m_defUMax - this.m_defUMin), this.m_defUMin + 2.0 * (this.m_defUMax - this.m_defUMin), 0.1, 1.0);
            this.m_uMax.setDefBounds(this.m_defUMax - 2.0 * (this.m_defUMax - this.m_defUMin), this.m_defUMax + 2.0 * (this.m_defUMax - this.m_defUMin), 0.1, 1.0);
        }
        this.m_uMin.setDefValue(this.m_defUMin);
        this.m_uMin.init();
        this.m_uMax.setDefValue(this.m_defUMax);
        this.m_uMin.init();
        this.setSize(this.m_defUMin, this.m_defUMax);
        this.m_discr.setDefBounds(2, 5 * this.m_defNumULines, 1, 5);
        this.m_discr.setDefValue(this.m_defNumULines);
        this.m_discr.init();
    }

    public Object clone() {
        PuIntervalDescr puIntervalDescr = (PuIntervalDescr)((Object)super.clone());
        if (puIntervalDescr == null) {
            return null;
        }
        puIntervalDescr.m_uMin = (PuDouble)this.m_uMin.clone();
        puIntervalDescr.m_uMin.setParent((PsUpdateIf)puIntervalDescr);
        puIntervalDescr.m_uMax = (PuDouble)this.m_uMax.clone();
        puIntervalDescr.m_uMax.setParent((PsUpdateIf)puIntervalDescr);
        puIntervalDescr.m_discr = (PuInteger)this.m_discr.clone();
        puIntervalDescr.m_discr.setParent((PsUpdateIf)puIntervalDescr);
        this.m_savedSize = (double[])this.m_savedSize.clone();
        if (this.m_maxSize != null) {
            this.m_maxSize = (double[])this.m_maxSize.clone();
        }
        return puIntervalDescr;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (!(psObject instanceof PuIntervalDescr)) {
            return;
        }
        PuIntervalDescr puIntervalDescr = (PuIntervalDescr)psObject;
        this.m_uMin.copy(puIntervalDescr.m_uMin);
        this.m_uMax.copy(puIntervalDescr.m_uMax);
        this.m_discr.copy(puIntervalDescr.m_discr);
        this.m_savedSize = (double[])puIntervalDescr.m_savedSize.clone();
        if (this.m_maxSize != null) {
            this.m_maxSize = (double[])puIntervalDescr.m_maxSize.clone();
        }
        this.showULine(puIntervalDescr.isShowingULine());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PuIntervalDescr ***********\n");
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object == this.m_uMin) {
            if (this.m_bShowULine) {
                this.m_uMax.setValue(this.m_uMin.getValue() + this.m_stripSize);
            }
            return super.update(null);
        }
        if (object == this.m_uMax) {
            return super.update(null);
        }
        if (object == this.m_discr) {
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean isShowingULine() {
        return this.m_bShowULine;
    }

    public void showULine(boolean bl) {
        if (this.m_bShowULine == bl) {
            return;
        }
        this.m_bShowULine = bl;
        this.m_uMax.setEnabled(!this.m_bShowULine);
        if (this.m_bShowULine) {
            if (this.m_uMin.hasInspector("Info")) {
                PsPanel psPanel = this.m_uMin.getInfoPanel();
                psPanel.setBackground(Color.red.darker());
                psPanel.validate();
            }
            this.m_savedSize[0] = this.m_uMin.getValue();
            this.m_savedSize[2] = this.m_uMax.getValue();
            double d = (this.m_uMin.getValue() + this.m_uMax.getValue()) / 2.0;
            this.m_uMin.setValue(d);
            this.m_uMax.setValue(d + this.m_stripSize);
            this.m_savedNumULines = this.m_discr.getValue();
            this.m_discr.setValue(2);
        } else {
            if (this.m_uMin.hasInspector("Info")) {
                PsPanel psPanel = this.m_uMin.getInfoPanel();
                psPanel.setBackground(Color.white);
                psPanel.validate();
            }
            this.m_uMin.setValue(this.m_savedSize[0]);
            this.m_uMax.setValue(this.m_savedSize[2]);
            this.m_discr.setValue(this.m_savedNumULines);
        }
    }

    private void setDefDiscr(int n) {
        this.m_defNumULines = n;
    }

    private void setDefSize(double d, double d2) {
        this.m_defUMin = d;
        this.m_defUMax = d2;
    }

    public void setMaxSize(double d, double d2) {
        this.m_maxSize = new double[]{d, d2};
        this.m_uMin.setBounds(d, d2);
        this.m_uMax.setBounds(d, d2);
        if (this.m_defUMin < d) {
            this.m_defUMin = d;
        }
        if (this.m_defUMax > d2) {
            this.m_defUMax = d2;
        }
    }

    public void setSize(double d, double d2) {
        if (this.m_maxSize == null) {
            this.m_uMin.setBounds(d - 2.0 * (d2 - d), d + 2.0 * (d2 - d), 0.1, 1.0);
            this.m_uMax.setBounds(d2 - 2.0 * (d2 - d), d2 + 2.0 * (d2 - d), 0.1, 1.0);
        }
        this.m_uMin.setValue(d);
        this.m_uMax.setValue(d2);
        this.setDefSize(d, d2);
    }

    public double getUMin() {
        return this.m_uMin.getValue();
    }

    public void setUMin(double d) {
        this.m_uMin.setValue(d);
        this.m_defUMin = d;
    }

    public double getUMax() {
        return this.m_uMax.getValue();
    }

    public void setUMax(double d) {
        this.m_uMax.setValue(d);
        this.m_defUMax = d;
    }

    public int getDiscr() {
        return this.m_discr.getValue();
    }

    public void setDiscr(int n) {
        this.m_discr.setValue(n);
        this.setDefDiscr(n);
    }

    public void setDiscrBounds(int n, int n2) {
        this.m_discr.setDefBounds(n, n2, 1, 5);
        this.m_discr.setBounds(n, n2, 1, 5);
    }

    public double eval(int n) {
        double d = this.m_uMin.getValue();
        if (this.m_discr.getValue() > 1) {
            d += (this.m_uMax.getValue() - this.m_uMin.getValue()) * (double)n / (double)(this.m_discr.getValue() - 1);
        }
        return d;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

