/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jv.geom.PgTexture;
import jv.number.PdArray_IP;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsMultiLineLabel;
import jv.objectGui.PsSlotLayout;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.volume.PgCubeSet;

public class PgCubeSet_TP
extends PsPanel
implements ActionListener,
ItemListener,
WindowListener {
    protected PgCubeSet m_cubeSet;
    protected CheckboxGroup m_gTypeMode;
    protected Checkbox m_cCubeTex;
    protected Checkbox m_cVertexTex;
    protected Panel m_pNumTextures;
    protected PdArray_IP m_texturePanel;
    protected int m_maxVisibleVectors = 5;
    protected int m_maxVisibleDim = 5;
    protected static String[] m_vertexHeader = new String[]{"0", "1", "2", "3", "4", "5"};
    protected static String[] m_tetraHeader = new String[]{"0", "1", "2"};
    protected PsPanel m_pTexture;
    protected PsMultiLineLabel m_lNotice;
    protected Button m_bClose;
    protected Checkbox m_cShowTexture;
    protected Button m_bShowDomain;
    protected Checkbox m_cShowMesh;
    protected Checkbox m_cSyncSelect;
    protected Checkbox m_cSyncLabels;
    protected PvDisplayIf m_display;
    protected PgCubeSet m_texGeom;
    protected PgCubeSet m_imgGeom;
    private boolean m_bUpdateFromHere = false;
    private boolean m_bDomainMode;
    private Color m_colorDomainMode;
    protected PuInteger m_cubeInd;
    private PsPanel m_pCubeSlider;
    static /* synthetic */ Class class$jvx$volume$PgCubeSet_TP;

    public PgCubeSet_TP() {
        if (this.getClass() == (class$jvx$volume$PgCubeSet_TP == null ? (class$jvx$volume$PgCubeSet_TP = PgCubeSet_TP.class$("jvx.volume.PgCubeSet_TP")) : class$jvx$volume$PgCubeSet_TP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        this.m_bDomainMode = false;
        Panel panel = new Panel((LayoutManager)new PsSlotLayout(2));
        Label label = this.getTitle("", PsConfig.getFont((int)3));
        panel.add("1", label);
        this.m_cShowTexture = new Checkbox(PsConfig.getMessage((boolean)true, (int)24000, (String)"Enable Texture"));
        this.m_cShowTexture.addItemListener(this);
        panel.add("1", this.m_cShowTexture);
        ((Container)((Object)this)).add(panel);
        label = new PsPanel((LayoutManager)new GridLayout(1, 2));
        ((Container)((Object)this)).add(label);
        label.addSubTitle(PsConfig.getMessage((int)24035));
        Object object = new PsPanel((LayoutManager)new GridLayout(1, 2));
        this.m_gTypeMode = new CheckboxGroup();
        this.m_cVertexTex = new Checkbox(PsConfig.getMessage((int)24036), this.m_gTypeMode, true);
        this.m_cVertexTex.addItemListener(this);
        ((Container)object).add(this.m_cVertexTex);
        this.m_cCubeTex = new Checkbox(PsConfig.getMessage((boolean)true, (int)24000, (String)"Cube"), this.m_gTypeMode, false);
        this.m_cCubeTex.addItemListener(this);
        ((Container)object).add(this.m_cCubeTex);
        this.m_gTypeMode.setSelectedCheckbox(this.m_cVertexTex);
        this.m_cCubeTex.setEnabled(false);
        ((Container)((Object)label)).add((Component)object);
        this.m_texturePanel = new PdArray_IP(this.m_maxVisibleVectors, this.m_maxVisibleDim);
        this.m_texturePanel.setNumOfEntries(0, 2);
        this.m_texturePanel.setHeader(m_vertexHeader);
        this.m_texturePanel.setParent((PsUpdateIf)this);
        ((Container)((Object)this)).add((Component)this.m_texturePanel);
        this.m_pCubeSlider = new PsPanel();
        this.m_cubeInd = new PuInteger(PsConfig.getMessage((boolean)true, (int)24000, (String)"Cube Index"), (PsUpdateIf)this);
        ((Container)((Object)this)).add((Component)this.m_pCubeSlider);
        object = new Panel((LayoutManager)new PsSlotLayout(5));
        PsPanel psPanel = new PsPanel((LayoutManager)new BorderLayout());
        Label label2 = psPanel.getTitle(PsConfig.getMessage((int)24037), PsConfig.getFont((int)3));
        psPanel.add((Component)label2, "North");
        ((Container)object).add("1", (Component)psPanel);
        label2 = new PsPanel((LayoutManager)new GridLayout(2, 2));
        this.m_cSyncLabels = new Checkbox(PsConfig.getMessage((boolean)true, (int)24000, (String)"Sync Labels"));
        this.m_cSyncLabels.setState(false);
        this.m_cSyncLabels.addItemListener(this);
        ((Container)((Object)label2)).add(this.m_cSyncLabels);
        this.m_cShowMesh = new Checkbox(PsConfig.getMessage((int)24040));
        this.m_cShowMesh.setEnabled(false);
        this.m_cShowMesh.setState(true);
        this.m_cShowMesh.addItemListener(this);
        ((Container)((Object)label2)).add(this.m_cShowMesh);
        this.m_cSyncSelect = new Checkbox(PsConfig.getMessage((boolean)true, (int)24000, (String)"Sync Selection"));
        this.m_cSyncSelect.setState(true);
        this.m_cSyncSelect.addItemListener(this);
        ((Container)((Object)label2)).add(this.m_cSyncSelect);
        this.m_bShowDomain = new Button(PsConfig.getMessage((int)24038));
        this.m_bShowDomain.setEnabled(false);
        this.m_bShowDomain.addActionListener(this);
        ((Container)((Object)label2)).add(this.m_bShowDomain);
        ((Container)object).add("4", label2);
        ((Container)((Object)this)).add((Component)object);
        this.m_pTexture = new PsPanel();
        this.m_pTexture.setInsetSize(4);
        this.m_lNotice = new PsMultiLineLabel("\n" + PsConfig.getMessage((int)24041));
        this.m_pTexture.add((Component)this.m_lNotice);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_cubeSet = (PgCubeSet)psUpdateIf;
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (this.m_cubeSet == null) {
            PsDebug.warning((String)"missing cubeSet");
            return true;
        }
        if (this.m_bUpdateFromHere) {
            return true;
        }
        if (object == this.m_cubeSet) {
            this.setTitle(PsConfig.getMessage((int)24042) + ": " + this.m_cubeSet.getName());
            PsPanel.setState((Checkbox)this.m_cShowTexture, (boolean)this.m_cubeSet.m_bShowCubeTexture);
            boolean bl = this.m_cubeSet.hasVertexTextures();
            boolean bl2 = this.m_cubeSet.hasCubeTextures();
            Checkbox checkbox = this.m_cVertexTex;
            Checkbox checkbox2 = this.m_cCubeTex;
            if (this.m_cubeSet.m_cubeTexture != null) {
                checkbox = this.m_cCubeTex;
                checkbox2 = this.m_cVertexTex;
            }
            if (this.m_gTypeMode.getSelectedCheckbox() != checkbox) {
                this.m_gTypeMode.setSelectedCheckbox(checkbox);
                checkbox.setEnabled(true);
                checkbox2.setEnabled(false);
            }
            if (bl || bl2) {
                PsPanel.setState((Checkbox)this.m_cVertexTex, (boolean)bl);
                PsPanel.setState((Checkbox)this.m_cCubeTex, (boolean)bl2);
                this.updateTextureGeometry(this.m_cubeSet);
                if (this.m_texGeom != null) {
                    this.m_bUpdateFromHere = true;
                    this.m_texGeom.update(null);
                    this.m_bUpdateFromHere = false;
                }
                int n = this.m_cubeSet.getDimOfTextures();
                if (this.m_cVertexTex.getState()) {
                    if (this.m_pCubeSlider.getComponentCount() != 0) {
                        this.m_pCubeSlider.removeAll();
                        this.m_pCubeSlider.validate();
                        ((Container)((Object)this)).validate();
                    }
                    this.m_texturePanel.setVector(this.m_cubeSet.getVertexTextures(), m_vertexHeader, this.m_cubeSet.getNumVertices(), n);
                } else if (this.m_cCubeTex.getState()) {
                    if (this.m_pCubeSlider.getComponentCount() == 0) {
                        this.m_pCubeSlider.add((Component)this.m_cubeInd.getInfoPanel());
                        this.m_pCubeSlider.add((Component)this.m_cubeInd.getInfoPanel());
                        this.m_pCubeSlider.validate();
                        ((Container)((Object)this)).validate();
                    }
                    this.m_cubeInd.setBounds(0, this.m_cubeSet.getNumCubes() - 1, 1, 5);
                    this.m_cubeInd.updatePanels((Object)this.m_cubeInd);
                    int n2 = this.m_cubeInd.getValue();
                    int n3 = this.m_cubeSet.getCube(n2).getSize();
                    this.m_texturePanel.setVector(this.m_cubeSet.getCubeTexture(n2), m_vertexHeader, n3, n);
                }
            } else if (this.m_pCubeSlider.getComponentCount() != 0) {
                this.m_pCubeSlider.removeAll();
                this.m_pCubeSlider.validate();
            }
            PsPanel.setEnabled((Component)this.m_cShowTexture, (bl || bl2 ? 1 : 0) != 0);
            PsPanel.setEnabled((Component)this.m_texturePanel, (bl || bl2 ? 1 : 0) != 0);
            PsPanel.setEnabled((Component)this.m_pCubeSlider, (bl || bl2 ? 1 : 0) != 0);
            PgTexture pgTexture = this.m_cubeSet.getTexture();
            if (pgTexture != null) {
                PsPanel psPanel = pgTexture.getInfoPanel();
                if (this.m_pTexture.getComponentCount() > 0 && this.m_pTexture.getComponent(0) != psPanel) {
                    this.m_pTexture.removeAll();
                }
                if (this.m_pTexture.getComponentCount() == 0) {
                    this.m_pTexture.add((Component)psPanel);
                    ((Container)((Object)this)).validate();
                }
                if (this.m_imgGeom != null) {
                    this.m_imgGeom.setTexture(pgTexture);
                }
                psPanel.update((Object)pgTexture);
            } else {
                if (this.m_bDomainMode) {
                    this.closeDomainMode();
                }
                if (this.m_pTexture.getComponentCount() > 0 && this.m_pTexture.getComponent(0) != this.m_lNotice) {
                    this.m_pTexture.removeAll();
                    this.m_pTexture.add((Component)this.m_lNotice);
                    ((Container)((Object)this)).validate();
                }
            }
            if (this.m_texGeom != null && this.m_imgGeom != null) {
                this.syncImageGeometry(this.m_texGeom.getBounds());
                this.m_bUpdateFromHere = true;
                this.m_imgGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
            boolean bl3 = pgTexture != null && pgTexture.getImage() != null && (bl || bl2);
            bl3 = true;
            PsPanel.setEnabled((Component)this.m_bShowDomain, (boolean)bl3);
            PsPanel.setEnabled((Component)this.m_cShowMesh, (boolean)bl3);
            PsPanel.setEnabled((Component)this.m_cSyncLabels, (boolean)bl3);
            PsPanel.setEnabled((Component)this.m_cSyncSelect, (boolean)bl3);
            return super.update(object);
        }
        if (object == this.m_texGeom) {
            PdVector[] pdVectorArray = this.m_texGeom.getVertices();
            if (this.m_cVertexTex.getState()) {
                this.m_cubeSet.setVertexTextures(pdVectorArray);
            } else {
                PdVector[][] pdVectorArray2 = this.m_cubeSet.getCubeTextures();
                int n = this.m_cubeSet.getNumCubes();
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    int n5 = pdVectorArray2[i].length;
                    for (int j = 0; j < n5; ++j) {
                        pdVectorArray2[i][j].copy(pdVectorArray[n4]);
                        ++n4;
                    }
                }
            }
            this.syncGeometrySelect(this.m_cSyncSelect.getState());
            this.m_texturePanel.update((Object)this);
            if (this.m_texGeom != null && this.m_imgGeom != null && this.syncImageGeometry(this.m_texGeom.getBounds())) {
                this.m_bUpdateFromHere = true;
                this.m_imgGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
            this.m_bUpdateFromHere = true;
            this.m_cubeSet.update(this);
            this.m_bUpdateFromHere = false;
            return true;
        }
        if (object == this.m_texturePanel) {
            if (this.m_cVertexTex.getState()) {
                this.m_texGeom.setVertices(this.m_cubeSet.getVertexTextures());
            } else {
                PdVector[][] pdVectorArray = this.m_cubeSet.getCubeTextures();
                int n = this.m_cubeSet.getNumCubes();
                int n6 = this.m_cubeInd.getValue();
                int n7 = 0;
                for (int i = 0; i < n; ++i) {
                    int n8 = pdVectorArray[i].length;
                    if (i == n6) {
                        for (int j = 0; j < n8; ++j) {
                            this.m_texGeom.setVertex(n7, pdVectorArray[i][j]);
                            ++n7;
                        }
                        continue;
                    }
                    n7 += n8;
                }
            }
            this.m_bUpdateFromHere = true;
            this.m_texGeom.update(null);
            this.m_bUpdateFromHere = false;
            if (this.m_texGeom != null && this.m_imgGeom != null && this.syncImageGeometry(this.m_texGeom.getBounds())) {
                this.m_bUpdateFromHere = true;
                this.m_imgGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
            this.syncGeometrySelect(this.m_cSyncSelect.getState());
            this.m_bUpdateFromHere = true;
            this.m_cubeSet.update(this);
            this.m_bUpdateFromHere = false;
            return true;
        }
        if (object == this.m_cubeInd) {
            int n = this.m_cubeInd.getValue();
            int n9 = this.m_cubeSet.getCube(n).getSize();
            this.m_texturePanel.setVector(this.m_cubeSet.getCubeTexture(n), m_vertexHeader, n9, this.m_cubeSet.getDimOfTextures());
        }
        return super.update(object);
    }

    protected void updateTextureGeometry(PgCubeSet pgCubeSet) {
        if (!(pgCubeSet.hasVertexTextures() && this.m_cVertexTex.getState() || pgCubeSet.hasCubeTextures() && this.m_cCubeTex.getState())) {
            this.m_texGeom = null;
            return;
        }
        if (this.m_texGeom == null) {
            this.m_texGeom = new PgCubeSet(3);
            this.m_texGeom.setParent((PsUpdateIf)this);
        }
        this.m_texGeom.setName(PsConfig.getMessage((int)15002) + " " + pgCubeSet.getName());
        this.m_texGeom.setDimOfVertices(pgCubeSet.getDimOfTextures());
        if (pgCubeSet.hasVertexTextures() && this.m_cVertexTex.getState()) {
            this.m_texGeom.showVertexTexture(true);
            this.m_texGeom.showCubeTexture(false);
            this.m_texGeom.setNumVertices(pgCubeSet.getNumVertices());
            this.m_texGeom.setVertices(pgCubeSet.getVertexTextures());
            this.m_texGeom.copyConnectivity(pgCubeSet);
        } else if (pgCubeSet.hasCubeTextures() && this.m_cCubeTex.getState()) {
            this.m_texGeom.showVertexTexture(false);
            this.m_texGeom.showCubeTexture(true);
            int n = pgCubeSet.getNumCubeIndices();
            int n2 = pgCubeSet.getNumCubes();
            this.m_texGeom.setNumVertices(n);
            this.m_texGeom.setNumCubes(n2);
            PiVector[] piVectorArray = this.m_texGeom.getCubes();
            PiVector.copy((PiVector[])piVectorArray, (int)0, (PiVector[])pgCubeSet.getCubes(), (int)0, (int)n2);
            PiVector.setConstant((PiVector[])this.m_texGeom.m_neighbour, (int)-1);
            this.m_texGeom.assureCubeTextures();
            PdVector[][] pdVectorArray = pgCubeSet.getCubeTextures();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = piVectorArray[i].getSize();
                for (int j = 0; j < n4; ++j) {
                    this.m_texGeom.setVertex(n3, pdVectorArray[i][j]);
                    piVectorArray[i].m_data[j] = n3++;
                }
            }
        }
        this.syncTextureLabels(this.m_cSyncLabels.getState());
        this.syncTextureSelect(this.m_cSyncSelect.getState());
    }

    private boolean syncImageGeometry(PdVector[] pdVectorArray) {
        PdVector[] pdVectorArray2 = PdVector.realloc(null, (int)2, (int)3);
        for (int i = 0; i < 2; ++i) {
            pdVectorArray2[0].setEntry(i, Math.floor(pdVectorArray[0].getEntry(i)));
            pdVectorArray2[1].setEntry(i, Math.ceil(pdVectorArray[1].getEntry(i)));
        }
        PdVector[] pdVectorArray3 = this.m_imgGeom.getBounds();
        if (PdVector.sqrDist((PdVector)pdVectorArray2[0], (PdVector)pdVectorArray3[0]) < 1.0E-10 && PdVector.sqrDist((PdVector)pdVectorArray2[1], (PdVector)pdVectorArray3[1]) < 1.0E-10) {
            return false;
        }
        this.m_imgGeom.computePlane(20, 20, pdVectorArray2[0].getEntry(0), pdVectorArray2[0].getEntry(1), pdVectorArray2[1].getEntry(0), pdVectorArray2[1].getEntry(1));
        this.m_imgGeom.assureVertexTextures();
        this.m_imgGeom.setVertexTextures(this.m_imgGeom.getVertices());
        return true;
    }

    private void syncTextureLabels(boolean bl) {
        if (bl) {
            this.m_texGeom.showVertexLabels(this.m_cubeSet.isShowingVertexLabels());
            this.m_texGeom.showVertices(this.m_cubeSet.isShowingVertexLabels());
            this.m_texGeom.showCubeLabels(this.m_cubeSet.isShowingCubeLabels());
        } else {
            this.m_texGeom.showVertexLabels(false);
            this.m_texGeom.showVertices(false);
            this.m_texGeom.showCubeLabels(false);
        }
    }

    private void syncTextureSelect(boolean bl) {
        if (!bl) {
            return;
        }
        PdVector[] pdVectorArray = this.m_cubeSet.getVertices();
        PdVector[] pdVectorArray2 = this.m_texGeom.getVertices();
        if (this.m_cVertexTex.getState()) {
            PdVector[] pdVectorArray3 = this.m_cubeSet.getVertexTextures();
            int n = this.m_texGeom.getNumVertices();
            for (int i = 0; i < n; ++i) {
                if (pdVectorArray[i].hasTag(1)) {
                    pdVectorArray2[i].setTag(1);
                } else {
                    pdVectorArray2[i].clearTag(1);
                }
                if (pdVectorArray[i].hasTag(1)) {
                    pdVectorArray3[i].setTag(1);
                    continue;
                }
                pdVectorArray3[i].clearTag(1);
            }
        } else {
            PiVector[] piVectorArray = this.m_cubeSet.getCubes();
            PdVector[][] pdVectorArray4 = this.m_cubeSet.getCubeTextures();
            int n = this.m_cubeSet.getNumCubes();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = piVectorArray[i].getSize();
                for (int j = 0; j < n3; ++j) {
                    int n4 = piVectorArray[i].getEntry(j);
                    if (pdVectorArray[n4].hasTag(1)) {
                        pdVectorArray2[n2].setTag(1);
                    } else {
                        pdVectorArray2[n2].clearTag(1);
                    }
                    if (pdVectorArray[n4].hasTag(1)) {
                        pdVectorArray4[i][j].setTag(1);
                    } else {
                        pdVectorArray4[i][j].clearTag(1);
                    }
                    ++n2;
                }
            }
        }
    }

    private void syncGeometrySelect(boolean bl) {
        if (!bl) {
            return;
        }
        int n = this.m_cubeSet.getNumVertices();
        PdVector[] pdVectorArray = this.m_cubeSet.getVertices();
        PdVector[] pdVectorArray2 = this.m_texGeom.getVertices();
        if (this.m_cVertexTex.getState()) {
            for (int i = 0; i < n; ++i) {
                if (pdVectorArray2[i].hasTag(1)) {
                    pdVectorArray[i].setTag(1);
                    continue;
                }
                pdVectorArray[i].clearTag(1);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].clearTag(1);
            }
            PiVector[] piVectorArray = this.m_cubeSet.getCubes();
            PdVector[][] pdVectorArray3 = this.m_cubeSet.getCubeTextures();
            int n2 = this.m_cubeSet.getNumCubes();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = piVectorArray[i].getSize();
                for (int j = 0; j < n4; ++j) {
                    int n5 = piVectorArray[i].getEntry(j);
                    if (pdVectorArray2[n3].hasTag(1)) {
                        pdVectorArray[n5].setTag(1);
                    }
                    if (pdVectorArray2[n3].hasTag(1)) {
                        pdVectorArray3[i][j].setTag(1);
                    } else {
                        pdVectorArray3[i][j].clearTag(1);
                    }
                    ++n3;
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bClose) {
            this.closeDomainMode();
        } else if (object == this.m_bShowDomain) {
            if (!this.m_bDomainMode) {
                this.m_bDomainMode = true;
                this.m_colorDomainMode = this.m_bShowDomain.getBackground();
                this.m_bShowDomain.setBackground(Color.red);
                this.m_bShowDomain.setLabel(PsConfig.getMessage((boolean)true, (int)24000, (String)"Close ..."));
                this.updateTextureGeometry(this.m_cubeSet);
                this.m_texGeom.showVertexTexture(false);
                this.m_texGeom.setTexture(null);
                this.m_texGeom.showCubeTexture(false);
                this.m_texGeom.showCubes(false);
                this.m_texGeom.showEdges(true);
                this.m_imgGeom = new PgCubeSet(3);
                this.m_imgGeom.setName(PsConfig.getMessage((int)15003) + " " + this.m_cubeSet.getName());
                this.m_imgGeom.showEdges(false);
                this.m_imgGeom.showVertexTexture(true);
                this.m_imgGeom.setTexture((PgTexture)this.m_cubeSet.getTexture().clone());
                if (this.syncImageGeometry(this.m_texGeom.getBounds())) {
                    this.m_bUpdateFromHere = true;
                    this.m_imgGeom.update(null);
                    this.m_bUpdateFromHere = false;
                }
                PvViewerIf pvViewerIf = (PvViewerIf)PsConfig.getViewer();
                this.m_display = pvViewerIf.newDisplay(PsConfig.getMessage((int)15004), true, false);
                this.m_display.setLightingModel(0);
                this.m_display.setGridIncrements(0, new PdVector(1.0, 1.0));
                Frame frame = this.m_display.getFrame();
                frame.addWindowListener(this);
                frame.setMenuBar(null);
                Panel panel = new Panel(new FlowLayout());
                this.m_bClose = new Button(PsConfig.getMessage((int)24140));
                this.m_bClose.addActionListener(this);
                panel.add(this.m_bClose);
                frame.add((Component)panel, "South");
                frame.validate();
                this.m_display.addGeometry((PgGeometryIf)this.m_texGeom);
                this.m_display.addGeometry((PgGeometryIf)this.m_imgGeom);
                this.m_display.setBackgroundColor(Color.red);
                this.m_display.setDrawingOrder(2, (PgGeometryIf)this.m_imgGeom);
                this.m_display.setEnabledZBuffer(true);
                this.m_display.selectCamera(0);
                ((Component)frame).setVisible(true);
            } else {
                this.closeDomainMode();
            }
        }
    }

    private void closeDomainMode() {
        this.m_bDomainMode = false;
        this.m_bShowDomain.setBackground(this.m_colorDomainMode);
        this.m_bShowDomain.setLabel(PsConfig.getMessage((int)24038));
        if (this.m_display == null) {
            return;
        }
        PvViewerIf pvViewerIf = (PvViewerIf)PsConfig.getViewer();
        if (pvViewerIf.hasDisplay(this.m_display)) {
            pvViewerIf.removeDisplay(this.m_display);
        }
        this.m_display = null;
        this.m_texGeom = null;
        this.m_imgGeom = null;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        PsDebug.notify((String)"entered");
        if (object == this.m_cShowTexture) {
            PsDebug.notify((String)"switch show texture");
            boolean bl = this.m_cShowTexture.getState();
            if (bl) {
                this.assureTexture();
            }
            if (this.m_cubeSet.hasVertexTextures()) {
                this.m_cubeSet.showVertexTexture(bl);
            } else if (this.m_cubeSet.hasCubeTextures()) {
                this.m_cubeSet.showCubeTexture(bl);
            }
            this.m_cubeSet.update((Object)this.m_cubeSet);
            return;
        }
        if (object == this.m_cVertexTex) {
            this.m_cubeSet.showVertexTexture(this.m_cVertexTex.getState());
        } else if (object == this.m_cCubeTex) {
            this.m_cubeSet.showCubeTexture(this.m_cCubeTex.getState());
        } else if (object == this.m_cSyncLabels) {
            this.syncTextureLabels(this.m_cSyncLabels.getState());
            if (this.m_texGeom != null) {
                this.m_bUpdateFromHere = true;
                this.m_texGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
        } else if (object == this.m_cSyncSelect) {
            this.syncTextureSelect(this.m_cSyncSelect.getState());
            this.m_texturePanel.update((Object)this);
            if (this.m_texGeom != null) {
                this.m_bUpdateFromHere = true;
                this.m_texGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
        } else if (object == this.m_cShowMesh) {
            if (this.m_texGeom != null) {
                this.m_texGeom.setVisible(this.m_cShowMesh.getState());
                this.m_bUpdateFromHere = true;
                this.m_texGeom.update(null);
                this.m_bUpdateFromHere = false;
            }
        } else {
            return;
        }
        this.m_cubeSet.update(this);
    }

    private boolean assureTexture() {
        Object object;
        boolean bl;
        PgTexture pgTexture = this.m_cubeSet.getTexture();
        boolean bl2 = bl = pgTexture == null;
        if (pgTexture == null) {
            pgTexture = new PgTexture();
        }
        if (pgTexture.getImageName() == null) {
            object = PsConfig.getInstBase();
            if (PuString.isEmpty((String)object)) {
                object = PsConfig.getCodeBase();
            }
            pgTexture.setImageName((String)object + PsConfig.getJavaViewLogo());
        }
        if (pgTexture.getImage() == null && (object = pgTexture.loadImage(null)) == null) {
            PsDebug.warning((String)"loading default texture failed, use texture panel.");
        }
        if (bl) {
            this.m_cubeSet.setTexture(pgTexture);
        }
        return true;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (!(windowEvent.getSource() instanceof Frame)) {
            return;
        }
        this.closeDomainMode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

