/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.volume.PgCubeSet;

public class PgSmallCubes
extends PgElementSet {
    protected PgCubeSet m_cubeSet;
    protected PuDouble m_cubeSize;
    static /* synthetic */ Class class$jvx$volume$PgSmallCubes;

    public PgSmallCubes(int n) {
        super(n);
        this.setTag(10);
        this.m_cubeSize = new PuDouble("Cube Size", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PgSmallCubes == null ? (class$jvx$volume$PgSmallCubes = PgSmallCubes.class$("jvx.volume.PgSmallCubes")) : class$jvx$volume$PgSmallCubes)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_cubeSize.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_cubeSize.setDefValue(0.5);
        this.m_cubeSize.init();
        if (this.m_cubeSet != null) {
            this.update((Object)this.m_cubeSet);
        }
    }

    public Object clone() {
        PgSmallCubes pgSmallCubes = (PgSmallCubes)((Object)super.clone());
        if (pgSmallCubes == null) {
            return null;
        }
        if (this.m_cubeSet != null) {
            pgSmallCubes.setCubeSet(this.m_cubeSet);
        }
        pgSmallCubes.m_cubeSize = (PuDouble)this.m_cubeSize.clone();
        pgSmallCubes.m_cubeSize.setParent((PsUpdateIf)pgSmallCubes);
        return pgSmallCubes;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgSmallCubes)) {
            return;
        }
        PgSmallCubes pgSmallCubes = (PgSmallCubes)psObject;
        this.m_cubeSize.copy(pgSmallCubes.m_cubeSize);
    }

    public void setCubeSet(PgCubeSet pgCubeSet) {
        if (pgCubeSet == null) {
            PsDebug.warning((String)"missing cubeSet");
            return;
        }
        if (this.m_cubeSet == pgCubeSet) {
            return;
        }
        this.removeCubeSet();
        this.m_cubeSet = pgCubeSet;
        this.m_cubeSet.addUpdateListener((PsUpdateIf)this);
    }

    public void removeCubeSet() {
        if (this.m_cubeSet == null) {
            return;
        }
        this.m_cubeSet.removeUpdateListener((PsUpdateIf)this);
        this.m_cubeSet = null;
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object != null && object == this.m_cubeSet) {
            PsDebug.notify((String)"event=m_cubeSet");
            this.computeCubes();
            return super.update((Object)this);
        }
        if (object == this.m_cubeSize) {
            PsDebug.notify((String)"called with event=m_cubeSize");
            this.computeCubes();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void computeCubes() {
        if (this.m_cubeSet == null) {
            PsDebug.warning((String)"missing cubeSet");
            return;
        }
        int n = this.m_cubeSet.getNumCubes();
        if (n == 0) {
            PsDebug.warning((String)"missing cubes in m_cubeSet, no cube faces are computed.");
            this.setNumVertices(0);
            this.setNumElements(0);
            return;
        }
        PdVector[] pdVectorArray = this.m_cubeSet.getVertices();
        PiVector[] piVectorArray = this.m_cubeSet.getCubes();
        double d = this.m_cubeSize.getValue();
        this.setDimOfElements(4);
        this.setNumElements(6 * n);
        this.setNumVertices(8 * n);
        boolean bl = this.m_cubeSet.hasCubeColors();
        if (bl) {
            this.assureElementColors();
            this.showElementColors(true);
        }
        int[][] nArray = PgCubeSet.LOCAL_FACE_TO_VERTEX;
        PdVector pdVector = new PdVector(this.m_cubeSet.getDimOfVertices());
        for (int i = 0; i < n; ++i) {
            int n2;
            pdVector.setConstant(0.0);
            for (n2 = 0; n2 < 8; ++n2) {
                pdVector.add(pdVectorArray[piVectorArray[i].m_data[n2]]);
            }
            pdVector.multScalar(0.125);
            for (n2 = 0; n2 < 8; ++n2) {
                ((PgPointSet)this).m_vertex[8 * i + n2].blend(1.0 - d, pdVector, d, pdVectorArray[piVectorArray[i].m_data[n2]]);
            }
            for (n2 = 0; n2 < 6; ++n2) {
                this.m_element[6 * i + n2].set(8 * i + nArray[n2][0], 8 * i + nArray[n2][1], 8 * i + nArray[n2][2], 8 * i + nArray[n2][3]);
                if (!bl) continue;
                this.setElementColor(6 * i + n2, this.m_cubeSet.getCubeColor(i));
            }
        }
        this.makeNeighbour();
        this.makeElementNormals();
        this.makeVertexNormals();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

