(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     82174,       2130]
NotebookOptionsPosition[     66090,       1856]
NotebookOutlinePosition[     67446,       1902]
CellTagsIndexPosition[     67403,       1899]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Sample Applications of the ",
 StyleBox["JavaView",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 " Packages\n",
 StyleBox["\tby Konrad Polthier\n\t",
  FontSize->16],
 StyleBox["(Extended Sample Applications, Draft 1.12, 2020-03-19)",
  FontSize->16,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
 CellGroupingRules->"SectionGrouping",
 CellChangeTimes->{{3.6364067483597584`*^9, 3.6364067569689784`*^9}, {
  3.7935779837708306`*^9, 3.7935779978021793`*^9}, {3.7937697825609035`*^9, 
  3.793769787062909*^9}},
 TextAlignment->Left,ExpressionUUID->"3df4ba97-c568-44a0-8c5c-6789a2ba1350"],

Cell[CellGroupData[{

Cell["Technical Comments", "Section",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"02a56e29-c0fd-4d2c-96ca-5ae64bc5ed59"],

Cell[CellGroupData[{

Cell["A Reminder How to Setup JavaView`JLink`", "Subsubsection",ExpressionUUID->"55d17502-e01b-4681-8b26-70fe6a5af840"],

Cell[TextData[{
 "The first step in using JavaView inside ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the loading of the JavaView JavaView ",
 StyleBox["jvx",
  FontSlant->"Italic"],
 " package. This allows to use the commands RunJavaView[g] and JavaView[g] to \
visualize a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Graphics in a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display."
}], "Text",
 CellChangeTimes->{{3.793775738910448*^9, 
  3.793775771815174*^9}},ExpressionUUID->"80cdf4f7-3468-402a-b62b-\
301c4d60943c"],

Cell[TextData[{
 "Load the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " package."
}], "MathCaption",
 CellChangeTimes->{{3.7937759571160927`*^9, 
  3.793775960267346*^9}},ExpressionUUID->"c1ddbed8-fa9b-4692-a503-\
bbf93f430336"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"viewer", " ", "=", " ", 
   RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"cb84c27b-9694-4f52-86c0-d97b1fe0d427"],

Cell[BoxData[
 TemplateBox[{
  "General", "obs", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"WorldPlot`\\\\\\\"\\\"}]\\) has been \
superseded by \\!\\(\\*RowBox[{\\\"GeoGraphics\\\"}]\\), and is now obsolete. \
It will not be included in future versions of the Wolfram Language.\"", 2, 1, 
   1, 33085213785447673784, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7937760831530333`*^9, 3.7937778940095277`*^9, 
  3.793777947178753*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6b5dc99f-0422-4d96-85dd-8127092cf637"],

Cell[BoxData["\<\"JavaView`RunThrough` v3.0.3\"\>"], "Print",
 CellChangeTimes->{3.6365766684136763`*^9, 3.6365779320144176`*^9, 
  3.6365786196806726`*^9, 3.636579247531218*^9, 3.636580799570912*^9, 
  3.6365816400701785`*^9, 3.7935780119535804`*^9, 3.7935799203680573`*^9, 
  3.7937759654026175`*^9, 3.7937760394936256`*^9, 3.7937760834961147`*^9, 
  3.7937778943296175`*^9, 3.793777947491179*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"16679a70-a549-4bec-b204-cbaaa45d3c89"],

Cell[BoxData["\<\"JavaView`JLink` v3.0.3\"\>"], "Print",
 CellChangeTimes->{3.6365766684136763`*^9, 3.6365779320144176`*^9, 
  3.6365786196806726`*^9, 3.636579247531218*^9, 3.636580799570912*^9, 
  3.6365816400701785`*^9, 3.7935780119535804`*^9, 3.7935799203680573`*^9, 
  3.7937759654026175`*^9, 3.7937760394936256`*^9, 3.7937760834961147`*^9, 
  3.7937778943296175`*^9, 3.7937779475380425`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"8a53d385-502b-438e-8cc7-d8b97193c7cc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
For background information, the loading and initialization of JavaView \
performs the following operations:\
\>", "SubsubsectionIcon",
 CellChangeTimes->{{3.636575937340835*^9, 
  3.636575950450411*^9}},ExpressionUUID->"f0a70e6f-208f-40af-ab07-\
dc9debae5feb"],

Cell["Load J/Link.", "MathCaption",
 CellChangeTimes->{{3.636575926621654*^9, 
  3.636575927293646*^9}},ExpressionUUID->"0fe77987-3a9a-4429-8a98-\
b5b07897e9b0"],

Cell[BoxData[{
 RowBox[{"Needs", "[", "\"\<JLink`\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"InstallJava", "[", "]"}], ";"}]}], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"74ece54f-6e15-465b-9525-20b2b3c4d4c6"],

Cell[TextData[{
 "Create a new JavaView display from viewer manager. Note, the window might \
appear behind ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " windows. This sequence of commands can be replaced with the command ",
 StyleBox["JavaView[]",
  FontFamily->"Courier New"],
 "."
}], "MathCaption",ExpressionUUID->"6ac1348d-1cc4-4a59-8c88-6c9915ac3636"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"newDisplay", "[", 
     RowBox[{"\"\<JavaView: From Mathematica\>\"", ",", "True"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frame", "=", 
   RowBox[{"disp", "@", 
    RowBox[{"getFrame", "[", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"frame", "@", 
   RowBox[{"setSize", "[", 
    RowBox[{"400", ",", "400"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"JavaShow", "[", "frame", "]"}], ";"}]}], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"f0ec864a-1541-486a-9983-0ccfa260503f"],

Cell[TextData[{
 "Clear ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from all Java processes. After calling UninstallJava[] the package \
JavaView`JLink` is released and gone. For later use the package must be \
loaded again."
}], "MathCaption",
 CellChangeTimes->{{3.636575965576106*^9, 
  3.636575988029776*^9}},ExpressionUUID->"fca1b837-2f2e-47ea-8831-\
377873e336a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UninstallJava", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"5ad4a547-f125-414c-9a0b-b1744242290c"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initialization and Viewing of Graphics and Geometries", "Subsection",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"c0f1ca59-42b8-4244-b6e1-32213e887239"],

Cell[TextData[{
 "This sample shows the basic steps to load JavaView`JLink`, create a \
JavaView display window, and use two ways to display either a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics or a simple JavaView geometry."
}], "Text",ExpressionUUID->"19dbc06c-b840-4f20-97c2-bb0624159488"],

Cell[CellGroupData[{

Cell[TextData[{
 "Display a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Graphics"
}], "Subsubsection",ExpressionUUID->"45d6863f-cd85-4a35-bd8b-71960c48c453"],

Cell[TextData[{
 "Here we repeat the above step with a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics. The following set of commands would have been performed when ",
 StyleBox["JavaView[dode]",
  FontFamily->"Courier New"],
 " is called from a notebook. Here we repeat these commands step by step \
within this notebook."
}], "Text",ExpressionUUID->"8df4afdf-5ca1-48ef-b616-318dda0cb9a1"],

Cell[TextData[{
 "First, launch the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display showing a default geometry."
}], "MathCaption",
 CellChangeTimes->{{3.636581864859703*^9, 3.6365818848031077`*^9}, {
  3.636582204533371*^9, 3.63658224076888*^9}, {3.6365824099670286`*^9, 
  3.63658241714721*^9}},ExpressionUUID->"5234ffb8-438a-4206-bbfe-\
8722197f0c56"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ico", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"JavaView", "[", "ico", "]"}]}], "Input",
 CellChangeTimes->{{3.636581827868991*^9, 3.6365818330277157`*^9}, {
  3.6365818936545324`*^9, 3.63658190501274*^9}, {3.636582497070978*^9, 
  3.6365825112221775`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"c98d85cd-b990-4373-b7a5-3bef4f48a8a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject6637039235629057]], "Output",
 CellChangeTimes->{
  3.6365819174627075`*^9, 3.636582468293153*^9, {3.636582508186982*^9, 
   3.6365825126101775`*^9}, 3.793579925474262*^9, 3.7937760522922153`*^9, 
   3.793776088065448*^9, 3.7937762451046133`*^9, 3.7937779596730375`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"a09a1874-8c36-466c-9f21-d049449236ad"]
}, Open  ]],

Cell[TextData[{
 "Second, create the main geometry to be shown in the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display."
}], "MathCaption",
 CellChangeTimes->{{3.636581864859703*^9, 3.6365818848031077`*^9}, {
  3.636581933059007*^9, 3.6365819450266333`*^9}, {3.636582243925211*^9, 
  3.636582281974489*^9}, {3.6365824304858575`*^9, 
  3.6365824396374736`*^9}},ExpressionUUID->"093a0a0c-542e-4be5-a222-\
d3a2d3673439"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dode", "=", " ", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", 
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.636399341561711*^9, {3.636399430422368*^9, 3.6363994656569986`*^9}, 
   3.6365768550817266`*^9},
 CellLabel->"In[5]:=",ExpressionUUID->"9dfd47a1-8597-40c7-97d5-af2badd94115"],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
      Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 2],
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
       Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[
      1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[1, 4] (1 + 5^Rational[1, 2]),
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
      0.2628655560595668}, {
     1.3763819204711736`, 
      0, -0.2628655560595668}, {-0.42532540417602, -1.3090169943749475`, 
     0.2628655560595668}, {-0.42532540417602, 1.3090169943749475`, 
     0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
     0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
     0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
     1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
     1.1135163644116066`}, {-0.6881909602355868, -0.5, -1.1135163644116066`}, \
{-0.6881909602355868, 0.5, -1.1135163644116066`}, {0.6881909602355868, -0.5, 
     1.1135163644116066`}, {0.6881909602355868, 0.5, 1.1135163644116066`}, {
     0.85065080835204, 
      0, -1.1135163644116066`}, {-1.1135163644116066`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116066`, 
     0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
      1.1135163644116066`}, {
     0.2628655560595668, -0.8090169943749475, -1.1135163644116066`}, {
     0.2628655560595668, 0.8090169943749475, -1.1135163644116066`}, {
     0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
     0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
   Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
    11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17, 
    13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 7, 
    16, 1, 14}, {16, 8, 4, 15, 1}}]]]], "Output",
 CellChangeTimes->{3.636576856005329*^9, 3.6365779427638283`*^9, 
  3.63657862742871*^9, 3.636579254296945*^9, 3.636579704823324*^9, 
  3.636580806159004*^9, 3.6365817150182433`*^9, 3.6365824709710903`*^9, 
  3.793776220935824*^9, 3.7937779873372564`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"18a158f1-ccdc-47f9-89c9-e480b2896737"]
}, Open  ]],

Cell[TextData[{
 "The command  ",
 StyleBox["ToJavaView[]",
  FontFamily->"Courier New"],
 " converts a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics to ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " geometries. Since a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics may combine several geometries in a single Graphics[] structure, \
the command ",
 StyleBox["ToJavaView[]",
  FontFamily->"Courier New"],
 " always returns a list of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " geometries."
}], "Text",
 CellChangeTimes->{
  3.636582040055194*^9, {3.636582071806155*^9, 3.636582094822362*^9}, {
   3.636582316517424*^9, 
   3.6365823544368544`*^9}},ExpressionUUID->"b74a3757-4ed6-43b7-88e3-\
11b34cbdb05e"],

Cell[TextData[{
 "Third, convert the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics to a list of one or more JavaView geometries."
}], "MathCaption",
 CellChangeTimes->{{3.636582365052575*^9, 
  3.636582375150872*^9}},ExpressionUUID->"8f24c953-71bb-44c3-afae-\
cfe79ac5b0ce"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"geomArr", "=", 
   RowBox[{"ToJavaView", "[", "dode", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"geom", "=", 
  RowBox[{"geomArr", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6365761290083017`*^9, 3.6365761457275314`*^9}, {
   3.6365762445360813`*^9, 3.636576278208922*^9}, {3.6365764521265745`*^9, 
   3.636576454970295*^9}, {3.6365808664595947`*^9, 3.636580871058913*^9}, 
   3.6365815927227736`*^9, 3.6365826459051447`*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"4557e9b9-6e5e-4a41-897b-be6203b5a6a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject28630989722877953]], "Output",
 CellChangeTimes->{
  3.6365764560953255`*^9, {3.636580872331846*^9, 3.636580887895074*^9}, {
   3.636581704417658*^9, 3.636581717037693*^9}, 3.636582473927224*^9, {
   3.793776212963216*^9, 3.79377622343003*^9}, 3.793778000977485*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"e79a1ebc-e746-4976-8702-a0796d55b303"]
}, Open  ]],

Cell["\<\
Fourth, add the JavaView geometry to the display. Fitting will center and \
scale the camera such that the geometry fills the available display area. \
Finally the display is updated to invoke a repaint.\
\>", "MathCaption",
 CellChangeTimes->{{3.6365823798762875`*^9, 
  3.6365823852361336`*^9}},ExpressionUUID->"98464f51-4da5-43cf-b745-\
e632d44b1eee"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"getDisplay", "[", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"removeGeometries", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"addGeometry", "[", "geom", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"fit", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"update", "[", "disp", "]"}]}]}], "Input",
 CellChangeTimes->{
  3.6365761250394964`*^9, {3.6365761684626255`*^9, 3.6365761747284503`*^9}, {
   3.6365816698306656`*^9, 3.6365816827409945`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"cf02e106-c53c-4ce6-a9e5-0bc1a161a5a0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.63657617582224*^9, 3.6365808921391416`*^9, 3.636581683941863*^9, 
   3.6365817201429377`*^9, 3.6365824774227543`*^9, {3.793776228824793*^9, 
   3.79377625089923*^9}, 3.7937780044386473`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"c0100a33-131c-4e84-9059-163cb07abda1"]
}, Open  ]],

Cell[TextData[{
 "Alternatively, several ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics can be added simultaneously to JavaView."
}], "MathCaption",
 CellChangeTimes->{{3.6365823798762875`*^9, 3.6365823852361336`*^9}, {
  3.6365825300528126`*^9, 
  3.636582581809585*^9}},ExpressionUUID->"ed3e2319-12f9-4874-af15-\
cc1caa585e17"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"geomArr", "=", 
  RowBox[{"ToJavaView", "[", 
   RowBox[{"{", 
    RowBox[{"dode", ",", "ico"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"removeGeometries", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"geomArr", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "@", 
   RowBox[{"showElements", "[", "False", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"addGeometry", "[", 
    RowBox[{
     RowBox[{"geomArr", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"addGeometry", "[", 
    RowBox[{
     RowBox[{"geomArr", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"fit", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"update", "[", "disp", "]"}]}]}], "Input",
 CellChangeTimes->{
  3.6365761250394964`*^9, {3.6365761684626255`*^9, 3.6365761747284503`*^9}, {
   3.6365816698306656`*^9, 3.6365816827409945`*^9}, {3.6365825914817047`*^9, 
   3.6365826643741975`*^9}, {3.6365826947342896`*^9, 
   3.6365827435686088`*^9}, {3.6365827838573694`*^9, 3.636582829658497*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"94ac756c-5a85-490c-9408-08ef23654632"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    InterpretationBox[
     RowBox[{"\[LeftGuillemet]", 
      RowBox[{"JavaObject", "[", 
       RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
      "\[RightGuillemet]"}],
     JLink`Objects`vm1`JavaObject33964199226900481], "}"}], ",", 
   RowBox[{"{", 
    InterpretationBox[
     RowBox[{"\[LeftGuillemet]", 
      RowBox[{"JavaObject", "[", 
       RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
      "\[RightGuillemet]"}],
     JLink`Objects`vm1`JavaObject18801210748305409], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.63657617582224*^9, 3.6365808921391416`*^9, 3.636581683941863*^9, 
   3.6365817201429377`*^9, 3.6365824774227543`*^9, 3.6365825953724003`*^9, {
   3.6365826516706944`*^9, 3.636582665217911*^9}, {3.6365826977187333`*^9, 
   3.636582744506072*^9}, 3.6365827915759478`*^9, {3.6365828266142683`*^9, 
   3.63658283045004*^9}, 3.79377801296434*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"3765467d-b958-4244-82b7-7ec48c235ef7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.63657617582224*^9, 3.6365808921391416`*^9, 3.636581683941863*^9, 
   3.6365817201429377`*^9, 3.6365824774227543`*^9, 3.6365825953724003`*^9, {
   3.6365826516706944`*^9, 3.636582665217911*^9}, {3.6365826977187333`*^9, 
   3.636582744506072*^9}, 3.6365827915759478`*^9, {3.6365828266142683`*^9, 
   3.63658283045004*^9}, 3.7937780131361756`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"1eb0408e-87cb-4fdd-b08d-e7f508c2516f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display a JavaView Geometry", "Subsubsection",ExpressionUUID->"a4e60e5c-6c45-4711-b262-9d4556888235"],

Cell["\<\
Here we create a second simple JavaView surface and show it in the display.\
\>", "Text",ExpressionUUID->"b9baec55-d33e-4b24-8609-3e34c9d547db"],

Cell["Create an empty JavaView surface geometry.", "MathCaption",ExpressionUUID->"0ff4a46c-c9d0-41f1-a245-5003ad52ac7f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"geom", " ", "=", " ", 
    RowBox[{"JavaNew", "[", 
     RowBox[{"\"\<jv.geom.PgElementSet\>\"", ",", "3"}], "]"}]}], ";"}], 
  " "}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"8cfac394-96ee-451b-b0b3-279274b047d4"],

Cell["Compute a sample torus surface.", "MathCaption",ExpressionUUID->"c8f21276-c3ea-494c-b142-6f52bfec181b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"computeTorus", "[", 
    RowBox[{"20", ",", "15", ",", "2.", ",", " ", "1."}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setName", "[", "\"\<Torus\>\"", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[21]:=",ExpressionUUID->"6e7d686c-9af1-448d-86cb-26ce5fc9d49f"],

Cell[TextData[{
 "The following commands would have been performed when ",
 StyleBox["JavaView[dode, Replace->False]",
  FontFamily->"Courier New"],
 " is called from a notebook. Here we repeat these commands step by step \
within this notebook."
}], "Text",ExpressionUUID->"c0d3d095-f2ed-4e15-b9ce-a1a2be4ae99b"],

Cell["\<\
Add the geometry to the display. When the geometry has changed the method \
geom@update[geom] must be called to initiate a repaint in the display.\
\>", "MathCaption",ExpressionUUID->"67884012-34dc-413b-a889-c4e2d993ae4e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"addGeometry", "[", "geom", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"update", "[", "disp", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"08f418ec-0857-4aa0-b96d-e50cc784d3ac"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating a Geometry", "Subsection",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"b0861312-98a6-4cee-bf5d-7e3bcfed9fe1"],

Cell[TextData[{
 "This example uses ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to generate a vector field from interactive modifications of a JavaView \
geometry in the display.\n1. We create a sample sphere.\n2. We modify the \
sphere interactively in the JavaView display by dragging vertices around.\n3. \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is used to compute the difference between corresponding vertices of the \
original and the modified sphere as vector field.\n4. Mathematica assigns the \
offset vector field to the original sphere."
}], "Text",ExpressionUUID->"b3f5f144-95a2-4acc-902d-afce38526d41"],

Cell["Create an empty sample geometry with JavaView", "MathCaption",ExpressionUUID->"6845cec5-d23a-45a3-8a2e-4e0dbb3a7db2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"geom", " ", "=", " ", 
    RowBox[{"JavaNew", "[", 
     RowBox[{"\"\<jv.geom.PgElementSet\>\"", ",", "3"}], "]"}]}], ";"}], 
  " "}]], "Input",
 CellLabel->"In[27]:=",ExpressionUUID->"2b91306e-cfcd-4c44-9ffe-e8f6b1d12cb6"],

Cell["\<\
We remove its interior boundary, enable drawing of vertices and labels of \
indices.\
\>", "MathCaption",ExpressionUUID->"71f4674d-a47b-41d1-8bf2-29b6b9909426"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"computeSphere", "[", 
    RowBox[{"6", ",", "6", ",", "1."}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setName", "[", "\"\<Discrete Sphere\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"showVertices", "[", "True", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"showVertexLabels", "[", "True", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"geom", "@", 
  RowBox[{
   RowBox[{"getVertex", "[", "15", "]"}], "@", 
   RowBox[{"setTag", "[", "PsObject`ISUSELECTED", "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.636583062844957*^9, 3.636583086663989*^9}, {
   3.6365832813574357`*^9, 3.6365833050456357`*^9}, {3.636583427189149*^9, 
   3.6365834497258635`*^9}, {3.6365835119773817`*^9, 3.6365835133524647`*^9}, 
   3.636583580666827*^9},
 CellLabel->"In[28]:=",ExpressionUUID->"85e2e258-7290-4375-8540-74f6e5c8a2db"],

Cell[TextData[{
 "Show geometry in JavaView display, display opens on first call. Maybe \
hidden behind ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " windows."
}], "MathCaption",ExpressionUUID->"2fe0fddf-08e1-4bb2-af17-d8051a2a6c63"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JavaView", "[", "geom", "]"}]], "Input",
 CellLabel->"In[48]:=",ExpressionUUID->"5545501d-310f-4c4c-89c6-119dfbe88bfe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject13004000559366145]], "Output",
 CellChangeTimes->{3.6365829911744485`*^9, 3.636583089861003*^9, 
  3.6365835861354923`*^9, 3.793778211894348*^9, 3.793778271817087*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"518dc2ea-3437-4264-94e6-304337f9a83b"]
}, Open  ]],

Cell[TextData[{
 "Save a copy of the vertex array of the original sphere as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list of PdVector's. Print 15th vertex for testing."
}], "MathCaption",ExpressionUUID->"2e2957db-a212-471a-8e34-2327457fdd4a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"origVertex", " ", "=", " ", 
   RowBox[{"PdVector`getEntries", "[", 
    RowBox[{"PdVector`copyNew", "[", 
     RowBox[{"geom", "@", 
      RowBox[{"getVertices", "[", "]"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"origVertex", "[", 
  RowBox[{"[", "16", "]"}], "]"}]}], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"046048f1-4274-4155-8ee0-bead0616c024"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.7694208842938133`"}], ",", "0.5590169943749476`", ",", 
   "0.3090169943749474`"}], "}"}]], "Output",
 CellChangeTimes->{3.6365830032791977`*^9, 3.6365830950955143`*^9, 
  3.6365836992043605`*^9, 3.7937782186967406`*^9, 3.793778295432351*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"e47f2992-6799-47ff-b8ec-30ac52c70a38"]
}, Open  ]],

Cell[TextData[{
 StyleBox["Before",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],
 " invoking the next command,",
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["pick the pink vertex \[OpenCurlyDoubleQuote]15\
\[CloseCurlyDoubleQuote]",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],
 " in the display and move it slightly to a new position. Note the \
\[OpenCurlyDoubleQuote]15\[CloseCurlyDoubleQuote]: Java starts array indices \
at 0 and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " at 1. The pick mode is temporarily enabled by keeping the ",
 StyleBox["p-key",
  FontColor->RGBColor[0, 0, 1]],
 " pressed, and then drag the vertex. Optionally, drag a few other vertices. "
}], "Commentary",
 CellGroupingRules->"SectionGrouping",
 CellChangeTimes->{{3.6365836201724715`*^9, 3.6365836645629015`*^9}, {
  3.79377832590632*^9, 3.7937783299977236`*^9}, {3.7937783964499316`*^9, 
  3.7937784377322035`*^9}, {3.793778485914185*^9, 
  3.7937784915414634`*^9}},ExpressionUUID->"841dea44-4476-4d3f-bf10-\
f19c0b226ca5"],

Cell[TextData[{
 "Save a copy of the vertex array of the modified sphere as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list of PdVector's. The vertex \[OpenCurlyDoubleQuote]15\
\[CloseCurlyDoubleQuote] should have changed."
}], "MathCaption",
 CellChangeTimes->{{3.7937784628095655`*^9, 
  3.7937784781269445`*^9}},ExpressionUUID->"544d86f2-23cf-423b-b8f8-\
d174f6d6a573"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vertex", " ", "=", " ", 
   RowBox[{"PdVector`getEntries", "[", 
    RowBox[{"PdVector`copyNew", "[", 
     RowBox[{"geom", "@", 
      RowBox[{"getVertices", "[", "]"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vertex", "[", 
  RowBox[{"[", "16", "]"}], "]"}]}], "Input",
 CellLabel->"In[53]:=",ExpressionUUID->"c7fead2f-2b70-4cf6-a081-09e4b0a0278d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.1340526412902157`"}], ",", "0.6902333403465472`", ",", 
   "0.5450694117663636`"}], "}"}]], "Output",
 CellChangeTimes->{3.6365830077204337`*^9, 3.6365837104478645`*^9, 
  3.7937782221921453`*^9, 3.793778303123397*^9, 3.7937784492960176`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"7ccbdebe-3933-4d1e-80a2-3e5b828cae6a"]
}, Open  ]],

Cell[TextData[{
 "Let ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " compute the distance vector for each vertex. The vector \
\[OpenCurlyDoubleQuote]15\[CloseCurlyDoubleQuote] should be non-zero."
}], "MathCaption",
 CellChangeTimes->{{3.7937785083738613`*^9, 
  3.793778513078065*^9}},ExpressionUUID->"6b67143b-413b-4bc5-a544-\
dcfcc729aed8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vector", "=", 
   RowBox[{"Subtract", "[", 
    RowBox[{"vertex", ",", "origVertex"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vector", "[", 
  RowBox[{"[", "16", "]"}], "]"}]}], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"aae668f9-8aa3-48d6-bc57-230059eaf8d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.3646317569964024`"}], ",", "0.1312163459715996`", ",", 
   "0.2360524173914162`"}], "}"}]], "Output",
 CellChangeTimes->{3.6365830095347333`*^9, 3.6365837133229313`*^9, 
  3.793778225199994*^9, 3.793778515855646*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"918b483d-8a14-4380-9e0f-5ab750cdcc4b"]
}, Open  ]],

Cell["\<\
The method copyNew[] creates an array of PdVectors from an array of doubles.\
\>", "MathCaption",ExpressionUUID->"54923dbf-445a-4ff9-9f25-a77836d19540"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pdv", " ", "=", " ", 
   RowBox[{"PdVector`copyNew", "[", "vector", "]"}]}], ";"}]], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"c3d53699-f10c-4107-a899-45145a6fa895"],

Cell["Create a vector field and assign the distance vectors.", "MathCaption",ExpressionUUID->"d4c3bbb1-55c4-4a23-95e4-c2926073c07f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vf", " ", "=", " ", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<jv.geom.PgVectorField\>\"", ",", 
     RowBox[{"geom", "@", 
      RowBox[{"getDimOfVertices", "[", "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vf", "@", 
   RowBox[{"setGeometry", "[", "geom", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vf", "@", 
   RowBox[{"setVectors", "[", "pdv", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[58]:=",ExpressionUUID->"19a2794f-511c-4cda-ba84-33d30dad36bb"],

Cell["\<\
Assign the vector field to the geometry, and initiate a repaint of the \
display. Before, we also restore the original vertices. This shows a yellow \
displacement vector.\
\>", "MathCaption",
 CellChangeTimes->{{3.636583749433222*^9, 
  3.6365837716369267`*^9}},ExpressionUUID->"3a593a39-4763-468f-952d-\
fc6631ce512c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setVertices", "[", 
    RowBox[{"PdVector`copyNew", "[", "origVertex", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"geom", "@", 
  RowBox[{"addVectorField", "[", "vf", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"selectVectorField", "[", "vf", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"update", "[", "geom", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[61]:=",ExpressionUUID->"a04d63fd-ac1a-4872-b7f8-e0f630807eaa"],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.636583726620142*^9, 3.7937782383046784`*^9, 
  3.7937785358600316`*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"922d6a35-a6c0-4fb5-a69e-fad690c90233"]
}, Open  ]],

Cell[TextData[{
 "Following this exercise you can let the surface evolve in direction of the \
vector field using the effect EVOLVE which is available from the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " menu bar METHOD->VECTOR FIELD->EVOLVE. In the effect dialog select the \
vertex vector field as evolution direction."
}], "Text",
 CellChangeTimes->{{3.7937782536711473`*^9, 3.793778260963572*^9}, {
  3.7937786114197893`*^9, 
  3.7937786289968414`*^9}},ExpressionUUID->"05ba5f2a-9072-48ec-b3aa-\
7532b03c8733"],

Cell[CellGroupData[{

Cell["Remove/Add a Single Element", "Subsubsection",ExpressionUUID->"b1e536db-5822-4a31-b5e3-75863615450e"],

Cell["\<\
Manually remove and add an individual element to a triangulation by using \
commands. Note, this sequence of commands is a feasibility demo and does not \
extend to larger number of elements. Larger number of elements are usually \
assigned either by allocating elements with setNumElements[int] and then \
using a sequence of setElement[int, int []] calls, or by high-level methods \
like makeQuadrConn[int,int] which generates the connectivity of a m*n grid.\
\>", "Text",ExpressionUUID->"d6c1b637-1483-4cdf-b5a7-c8f19dc4f19a"],

Cell["\<\
Remove an arbitrary element. We recompute element adjacency to refresh \
boundary.\
\>", "MathCaption",ExpressionUUID->"27fee2bb-6511-4da3-8512-949b19f49f75"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"removeElement", "[", "18", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"makeNeighbour", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"showBoundaries", "[", "True", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"update", "[", "geom", "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[155]:=",ExpressionUUID->"b86bb51a-b8cb-417d-a9d2-b04695523401"],

Cell["\<\
Restore the previously element by adding an element. We recompute element \
adjacency to refresh boundary.\
\>", "MathCaption",ExpressionUUID->"173100ca-3f1c-4146-8de3-716c8ec4b8f9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"addElement", "[", 
    RowBox[{"JavaNew", "[", 
     RowBox[{
     "\"\<jv.vecmath.PiVector\>\"", ",", " ", "22", ",", "21", ",", "27", ",",
       "28"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"update", "[", "geom", "]"}]}], ";"}]}], "Input",
 CellLabel->
  "In[159]:=",ExpressionUUID->"f1d78493-38d5-4b37-8ba7-c2de1f80abc5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Adaptions of ",
 StyleBox["JavaView",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 " for J/Link"
}], "Subsection",ExpressionUUID->"40da8b43-ff43-4bcc-b4ae-8f0764c3ad7d"],

Cell[TextData[{
 "A few modifications of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " were made for a better integration with J/Link and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". A set of listener classes allow ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to register for ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " events. These classes reside in the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " package jvx.math which are available with the archive jvx.jar. The sample \
applications of this notebook require no further adaption of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " since the listener classes now belong to the basic API of ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"678419f9-3525-4f85-84a3-b9e94c048e38"],

Cell[CellGroupData[{

Cell["Arrays of PdVectors and PiVectors", "Subsubsection",ExpressionUUID->"289b600c-e7d2-4e1f-ae99-7cc954cb0c68"],

Cell[TextData[{
 "1. Arrays of PdVector resp. PiVector are frequently used in geometry \
classes in JavaView, for example, the set of vertices of a surfaces is an \
array of PdVectors. J/Link will convert such an array to a list of PdVector \
resp. PiVector, where access to individual number would require another \
method call. Therefore, I provided routines getEntries[] and setEntries[] of \
PdVector and PiVector to convert an array of PdVector resp. PiVector to a \
double array of doubles resp. integers. The implicit rule in J/Link converts \
such arrays to a list of lists in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " which are then processed as in the usual way."
}], "Text",ExpressionUUID->"1a3ae6ca-514d-4b77-92bc-6de526349a32"],

Cell[CellGroupData[{

Cell[TextData[{
 "Each of the fundamental linear algebra classes PiVector respectively \
PdVector contains an array of integer respectively double values which are \
mapped to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " lists by J/Link."
}], "MathCaption",ExpressionUUID->"d41e49bd-ec65-4e93-b2ff-9bb43429b404"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mathvi", "=", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "4"}], "}"}]}]], "Input",
 CellLabel->
  "In[161]:=",ExpressionUUID->"653c267a-399e-442b-b001-b87951fc5007"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.636583867378976*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"addf1a23-0eae-4987-944b-b08bc233d807"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vi", "=", 
  RowBox[{"JavaNew", "[", "\"\<jv.vecmath.PiVector\>\"", "]"}]}]], "Input",
 CellLabel->
  "In[162]:=",ExpressionUUID->"94cae1af-8729-4c6c-b0ed-5e98eaac7df9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "vecmath", ".", "PiVector"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject13129599898615809]], "Output",
 CellChangeTimes->{3.63658386964466*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"70733c71-8e7c-4470-aeec-453494b3ebd1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vi", "@", 
  RowBox[{"getSize", "[", "]"}]}]], "Input",
 CellLabel->
  "In[163]:=",ExpressionUUID->"940d361d-6f11-4a5e-9fb8-62e8c0124420"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.6365838711603203`*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"34c60053-2b66-416f-af31-2c6602da1c38"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"vi", "@", 
   RowBox[{"set", "[", "mathvi", "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[164]:=",ExpressionUUID->"a81d4752-6ab9-48ec-b86c-7c20e8f8ee63"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vi", "@", 
   RowBox[{"setEntry", "[", 
    RowBox[{"1", ",", "17"}], "]"}]}], ";"}]], "Input",
 CellLabel->
  "In[165]:=",ExpressionUUID->"629a807d-89f7-4e87-861f-8e1e8460b15b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vi", "@", 
  RowBox[{"getEntries", "[", "]"}]}]], "Input",
 CellLabel->
  "In[166]:=",ExpressionUUID->"5cc02e0c-9580-4c13-b1d9-37e845d468fb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "17", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.6365838809262033`*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"429438fd-4a3f-4a67-b540-29d414927b35"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Many geometry items in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " are available as arrays of PdVector and PiVector which are easily \
exchanged back and forth with a list of lists in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"f98a3e23-e296-42f1-bd44-198dd710a6a0"],

Cell[TextData[{
 "Convert the points of a geometry into a list in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "MathCaption",ExpressionUUID->"6548caff-0362-43c1-bcd1-2da790e8864f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", "=", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<jv.geom.PgElementSet\>\"", ",", "3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"computeTorus", "[", 
    RowBox[{"5", ",", "5", ",", "2.", ",", "1."}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"vertex", " ", "=", " ", 
  RowBox[{"geom", "@", 
   RowBox[{"getVertices", "[", "]"}]}]}]}], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"4e931856-170b-441f-a528-bfe80193932e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject11401564686123009], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject8278477488783361], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject6450552477057025], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject25561823172362241], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject35810001721229313], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject12346853383208961], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject29280673621606401], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject13567256478875649], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject2026854257000449], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject20125937727176705], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject7646827436310529], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject13927954190958593], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject12835854502330369], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject29597748558823425], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject11184853085061121], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject21842819614244865], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject14035644741320705], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject31335707310030849], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject12569914590101505], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject13191231672680449], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject33102532150558721], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject2247440858087425], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject29573214715772929], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject12770087211630593], ",", 
   InterpretationBox[
    RowBox[{"\[LeftGuillemet]", 
     RowBox[{"JavaObject", "[", 
      RowBox[{"jv", ".", "vecmath", ".", "PdVector"}], "]"}], 
     "\[RightGuillemet]"}],
    JLink`Objects`vm1`JavaObject3513084438118401]}], "}"}]], "Output",
 CellChangeTimes->{3.6365838904889326`*^9, 3.793778907479177*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"2636a93d-a274-4477-addb-e7cd410e3388"],

Cell["\<\
The array of points is converted to a list of lists of double values.\
\>", "MathCaption",ExpressionUUID->"ecaf1d36-dcb5-4c22-8f64-60f692b2d9a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mathList", "=", 
  RowBox[{"PdVector`getEntries", "[", "vertex", "]"}]}]], "Input",
 CellLabel->"In[68]:=",ExpressionUUID->"18daa846-2ef5-40d0-9816-08e0ee49b45f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`", ",", "1.2246467991473532`*^-16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9999999999999998`", ",", "0.`", ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "0.`", ",", 
     RowBox[{"-", "2.4492935982947064`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0000000000000004`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`", ",", "3.6739403974420594`*^-16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6.123233995736766`*^-17", ",", "1.`", ",", "1.2246467991473532`*^-16"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.224646799147353`*^-16", ",", "1.9999999999999998`", ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8369701987210297`*^-16", ",", "3.`", ",", 
     RowBox[{"-", "2.4492935982947064`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.2246467991473535`*^-16", ",", "2.0000000000000004`", ",", "1.`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6.123233995736766`*^-17", ",", "1.`", ",", "3.6739403974420594`*^-16"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", "1.2246467991473532`*^-16", ",", 
     "1.2246467991473532`*^-16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.9999999999999998`"}], ",", "2.449293598294706`*^-16", 
     ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.`"}], ",", "3.6739403974420594`*^-16", ",", 
     RowBox[{"-", "2.4492935982947064`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.0000000000000004`"}], ",", "2.449293598294707`*^-16", 
     ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", "1.2246467991473532`*^-16", ",", 
     "3.6739403974420594`*^-16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.8369701987210297`*^-16"}], ",", 
     RowBox[{"-", "1.`"}], ",", "1.2246467991473532`*^-16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.673940397442059`*^-16"}], ",", 
     RowBox[{"-", "1.9999999999999998`"}], ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "5.51091059616309`*^-16"}], ",", 
     RowBox[{"-", "3.`"}], ",", 
     RowBox[{"-", "2.4492935982947064`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.6739403974420604`*^-16"}], ",", 
     RowBox[{"-", "2.0000000000000004`"}], ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.8369701987210297`*^-16"}], ",", 
     RowBox[{"-", "1.`"}], ",", "3.6739403974420594`*^-16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "2.4492935982947064`*^-16"}], ",", 
     "1.2246467991473532`*^-16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.9999999999999998`", ",", 
     RowBox[{"-", "4.898587196589412`*^-16"}], ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", 
     RowBox[{"-", "7.347880794884119`*^-16"}], ",", 
     RowBox[{"-", "2.4492935982947064`*^-16"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.0000000000000004`", ",", 
     RowBox[{"-", "4.898587196589414`*^-16"}], ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "2.4492935982947064`*^-16"}], ",", 
     "3.6739403974420594`*^-16"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.636583895614062*^9, 3.7937789108146143`*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"2ccee8b1-6125-47b0-ada1-a68d3dc081aa"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "Assign a list of points produced in ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "to a geometry in ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 "."
}], "MathCaption",ExpressionUUID->"aad74ee8-ae0f-485c-b2f2-39be8f39e68b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"numULines", " ", "=", " ", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"numVLines", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"point", "=", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"x", "*", "y"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "numULines"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1", ",", "numVLines"}], "}"}]}], "]"}], ",", "1"}],
     "]"}], " ", "//", " ", "N"}]}]}], "Input",
 CellLabel->"In[69]:=",ExpressionUUID->"8368ae7b-e54d-4543-b65b-e4c8eeee4940"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`", ",", "0.8414709848078965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "2.`", ",", "0.9092974268256817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "3.`", ",", "0.1411200080598672`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "4.`", ",", 
     RowBox[{"-", "0.7568024953079282`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "5.`", ",", 
     RowBox[{"-", "0.9589242746631385`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "6.`", ",", 
     RowBox[{"-", "0.27941549819892586`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "1.`", ",", "0.9092974268256817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "2.`", ",", 
     RowBox[{"-", "0.7568024953079282`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "3.`", ",", 
     RowBox[{"-", "0.27941549819892586`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "4.`", ",", "0.9893582466233818`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "5.`", ",", 
     RowBox[{"-", "0.5440211108893698`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "6.`", ",", 
     RowBox[{"-", "0.5365729180004349`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "1.`", ",", "0.1411200080598672`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "2.`", ",", 
     RowBox[{"-", "0.27941549819892586`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "3.`", ",", "0.4121184852417566`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "4.`", ",", 
     RowBox[{"-", "0.5365729180004349`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "5.`", ",", "0.6502878401571168`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "6.`", ",", 
     RowBox[{"-", "0.7509872467716762`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "1.`", ",", 
     RowBox[{"-", "0.7568024953079282`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "2.`", ",", "0.9893582466233818`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "3.`", ",", 
     RowBox[{"-", "0.5365729180004349`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "4.`", ",", 
     RowBox[{"-", "0.2879033166650653`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "5.`", ",", "0.9129452507276277`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "6.`", ",", 
     RowBox[{"-", "0.9055783620066238`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "1.`", ",", 
     RowBox[{"-", "0.9589242746631385`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "2.`", ",", 
     RowBox[{"-", "0.5440211108893698`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "3.`", ",", "0.6502878401571168`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "4.`", ",", "0.9129452507276277`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "5.`", ",", 
     RowBox[{"-", "0.13235175009777303`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "6.`", ",", 
     RowBox[{"-", "0.9880316240928618`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6365838996922903`*^9, 3.7937789132557154`*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"246e1c10-8087-46e1-b010-b0df4b52df0c"]
}, Open  ]],

Cell[TextData[{
 "Create a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " geometry and display it in the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display."
}], "Text",ExpressionUUID->"1fec3008-49b1-4d41-8951-77da654aa6eb"],

Cell[TextData[{
 "Create an empty ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " point set and assign the vertices of the previous example."
}], "MathCaption",ExpressionUUID->"44e8666f-9641-40a1-b866-b984fb52c316"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", "=", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<jv.geom.PgPointSet\>\"", ",", "3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setName", "[", "\"\<Graph of Sin[x*y]\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setNumVertices", "[", 
    RowBox[{"numULines", "*", "numVLines"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setVertices", "[", 
    RowBox[{"PdVector`copyNew", "[", "point", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", "geom", "]"}]}], "Input",
 CellLabel->"In[72]:=",ExpressionUUID->"0e73ee06-50cb-4ace-831f-fd0b23839530"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgPointSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject30302944087769089]], "Output",
 CellChangeTimes->{3.6365839111925807`*^9, 3.7937789173542967`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"fec9eb1e-0c59-41d1-8c8f-d0ec340dd143"]
}, Open  ]],

Cell["Get the currently selected display from the viewer.", "MathCaption",ExpressionUUID->"7c0e8bd9-2987-4fc4-9c60-d945633fd67d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"getDisplay", "[", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"getName", "[", "]"}]}]}], "Input",
 CellLabel->"In[77]:=",ExpressionUUID->"e13b8437-c74f-4a11-a4f3-e673239377d2"],

Cell[BoxData["\<\"Display: From Mathematica\"\>"], "Output",
 CellChangeTimes->{3.6365839231922417`*^9, 3.7937789248499603`*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"c2726a74-d38c-4c41-a34a-c04f19c01d8b"]
}, Open  ]],

Cell["\<\
Show the name of the display in the upper part of the canvas.\
\>", "MathCaption",ExpressionUUID->"b5698ba2-d225-4223-9b15-7367702a1816"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"showTitle", "[", "True", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"update", "[", "disp", "]"}]}]}], "Input",
 CellLabel->"In[79]:=",ExpressionUUID->"671049c2-e02e-440d-be44-4c8ba8906b87"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.6365839272548485`*^9, 3.793778926850769*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"c473d19e-e672-40d8-9c93-99686c8813b1"]
}, Open  ]],

Cell["Get all displays registered in the viewer.", "MathCaption",ExpressionUUID->"d8c36511-040b-486b-bc60-cf1e30fa86e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"viewer", "@", 
  RowBox[{"getDisplays", "[", "]"}]}]], "Input",
 CellLabel->"In[81]:=",ExpressionUUID->"5c28b0e9-dfaf-43bb-b7bd-722ff177b8d2"],

Cell[BoxData[
 RowBox[{"{", 
  InterpretationBox[
   RowBox[{"\[LeftGuillemet]", 
    RowBox[{"JavaObject", "[", 
     RowBox[{"jv", ".", "viewer", ".", "PvDisplay"}], "]"}], 
    "\[RightGuillemet]"}],
   JLink`Objects`vm1`JavaObject23977797810651137], "}"}]], "Output",
 CellChangeTimes->{3.636583933551866*^9, 3.793778929826494*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"8fc9d67a-57b7-4708-a84d-444fad296ed7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package jvx.math", "Subsubsection",ExpressionUUID->"8a19d5c8-9242-4e8c-a7d7-30dfac14d28f"],

Cell[TextData[{
 "The package jvx.math provides listener classes for basic ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " events to be received by a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook in the same ways as listener classes provided by J/Link for other \
Java events. See the section on \"Advanced Examples\" for applications of the \
listener classes."
}], "Text",
 CellChangeTimes->{{3.7937758195814524`*^9, 
  3.7937758567636237`*^9}},ExpressionUUID->"82b2487c-a802-4b84-9b5d-\
ea630791b7a9"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Advanced Examples", "Section",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"f647abab-66fc-47c5-940b-5edbf92ae3e5"],

Cell[CellGroupData[{

Cell["Using Mouse Events for Real-Time Algebra", "Subsection",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"cf503345-5f8e-4718-bd3f-16d8fcb9e66c"],

Cell[TextData[{
 "Mouse position in a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display is received by the notebook and interpreted as two input \
parameters for a calculation.\nSee notebook: ",
 ButtonBox["MouseListener.nb",
  BaseStyle->"Hyperlink",
  ButtonData:>{"MouseListener.nb", None}]
}], "Text",ExpressionUUID->"38204a3f-0a40-4c6f-9e66-83d668aeb095"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Camera Events from Display", "Subsection",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"9d190c48-0ff6-42fe-97a8-65351b7944bf"],

Cell[TextData[{
 "Catch the position of the camera in a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display and use the information to adjust the color of a torus.\nSee \
notebook: ",
 ButtonBox["CameraListener.nb",
  BaseStyle->"Hyperlink",
  ButtonData:>{"CameraListener.nb", None}]
}], "Text",
 CellChangeTimes->{{3.636590087769741*^9, 3.636590087880821*^9}, {
  3.63659028898912*^9, 
  3.636590289707715*^9}},ExpressionUUID->"007f6e1f-2821-46b0-b248-\
d2c0d49f3af9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Using a ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " Slider to Steer a Calculation"
}], "Subsection",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"0d7b237b-e5d4-4408-b5c7-cfef8e35158c"],

Cell[TextData[{
 "Use a JavaView slider to interactively adjust the frequency of a sine-curve \
and the radius of a torus.\nSee notebook: ",
 ButtonBox["SliderListener.nb",
  BaseStyle->"Hyperlink",
  ButtonData:>{"SliderListener.nb", None}]
}], "Text",ExpressionUUID->"dfaa95e3-5c75-49d3-ab61-c5528da53c91"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Timer Events for Animations", "Subsection",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"f248f448-1032-44c6-a323-ae5da0c66d5d"],

Cell[TextData[{
 "Create an animation where a satellite flies around a torus. All \
calculations are performed by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and initiated by events from the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " animation dialog.\nSee notebook: ",
 Cell[BoxData[
  FormBox[
   ButtonBox[
    RowBox[{"Satellite", ".", "nb"}],
    BaseStyle->"Hyperlink",
    ButtonData:>{"Satellite.nb", None}], TraditionalForm]],ExpressionUUID->
  "4f2bd5d4-ebfe-4206-be8b-79785674b1c3"]
}], "Text",ExpressionUUID->"9e65effb-d49c-4b6b-84eb-86e8f596e6dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Pick Events and ",
 StyleBox["Mathematica'",
  FontSlant->"Italic"],
 "s Delaunay Algorithm"
}], "Subsection",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"36e9aea3-da0a-4713-bf57-a3b454216d7c"],

Cell[TextData[{
 "This notebook demonstrates a use of real-time heavy computations by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " while interacting with the ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " display. We show a planar triangulation and drag vertices around while ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " simultaneously calculates the Delaunay triangulation.\nSee notebook: ",
 ButtonBox["Delaunay.nb",
  BaseStyle->"Hyperlink",
  ButtonData->{"Delaunay.nb", None}]
}], "Text",
 CellChangeTimes->{{3.636590101440736*^9, 3.636590101617837*^9}, {
  3.793773102801484*^9, 
  3.793773115272115*^9}},ExpressionUUID->"ad3de925-cbf9-46a7-99ff-\
8f19143cd26e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3D Pick Events", "Subsection",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"14f6dde4-dabf-4871-8217-a89e9bb5cf7b"],

Cell[TextData[{
 "Basic examples to register a notebook such that it receives 3D pick events \
from picking on a 3D surface.\nSee notebook: ",
 Cell[BoxData[
  FormBox[
   ButtonBox[
    RowBox[{"Pick3DListener", ".", "nb"}],
    BaseStyle->"Hyperlink",
    ButtonData:>{"Pick3DListener.nb", None}], TraditionalForm]],
  ExpressionUUID->"f83c1fa7-8d57-40a8-a032-690285394fe3"]
}], "Text",ExpressionUUID->"fe906d6f-d45c-41f5-a93b-474e02530635"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Animations with ",
 StyleBox["JavaView",
  FontSlant->"Italic"]
}], "Subsection",
 CellGroupingRules->
  "SectionGrouping",ExpressionUUID->"daa48378-9aff-4868-8ecd-f0874fe08edd"],

Cell[TextData[{
 "Basic examples to save animations to web pages or load them into ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 ".\nSee notebook: ",
 ButtonBox["Animation.nb",
  BaseStyle->"Hyperlink",
  ButtonData:>{"Animation.nb", None}]
}], "Text",
 CellChangeTimes->{{3.636590095064073*^9, 3.63659009523221*^9}, {
  3.7937732007681904`*^9, 
  3.793773201002511*^9}},ExpressionUUID->"1c529249-b807-402b-8cbd-\
361bd1e5746f"]
}, Open  ]]
}, Open  ]]
},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{672.75, 689.625},
WindowMargins->{{Automatic, 0.375}, {Automatic, 4.875}},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{"Konrad Polthier"}], "PageHeader"]}, {
   Cell[
    TextData[{"The ", 
      StyleBox["JavaView", FontSlant -> "Italic"], " Packages"}], 
    "PageHeader"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}, {Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"FacingPages"->True,
"PrintCellBrackets"->True,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, 56.6875}}},
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"HelpBrowser.nb",
ExpressionUUID->"4f9eb85c-b525-4359-a1a7-546bf631c530"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 666, 17, 95, "Chapter",ExpressionUUID->"3df4ba97-c568-44a0-8c5c-6789a2ba1350",
 CellGroupingRules->"SectionGrouping"],
Cell[CellGroupData[{
Cell[1249, 41, 134, 2, 28, "Section",ExpressionUUID->"02a56e29-c0fd-4d2c-96ca-5ae64bc5ed59",
 CellGroupingRules->"SectionGrouping"],
Cell[CellGroupData[{
Cell[1408, 47, 119, 0, 25, "Subsubsection",ExpressionUUID->"55d17502-e01b-4681-8b26-70fe6a5af840"],
Cell[1530, 49, 557, 18, 28, "Text",ExpressionUUID->"80cdf4f7-3468-402a-b62b-301c4d60943c"],
Cell[2090, 69, 235, 8, 30, "MathCaption",ExpressionUUID->"c1ddbed8-fa9b-4692-a503-bbf93f430336"],
Cell[CellGroupData[{
Cell[2350, 81, 260, 5, 32, "Input",ExpressionUUID->"cb84c27b-9694-4f52-86c0-d97b1fe0d427"],
Cell[2613, 88, 558, 12, 17, "Message",ExpressionUUID->"6b5dc99f-0422-4d96-85dd-8127092cf637"],
Cell[3174, 102, 503, 8, 16, "Print",ExpressionUUID->"16679a70-a549-4bec-b204-cbaaa45d3c89"],
Cell[3680, 112, 500, 8, 16, "Print",ExpressionUUID->"8a53d385-502b-438e-8cc7-d8b97193c7cc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4217, 125, 270, 6, 18, "SubsubsectionIcon",ExpressionUUID->"f0a70e6f-208f-40af-ab07-dc9debae5feb"],
Cell[4490, 133, 161, 3, 38, "MathCaption",ExpressionUUID->"0fe77987-3a9a-4429-8a98-b5b07897e9b0"],
Cell[4654, 138, 229, 4, 42, "Input",ExpressionUUID->"74ece54f-6e15-465b-9525-20b2b3c4d4c6"],
Cell[4886, 144, 366, 9, 54, "MathCaption",ExpressionUUID->"6ac1348d-1cc4-4a59-8c88-6c9915ac3636"],
Cell[5255, 155, 634, 17, 76, "Input",ExpressionUUID->"f0ec864a-1541-486a-9983-0ccfa260503f"],
Cell[5892, 174, 381, 10, 38, "MathCaption",ExpressionUUID->"fca1b837-2f2e-47ea-8831-377873e336a1"],
Cell[6276, 186, 157, 3, 24, "Input",ExpressionUUID->"5ad4a547-f125-414c-9a0b-b1744242290c"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6482, 195, 172, 2, 28, "Subsection",ExpressionUUID->"c0f1ca59-42b8-4244-b6e1-32213e887239",
 CellGroupingRules->"SectionGrouping"],
Cell[6657, 199, 312, 6, 28, "Text",ExpressionUUID->"19dbc06c-b840-4f20-97c2-bb0624159488"],
Cell[CellGroupData[{
Cell[6994, 209, 168, 5, 25, "Subsubsection",ExpressionUUID->"45d6863f-cd85-4a35-bd8b-71960c48c453"],
Cell[7165, 216, 406, 9, 28, "Text",ExpressionUUID->"8df4afdf-5ca1-48ef-b616-318dda0cb9a1"],
Cell[7574, 227, 366, 9, 30, "MathCaption",ExpressionUUID->"5234ffb8-438a-4206-bbfe-8722197f0c56"],
Cell[CellGroupData[{
Cell[7965, 240, 551, 12, 32, "Input",ExpressionUUID->"c98d85cd-b990-4373-b7a5-3bef4f48a8a4"],
Cell[8519, 254, 562, 11, 19, "Output",ExpressionUUID->"a09a1874-8c36-466c-9f21-d049449236ad"]
}, Open  ]],
Cell[9096, 268, 428, 10, 30, "MathCaption",ExpressionUUID->"093a0a0c-542e-4be5-a222-d3a2d3673439"],
Cell[CellGroupData[{
Cell[9549, 282, 421, 10, 20, "Input",ExpressionUUID->"9dfd47a1-8597-40c7-97d5-af2badd94115"],
Cell[9973, 294, 4755, 82, 277, "Output",ExpressionUUID->"18a158f1-ccdc-47f9-89c9-e480b2896737"]
}, Open  ]],
Cell[14743, 379, 753, 26, 28, "Text",ExpressionUUID->"b74a3757-4ed6-43b7-88e3-11b34cbdb05e"],
Cell[15499, 407, 292, 8, 30, "MathCaption",ExpressionUUID->"8f24c953-71bb-44c3-afae-cfe79ac5b0ce"],
Cell[CellGroupData[{
Cell[15816, 419, 579, 11, 32, "Input",ExpressionUUID->"4557e9b9-6e5e-4a41-897b-be6203b5a6a5"],
Cell[16398, 432, 558, 11, 19, "Output",ExpressionUUID->"e79a1ebc-e746-4976-8702-a0796d55b303"]
}, Open  ]],
Cell[16971, 446, 364, 7, 41, "MathCaption",ExpressionUUID->"98464f51-4da5-43cf-b745-e632d44b1eee"],
Cell[CellGroupData[{
Cell[17360, 457, 773, 19, 70, "Input",ExpressionUUID->"cf02e106-c53c-4ce6-a9e5-0bc1a161a5a0"],
Cell[18136, 478, 325, 5, 19, "Output",ExpressionUUID->"c0100a33-131c-4e84-9059-163cb07abda1"]
}, Open  ]],
Cell[18476, 486, 346, 9, 30, "MathCaption",ExpressionUUID->"ed3e2319-12f9-4874-af15-cc1caa585e17"],
Cell[CellGroupData[{
Cell[18847, 499, 1521, 40, 95, "Input",ExpressionUUID->"94ac756c-5a85-490c-9408-08ef23654632"],
Cell[20371, 541, 1034, 23, 19, "Output",ExpressionUUID->"3765467d-b958-4244-82b7-7ec48c235ef7"],
Cell[21408, 566, 479, 7, 19, "Output",ExpressionUUID->"1eb0408e-87cb-4fdd-b08d-e7f508c2516f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21936, 579, 107, 0, 25, "Subsubsection",ExpressionUUID->"a4e60e5c-6c45-4711-b262-9d4556888235"],
Cell[22046, 581, 154, 2, 18, "Text",ExpressionUUID->"b9baec55-d33e-4b24-8609-3e34c9d547db"],
Cell[22203, 585, 120, 0, 30, "MathCaption",ExpressionUUID->"0ff4a46c-c9d0-41f1-a245-5003ad52ac7f"],
Cell[22326, 587, 270, 7, 20, "Input",ExpressionUUID->"8cfac394-96ee-451b-b0b3-279274b047d4"],
Cell[22599, 596, 109, 0, 30, "MathCaption",ExpressionUUID->"c8f21276-c3ea-494c-b142-6f52bfec181b"],
Cell[22711, 598, 366, 9, 32, "Input",ExpressionUUID->"6e7d686c-9af1-448d-86cb-26ce5fc9d49f"],
Cell[23080, 609, 313, 6, 28, "Text",ExpressionUUID->"c0d3d095-f2ed-4e15-b9ce-a1a2be4ae99b"],
Cell[23396, 617, 232, 3, 30, "MathCaption",ExpressionUUID->"67884012-34dc-413b-a889-c4e2d993ae4e"],
Cell[23631, 622, 301, 7, 32, "Input",ExpressionUUID->"08f418ec-0857-4aa0-b96d-e50cc784d3ac"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23981, 635, 142, 2, 28, "Subsection",ExpressionUUID->"b0861312-98a6-4cee-bf5d-7e3bcfed9fe1",
 CellGroupingRules->"SectionGrouping"],
Cell[24126, 639, 641, 13, 96, "Text",ExpressionUUID->"b3f5f144-95a2-4acc-902d-afce38526d41"],
Cell[24770, 654, 123, 0, 30, "MathCaption",ExpressionUUID->"6845cec5-d23a-45a3-8a2e-4e0dbb3a7db2"],
Cell[24896, 656, 270, 7, 20, "Input",ExpressionUUID->"2b91306e-cfcd-4c44-9ffe-e8f6b1d12cb6"],
Cell[25169, 665, 170, 3, 30, "MathCaption",ExpressionUUID->"71f4674d-a47b-41d1-8bf2-29b6b9909426"],
Cell[25342, 670, 1009, 24, 70, "Input",ExpressionUUID->"85e2e258-7290-4375-8540-74f6e5c8a2db"],
Cell[26354, 696, 242, 6, 30, "MathCaption",ExpressionUUID->"2fe0fddf-08e1-4bb2-af17-d8051a2a6c63"],
Cell[CellGroupData[{
Cell[26621, 706, 143, 2, 20, "Input",ExpressionUUID->"5545501d-310f-4c4c-89c6-119dfbe88bfe"],
Cell[26767, 710, 460, 9, 19, "Output",ExpressionUUID->"518dc2ea-3437-4264-94e6-304337f9a83b"]
}, Open  ]],
Cell[27242, 722, 256, 5, 30, "MathCaption",ExpressionUUID->"2e2957db-a212-471a-8e34-2327457fdd4a"],
Cell[CellGroupData[{
Cell[27523, 731, 416, 10, 32, "Input",ExpressionUUID->"046048f1-4274-4155-8ee0-bead0616c024"],
Cell[27942, 743, 380, 7, 19, "Output",ExpressionUUID->"e47f2992-6799-47ff-b8ec-30ac52c70a38"]
}, Open  ]],
Cell[28337, 753, 1043, 26, 35, "Commentary",ExpressionUUID->"841dea44-4476-4d3f-bf10-f19c0b226ca5",
 CellGroupingRules->"SectionGrouping"],
Cell[29383, 781, 384, 9, 19, "MathCaption",ExpressionUUID->"544d86f2-23cf-423b-b8f8-d174f6d6a573"],
Cell[CellGroupData[{
Cell[29792, 794, 408, 10, 32, "Input",ExpressionUUID->"c7fead2f-2b70-4cf6-a081-09e4b0a0278d"],
Cell[30203, 806, 380, 7, 19, "Output",ExpressionUUID->"7ccbdebe-3933-4d1e-80a2-3e5b828cae6a"]
}, Open  ]],
Cell[30598, 816, 352, 9, 30, "MathCaption",ExpressionUUID->"6b67143b-413b-4bc5-a544-dcfcc729aed8"],
Cell[CellGroupData[{
Cell[30975, 829, 315, 8, 32, "Input",ExpressionUUID->"aae668f9-8aa3-48d6-bc57-230059eaf8d9"],
Cell[31293, 839, 354, 7, 19, "Output",ExpressionUUID->"918b483d-8a14-4380-9e0f-5ab750cdcc4b"]
}, Open  ]],
Cell[31662, 849, 162, 2, 30, "MathCaption",ExpressionUUID->"54923dbf-445a-4ff9-9f25-a77836d19540"],
Cell[31827, 853, 207, 4, 20, "Input",ExpressionUUID->"c3d53699-f10c-4107-a899-45145a6fa895"],
Cell[32037, 859, 132, 0, 30, "MathCaption",ExpressionUUID->"d4c3bbb1-55c4-4a23-95e4-c2926073c07f"],
Cell[32172, 861, 541, 14, 44, "Input",ExpressionUUID->"19a2794f-511c-4cda-ba84-33d30dad36bb"],
Cell[32716, 877, 330, 7, 41, "MathCaption",ExpressionUUID->"3a593a39-4763-468f-952d-fc6631ce512c"],
Cell[CellGroupData[{
Cell[33071, 888, 570, 15, 57, "Input",ExpressionUUID->"a04d63fd-ac1a-4872-b7f8-e0f630807eaa"],
Cell[33644, 905, 200, 3, 19, "Output",ExpressionUUID->"922d6a35-a6c0-4fb5-a69e-fad690c90233"]
}, Open  ]],
Cell[33859, 911, 522, 11, 28, "Text",ExpressionUUID->"05ba5f2a-9072-48ec-b3aa-7532b03c8733"],
Cell[CellGroupData[{
Cell[34406, 926, 107, 0, 25, "Subsubsection",ExpressionUUID->"b1e536db-5822-4a31-b5e3-75863615450e"],
Cell[34516, 928, 539, 7, 40, "Text",ExpressionUUID->"d6c1b637-1483-4cdf-b5a7-c8f19dc4f19a"],
Cell[35058, 937, 168, 3, 30, "MathCaption",ExpressionUUID->"27fee2bb-6511-4da3-8512-949b19f49f75"],
Cell[35229, 942, 531, 15, 57, "Input",ExpressionUUID->"b86bb51a-b8cb-417d-a9d2-b04695523401"],
Cell[35763, 959, 192, 3, 30, "MathCaption",ExpressionUUID->"173100ca-3f1c-4146-8de3-716c8ec4b8f9"],
Cell[35958, 964, 441, 12, 32, "Input",ExpressionUUID->"f1d78493-38d5-4b37-8ba7-c2de1f80abc5"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36448, 982, 213, 6, 28, "Subsection",ExpressionUUID->"40da8b43-ff43-4bcc-b4ae-8f0764c3ad7d"],
Cell[36664, 990, 810, 24, 40, "Text",ExpressionUUID->"678419f9-3525-4f85-84a3-b9e94c048e38"],
Cell[CellGroupData[{
Cell[37499, 1018, 113, 0, 25, "Subsubsection",ExpressionUUID->"289b600c-e7d2-4e1f-ae99-7cc954cb0c68"],
Cell[37615, 1020, 753, 12, 52, "Text",ExpressionUUID->"1a3ae6ca-514d-4b77-92bc-6de526349a32"],
Cell[CellGroupData[{
Cell[38393, 1036, 322, 7, 41, "MathCaption",ExpressionUUID->"d41e49bd-ec65-4e93-b2ff-9bb43429b404"],
Cell[CellGroupData[{
Cell[38740, 1047, 194, 5, 20, "Input",ExpressionUUID->"653c267a-399e-442b-b001-b87951fc5007"],
Cell[38937, 1054, 208, 5, 19, "Output",ExpressionUUID->"addf1a23-0eae-4987-944b-b08bc233d807"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39182, 1064, 193, 4, 20, "Input",ExpressionUUID->"94cae1af-8729-4c6c-b0ed-5e98eaac7df9"],
Cell[39378, 1070, 367, 9, 19, "Output",ExpressionUUID->"70733c71-8e7c-4470-aeec-453494b3ebd1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39782, 1084, 162, 4, 20, "Input",ExpressionUUID->"940d361d-6f11-4a5e-9fb8-62e8c0124420"],
Cell[39947, 1090, 155, 3, 19, "Output",ExpressionUUID->"34c60053-2b66-416f-af31-2c6602da1c38"]
}, Open  ]],
Cell[40117, 1096, 187, 5, 20, "Input",ExpressionUUID->"a81d4752-6ab9-48ec-b86c-7c20e8f8ee63"],
Cell[40307, 1103, 213, 6, 20, "Input",ExpressionUUID->"629a807d-89f7-4e87-861f-8e1e8460b15b"],
Cell[CellGroupData[{
Cell[40545, 1113, 165, 4, 20, "Input",ExpressionUUID->"5cc02e0c-9580-4c13-b1d9-37e845d468fb"],
Cell[40713, 1119, 211, 5, 19, "Output",ExpressionUUID->"429438fd-4a3f-4a67-b540-29d414927b35"]
}, Open  ]]
}, Open  ]],
Cell[40951, 1128, 333, 9, 18, "Text",ExpressionUUID->"f98a3e23-e296-42f1-bd44-198dd710a6a0"],
Cell[41287, 1139, 196, 5, 30, "MathCaption",ExpressionUUID->"6548caff-0362-43c1-bcd1-2da790e8864f"],
Cell[CellGroupData[{
Cell[41508, 1148, 527, 14, 44, "Input",ExpressionUUID->"4e931856-170b-441f-a528-bfe80193932e"],
Cell[42038, 1164, 6117, 154, 119, "Output",ExpressionUUID->"2636a93d-a274-4477-addb-e7cd410e3388"],
Cell[48158, 1320, 155, 2, 30, "MathCaption",ExpressionUUID->"ecaf1d36-dcb5-4c22-8f64-60f692b2d9a0"],
Cell[CellGroupData[{
Cell[48338, 1326, 186, 3, 20, "Input",ExpressionUUID->"18daa846-2ef5-40d0-9816-08e0ee49b45f"],
Cell[48527, 1331, 3653, 96, 120, "Output",ExpressionUUID->"2ccee8b1-6125-47b0-ada1-a68d3dc081aa"]
}, Open  ]]
}, Open  ]],
Cell[52207, 1431, 253, 8, 30, "MathCaption",ExpressionUUID->"aad74ee8-ae0f-485c-b2f2-39be8f39e68b"],
Cell[CellGroupData[{
Cell[52485, 1443, 785, 20, 57, "Input",ExpressionUUID->"8368ae7b-e54d-4543-b65b-e4c8eeee4940"],
Cell[53273, 1465, 3312, 82, 81, "Output",ExpressionUUID->"246e1c10-8087-46e1-b010-b0df4b52df0c"]
}, Open  ]],
Cell[56600, 1550, 238, 8, 18, "Text",ExpressionUUID->"1fec3008-49b1-4d41-8951-77da654aa6eb"],
Cell[56841, 1560, 219, 5, 30, "MathCaption",ExpressionUUID->"44e8666f-9641-40a1-b866-b984fb52c316"],
Cell[CellGroupData[{
Cell[57085, 1569, 792, 23, 70, "Input",ExpressionUUID->"0e73ee06-50cb-4ace-831f-fd0b23839530"],
Cell[57880, 1594, 389, 8, 19, "Output",ExpressionUUID->"fec9eb1e-0c59-41d1-8c8f-d0ec340dd143"]
}, Open  ]],
Cell[58284, 1605, 129, 0, 30, "MathCaption",ExpressionUUID->"7c0e8bd9-2987-4fc4-9c60-d945633fd67d"],
Cell[CellGroupData[{
Cell[58438, 1609, 296, 7, 32, "Input",ExpressionUUID->"e13b8437-c74f-4a11-a4f3-e673239377d2"],
Cell[58737, 1618, 207, 2, 19, "Output",ExpressionUUID->"c2726a74-d38c-4c41-a34a-c04f19c01d8b"]
}, Open  ]],
Cell[58959, 1623, 147, 2, 30, "MathCaption",ExpressionUUID->"b5698ba2-d225-4223-9b15-7367702a1816"],
Cell[CellGroupData[{
Cell[59131, 1629, 280, 6, 32, "Input",ExpressionUUID->"671049c2-e02e-440d-be44-4c8ba8906b87"],
Cell[59414, 1637, 176, 2, 19, "Output",ExpressionUUID->"c473d19e-e672-40d8-9c93-99686c8813b1"]
}, Open  ]],
Cell[59605, 1642, 120, 0, 30, "MathCaption",ExpressionUUID->"d8c36511-040b-486b-bc60-cf1e30fa86e2"],
Cell[CellGroupData[{
Cell[59750, 1646, 166, 3, 20, "Input",ExpressionUUID->"5c28b0e9-dfaf-43bb-b7bd-722ff177b8d2"],
Cell[59919, 1651, 414, 9, 19, "Output",ExpressionUUID->"8fc9d67a-57b7-4708-a84d-444fad296ed7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60382, 1666, 96, 0, 25, "Subsubsection",ExpressionUUID->"8a19d5c8-9242-4e8c-a7d7-30dfac14d28f"],
Cell[60481, 1668, 526, 13, 28, "Text",ExpressionUUID->"82b2487c-a802-4b84-9b5d-ea630791b7a9"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[61068, 1688, 133, 2, 28, "Section",ExpressionUUID->"f647abab-66fc-47c5-940b-5edbf92ae3e5",
 CellGroupingRules->"SectionGrouping"],
Cell[CellGroupData[{
Cell[61226, 1694, 159, 2, 28, "Subsection",ExpressionUUID->"cf503345-5f8e-4718-bd3f-16d8fcb9e66c",
 CellGroupingRules->"SectionGrouping"],
Cell[61388, 1698, 370, 9, 36, "Text",ExpressionUUID->"38204a3f-0a40-4c6f-9e66-83d668aeb095"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61795, 1712, 151, 2, 28, "Subsection",ExpressionUUID->"9d190c48-0ff6-42fe-97a8-65351b7944bf",
 CellGroupingRules->"SectionGrouping"],
Cell[61949, 1716, 478, 13, 36, "Text",ExpressionUUID->"007f6e1f-2821-46b0-b248-d2c0d49f3af9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62464, 1734, 223, 7, 28, "Subsection",ExpressionUUID->"0d7b237b-e5d4-4408-b5c7-cfef8e35158c",
 CellGroupingRules->"SectionGrouping"],
Cell[62690, 1743, 308, 6, 36, "Text",ExpressionUUID->"dfaa95e3-5c75-49d3-ab61-c5528da53c91"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63035, 1754, 152, 2, 28, "Subsection",ExpressionUUID->"f248f448-1032-44c6-a323-ae5da0c66d5d",
 CellGroupingRules->"SectionGrouping"],
Cell[63190, 1758, 580, 16, 50, "Text",ExpressionUUID->"9e65effb-d49c-4b6b-84eb-86e8f596e6dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63807, 1779, 225, 7, 28, "Subsection",ExpressionUUID->"36e9aea3-da0a-4713-bf57-a3b454216d7c",
 CellGroupingRules->"SectionGrouping"],
Cell[64035, 1788, 693, 18, 48, "Text",ExpressionUUID->"ad3de925-cbf9-46a7-99ff-8f19143cd26e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64765, 1811, 133, 2, 28, "Subsection",ExpressionUUID->"14f6dde4-dabf-4871-8217-a89e9bb5cf7b",
 CellGroupingRules->"SectionGrouping"],
Cell[64901, 1815, 443, 10, 39, "Text",ExpressionUUID->"fe906d6f-d45c-41f5-a93b-474e02530635"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65381, 1830, 246, 8, 28, "Subsection",ExpressionUUID->"daa48378-9aff-4868-8ecd-f0874fe08edd",
 CellGroupingRules->"SectionGrouping"],
Cell[65630, 1840, 432, 12, 36, "Text",ExpressionUUID->"1c529249-b807-402b-8cbd-361bd1e5746f"]
}, Open  ]]
}, Open  ]]
}
]
*)

