(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16256,        422]
NotebookOptionsPosition[     11758,        333]
NotebookOutlinePosition[     13220,        383]
CellTagsIndexPosition[     13177,        380]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Camera Events from ",
 StyleBox["JavaView",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 " Display\n",
 StyleBox["\tby Konrad Polthier\n\t",
  FontSize->16],
 StyleBox["(v1.12, 2020-03-19)",
  FontSize->16,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
 CellGroupingRules->"SectionGrouping",
 CellChangeTimes->{{3.6364004140464344`*^9, 3.6364004265778356`*^9}, {
  3.7937698766444454`*^9, 3.793769879993943*^9}},
 TextAlignment->Left,ExpressionUUID->"9885426b-2653-4c02-ae52-a40eefd1de22"],

Cell[TextData[{
 "When the JavaView display is opened, rotate the torus with the mouse. The \
camera events are caught by ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"],
 " The viewing direction of the camera is interpreted as RGB values and used \
to set the surface color immediately. As an effect the surface color will \
continuously change during rotation."
}], "Text",
 CellChangeTimes->{{3.793772920599787*^9, 
  3.7937729210213614`*^9}},ExpressionUUID->"209a2c7e-c169-477b-8e1e-\
dca2d5cce981"],

Cell["\<\
This notebook tests the camera listener class \"jvx.math.MathCameraListener\" \
of JavaView. This listener operates asynchronously by starting another thread \
for the event handling. This avoids delays during the rotation and user \
perception of the ongoing event handling.\
\>", "Text",
 CellChangeTimes->{
  3.793772924165666*^9},ExpressionUUID->"cefa4a59-6957-49fe-8a17-\
fbaa6037bf48"],

Cell[CellGroupData[{

Cell[TextData[{
 "Load Java runtime into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and load JavaView."
}], "MathCaption",ExpressionUUID->"8318a0e9-00b3-4275-a92b-d52ebfcc9d96"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\n", 
 RowBox[{
  RowBox[{"viewer", "=", 
   RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"8016b147-5eb2-4301-8cfc-2d3f503634e3"],

Cell[BoxData[
 TemplateBox[{
  "General", "obs", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"WorldPlot`\\\\\\\"\\\"}]\\) has been \
superseded by \\!\\(\\*RowBox[{\\\"GeoGraphics\\\"}]\\), and is now obsolete. \
It will not be included in future versions of the Wolfram Language.\"", 2, 1, 
   1, 33085223529941277531, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793779424320606*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"fc70e28b-c6a3-4c17-9028-7610e917d175"],

Cell[BoxData["\<\"JavaView`RunThrough` v3.0.3\"\>"], "Print",
 CellChangeTimes->{{3.7937794145312986`*^9, 3.7937794246486607`*^9}},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"c1e55816-22fd-4975-88ed-01a8cf4a030f"],

Cell[BoxData["\<\"JavaView`JLink` v3.0.3\"\>"], "Print",
 CellChangeTimes->{{3.7937794145312986`*^9, 3.7937794246955347`*^9}},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"27688aff-a2d2-4c8c-b744-abc6debf351f"]
}, Open  ]],

Cell["\<\
Get the active JavaView 3d-display to be able to register the event handler \
below.\
\>", "MathCaption",ExpressionUUID->"a4001bfd-f433-4a80-8615-e1837b9a815b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"getDisplay", "[", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{
   "setName", "[", "\"\<Camera position determines color\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"showTitle", "[", "True", "]"}]}]}], "Input",
 CellChangeTimes->{{3.636400210898394*^9, 3.636400263836598*^9}, {
  3.6364002978056507`*^9, 3.636400298180649*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"6efcf2cf-d9a5-4ced-924d-1adfad05ef03"],

Cell["Create a sample geometry.", "MathCaption",ExpressionUUID->"198a7fc0-aa10-474f-a4c2-ab27045eadd4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"geom", " ", "=", " ", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<jv.geom.PgElementSet\>\"", ",", "3"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"computeTorus", "[", 
    RowBox[{"10", ",", "10", ",", "2.", ",", "1."}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"b6a1f6fa-249c-43b3-9068-ee7774cb4d15"],

Cell["Show sample geometry in JavaView display.", "MathCaption",ExpressionUUID->"7b855278-7e44-40dc-bde1-c53f8d6739cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["JavaView",
   FontSlant->"Plain"], "[", "geom", "]"}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"8fd32961-07e1-4256-b7a4-fad656b333ff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"jv", ".", "geom", ".", "PgElementSet"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject18955640005197825]], "Output",
 CellChangeTimes->{3.793779432600876*^9, 3.7937805807531943`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"471ed5ce-6edf-4f67-8744-5e2d9a163783"]
}, Open  ]],

Cell[TextData[{
 "This function will be called upon camera events. The argument ",
 StyleBox["evt",
  FontSlant->"Italic"],
 " is instance of jv.project.PvCameraEvent. Here we interpret the viewing \
direction of the camera as vector on the 1_sphere in RGB color space."
}], "MathCaption",
 CellChangeTimes->{{3.7937729383423824`*^9, 
  3.7937729387171793`*^9}},ExpressionUUID->"d102219d-5c93-4fc4-aa82-\
6ace18f63701"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"evalCameraPosition", "[", 
    RowBox[{"evt_", ",", "message_"}], "]"}], "InlineInput"], 
  StyleBox[":=", "InlineInput"], 
  StyleBox["\[IndentingNewLine]", "InlineInput"], 
  StyleBox["\t", "InlineInput"], 
  RowBox[{
   StyleBox["JavaBlock", "InlineInput"], 
   StyleBox["[", "InlineInput"], 
   StyleBox["\[IndentingNewLine]", "InlineInput"], "\t\t", 
   StyleBox[
    RowBox[{
     RowBox[{
      RowBox[{"dir", "=", 
       RowBox[{"evt", "@", 
        RowBox[{"getViewDir", "[", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
     "\t\t", 
     RowBox[{
      RowBox[{"rgb", "=", 
       RowBox[{"Abs", "[", 
        RowBox[{"dir", "@", 
         RowBox[{"getEntries", "[", "]"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{
      RowBox[{"col", "=", 
       RowBox[{"JavaNew", "[", 
        RowBox[{"\"\<java.awt.Color\>\"", ",", 
         RowBox[{"rgb", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"rgb", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{"rgb", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{
      RowBox[{"geom", "@", 
       RowBox[{"setGlobalElementColor", "[", "col", "]"}]}], ";"}], 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{
      RowBox[{"geom", "@", 
       RowBox[{"update", "[", "geom", "]"}]}], ";"}], "\[IndentingNewLine]", 
     "\t\t", 
     RowBox[{"ReleaseObject", "[", "evt", "]"}]}], "InlineInput"], 
   StyleBox["\[IndentingNewLine]", "InlineInput"], 
   StyleBox["\t", "InlineInput"], 
   StyleBox["]", "InlineInput"]}]}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"41ef3d04-76d3-46e6-b4c5-ba5f351c2c6b"],

Cell["Register a listener of camera events in the 2D-display.", "MathCaption",ExpressionUUID->"164c80fa-33e9-499e-8a77-0a0d91d1df10"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"listener", "=", 
   RowBox[{"JavaNew", "[", "\"\<jvx.math.MathCameraListener\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listener", "@", 
   RowBox[{"setHandler", "[", 
    RowBox[{"\"\<pickCamera\>\"", ",", "\"\<evalCameraPosition\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listener", "@", 
   RowBox[{"setHandler", "[", 
    RowBox[{"\"\<dragCamera\>\"", ",", "\"\<evalCameraPosition\>\""}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"addCameraListener", "[", "listener", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"6099f1c9-9761-4d66-a471-32b82411c284"],

Cell["\<\
Share the kernel to allow further interaction with the geometry and display. \
After this call, rotate the surface inside the display and see the surface \
color changing.\
\>", "MathCaption",ExpressionUUID->"1596b3ea-22af-4e95-85e1-65a27019f6a9"],

Cell[BoxData[
 RowBox[{"ShareKernel", "[", "]"}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"71b1f0cc-4311-410c-95f2-bffe8726d9e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will no longer receive events from ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " unless ShareKernel[] is called again."
}], "MathCaption",ExpressionUUID->"1a456c23-db59-4c8a-b7a1-26410c0e1cfb"],

Cell[BoxData[
 RowBox[{"UnshareKernel", "[", "]"}]], "Input",
 CellLabel->
  "(sharing) In[54]:=",ExpressionUUID->"2d01718e-3a5d-40d2-8db9-6b55e8047f49"]
}, Open  ]],

Cell["Auto-rotation", "Subsubsection",ExpressionUUID->"2db39790-dfd3-4da4-8d1b-3cc9eb24f107"],

Cell[TextData[{
 "After having rotated the surface by hand you might want to switch to \
auto-rotate mode by pressing the w-key while mouse focus is in the display, \
or from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The surface will then continuously rotate. Pressing the q-key will stop \
auto-rotate mode. Open the control panel to view and modify material \
properties of the surface."
}], "Text",ExpressionUUID->"1349ec59-e494-4501-9f48-a3dfa5fc3c4c"],

Cell[TextData[{
 "Enable auto-rotation in display from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". First specify rotation axis and angle increments, and then let the \
display run. Alternatively, use the w-key."
}], "MathCaption",ExpressionUUID->"01cca857-94f5-4ab6-90b6-a0f82403e2ec"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"axis", "=", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<jv.vecmath.PdVector\>\"", ",", "0.", ",", "1.", ",", "0."}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"setAutoRotation", "[", 
   RowBox[{"axis", ",", 
    RowBox[{"Pi", "/", "30."}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"setEnabledAnimation", "[", "True", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"disp", "@", 
  RowBox[{"start", "[", "]"}]}]}], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"a7c6055c-c524-426f-a3f2-93a47a4e0241"],

Cell["\<\
Press the w-key while mouse focus is over the display to enable \
auto-rotation. Use the q-key to stop auto-rotation.\
\>", "MathCaption",ExpressionUUID->"e5ebe94c-5b99-42a3-b92e-1d535755d241"],

Cell["\<\
Use right-mouse click within the display to open the control panel. See the \
surface color continuously changing in the material panel.\
\>", "MathCaption",ExpressionUUID->"0b59eeb5-4ea3-4949-82d4-cec7ee288603"],

Cell[CellGroupData[{

Cell["Finally, stop sharing the kernel.", "Subsubsection",ExpressionUUID->"3453891a-5c8b-4f7b-99bd-32e04de9b0d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnshareKernel", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"00e6fc0a-5b7a-41d4-8f5a-1a9183581b8f"]
}, Open  ]]
},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{687.75, 708.375},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{"Konrad Polthier"}], "PageHeader"]}, {
   Cell[
    TextData[{"The ", 
      StyleBox["JavaView", FontSlant -> "Italic"], " Packages"}], 
    "PageHeader"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}, {Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"FacingPages"->True,
"PrintCellBrackets"->True,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{57.375, 57.375}, {57.375, 57.375}}},
CellLabelAutoDelete->False,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"HelpBrowser.nb",
ExpressionUUID->"76b16ca2-bec3-49d9-abfb-d1956ed2919e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 569, 16, 95, "Chapter",ExpressionUUID->"9885426b-2653-4c02-ae52-a40eefd1de22",
 CellGroupingRules->"SectionGrouping"],
Cell[1130, 38, 507, 11, 26, "Text",ExpressionUUID->"209a2c7e-c169-477b-8e1e-dca2d5cce981"],
Cell[1640, 51, 401, 8, 28, "Text",ExpressionUUID->"cefa4a59-6957-49fe-8a17-fbaa6037bf48"],
Cell[CellGroupData[{
Cell[2066, 63, 189, 5, 30, "MathCaption",ExpressionUUID->"8318a0e9-00b3-4275-a92b-d52ebfcc9d96"],
Cell[CellGroupData[{
Cell[2280, 72, 233, 5, 32, "Input",ExpressionUUID->"8016b147-5eb2-4301-8cfc-2d3f503634e3"],
Cell[2516, 79, 507, 11, 17, "Message",ExpressionUUID->"fc70e28b-c6a3-4c17-9028-7610e917d175"],
Cell[3026, 92, 235, 4, 16, "Print",ExpressionUUID->"c1e55816-22fd-4975-88ed-01a8cf4a030f"],
Cell[3264, 98, 230, 4, 16, "Print",ExpressionUUID->"27688aff-a2d2-4c8c-b744-abc6debf351f"]
}, Open  ]],
Cell[3509, 105, 170, 3, 30, "MathCaption",ExpressionUUID->"a4001bfd-f433-4a80-8615-e1837b9a815b"],
Cell[3682, 110, 574, 14, 44, "Input",ExpressionUUID->"6efcf2cf-d9a5-4ced-924d-1adfad05ef03"],
Cell[4259, 126, 103, 0, 30, "MathCaption",ExpressionUUID->"198a7fc0-aa10-474f-a4c2-ab27045eadd4"],
Cell[4365, 128, 410, 10, 32, "Input",ExpressionUUID->"b6a1f6fa-249c-43b3-9068-ee7774cb4d15"],
Cell[4778, 140, 119, 0, 30, "MathCaption",ExpressionUUID->"7b855278-7e44-40dc-bde1-c53f8d6739cc"],
Cell[CellGroupData[{
Cell[4922, 144, 179, 4, 20, "Input",ExpressionUUID->"8fd32961-07e1-4256-b7a4-fad656b333ff"],
Cell[5104, 150, 389, 8, 19, "Output",ExpressionUUID->"471ed5ce-6edf-4f67-8744-5e2d9a163783"]
}, Open  ]],
Cell[5508, 161, 419, 9, 41, "MathCaption",ExpressionUUID->"d102219d-5c93-4fc4-aa82-6ace18f63701"],
Cell[5930, 172, 1753, 48, 121, "Input",ExpressionUUID->"41ef3d04-76d3-46e6-b4c5-ba5f351c2c6b"],
Cell[7686, 222, 133, 0, 30, "MathCaption",ExpressionUUID->"164c80fa-33e9-499e-8a77-0a0d91d1df10"],
Cell[7822, 224, 720, 18, 57, "Input",ExpressionUUID->"6099f1c9-9761-4d66-a471-32b82411c284"],
Cell[8545, 244, 257, 4, 30, "MathCaption",ExpressionUUID->"1596b3ea-22af-4e95-85e1-65a27019f6a9"],
Cell[8805, 250, 138, 2, 20, "Input",ExpressionUUID->"71b1f0cc-4311-410c-95f2-bffe8726d9e1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8980, 257, 359, 9, 41, "MathCaption",ExpressionUUID->"1a456c23-db59-4c8a-b7a1-26410c0e1cfb"],
Cell[9342, 268, 153, 3, 20, "Input",ExpressionUUID->"2d01718e-3a5d-40d2-8db9-6b55e8047f49"]
}, Open  ]],
Cell[9510, 274, 93, 0, 25, "Subsubsection",ExpressionUUID->"2db39790-dfd3-4da4-8d1b-3cc9eb24f107"],
Cell[9606, 276, 477, 9, 38, "Text",ExpressionUUID->"1349ec59-e494-4501-9f48-a3dfa5fc3c4c"],
Cell[10086, 287, 304, 6, 30, "MathCaption",ExpressionUUID->"01cca857-94f5-4ab6-90b6-a0f82403e2ec"],
Cell[10393, 295, 619, 16, 57, "Input",ExpressionUUID->"a7c6055c-c524-426f-a3f2-93a47a4e0241"],
Cell[11015, 313, 203, 3, 30, "MathCaption",ExpressionUUID->"e5ebe94c-5b99-42a3-b92e-1d535755d241"],
Cell[11221, 318, 222, 3, 30, "MathCaption",ExpressionUUID->"0b59eeb5-4ea3-4949-82d4-cec7ee288603"],
Cell[CellGroupData[{
Cell[11468, 325, 113, 0, 25, "Subsubsection",ExpressionUUID->"3453891a-5c8b-4f7b-99bd-32e04de9b0d6"],
Cell[11584, 327, 158, 3, 20, "Input",ExpressionUUID->"00e6fc0a-5b7a-41d4-8f5a-1a9183581b8f"]
}, Open  ]]
}
]
*)

