(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     12156,        341]
NotebookOptionsPosition[      8610,        263]
NotebookOutlinePosition[      9963,        309]
CellTagsIndexPosition[      9920,        306]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Listener for 3D Pick Events from ",
 StyleBox["JavaView",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0.250004, 0.500008]],
 "\n",
 StyleBox["\tby Konrad Polthier\n\t",
  FontSize->16],
 StyleBox["(v1.12, 2020-03-19)",
  FontSize->16,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Chapter",
 CellGroupingRules->"SectionGrouping",
 CellChangeTimes->{3.793769934903395*^9},
 TextAlignment->Left,ExpressionUUID->"ab88ce86-784f-4fd3-bce8-85432d966a27"],

Cell[TextData[{
 "In this notebook ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " catches 3D pick events issued from the JavaView display when a point on a \
geometry is picked while keeping the key-i pressed. The picked point may lie \
in the inside of triangles or polygons."
}], "Text",ExpressionUUID->"185eb8cd-acb6-4c32-9b7d-cc5cf7d18e39"],

Cell[CellGroupData[{

Cell[TextData[{
 "Load Java runtime into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and load JavaView."
}], "MathCaption",ExpressionUUID->"ea7a7d7b-eb67-425c-acd9-4ee4911319cc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"<<", "JavaView`JLink`"}], "\n", 
 RowBox[{
  RowBox[{"viewer", "=", 
   RowBox[{"InstallJavaView", "[", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"48d0820a-db55-4080-91ee-2088e9640172"],

Cell[BoxData[
 TemplateBox[{
  "General", "obs", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"WorldPlot`\\\\\\\"\\\"}]\\) has been \
superseded by \\!\\(\\*RowBox[{\\\"GeoGraphics\\\"}]\\), and is now obsolete. \
It will not be included in future versions of the Wolfram Language.\"", 2, 1, 
   1, 33085250177965223565, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.793783490365438*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"867000a0-6e38-42b1-ac52-16eda563af95"],

Cell[BoxData["\<\"JavaView`RunThrough` v3.0.3\"\>"], "Print",
 CellChangeTimes->{{3.793783479237174*^9, 3.793783490677825*^9}},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"dc425883-d63b-4ef1-8909-dc46852c113c"],

Cell[BoxData["\<\"JavaView`JLink` v3.0.3\"\>"], "Print",
 CellChangeTimes->{{3.793783479237174*^9, 3.793783490740339*^9}},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"6f6b6098-b0af-423c-ada2-f5f5463009d3"],

Cell["\<\
Get the active JavaView 3d-display to be able to register this notebook as \
pick listener.\
\>", "MathCaption",ExpressionUUID->"80a5a93d-8533-4342-b5e7-d9d7c651ed8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"disp", "=", 
   RowBox[{"viewer", "@", 
    RowBox[{"getDisplay", "[", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"ffcf4b21-0eab-4ab7-b488-9564d9629df5"],

Cell[CellGroupData[{

Cell["\<\
Compute a sample torus geometry and register it inside the display.\
\>", "MathCaption",ExpressionUUID->"4f72fef5-52a4-458e-9db4-9c448c3080a1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"geom", " ", "=", " ", 
    RowBox[{"JavaNew", "[", 
     RowBox[{"\"\<jv.geom.PgElementSet\>\"", ",", "3"}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"innerRadius", " ", "=", "2."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tubeRadius", "=", "1."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"computeTorus", "[", 
    RowBox[{"20", ",", "15", ",", "innerRadius", ",", "tubeRadius"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"geom", "@", 
   RowBox[{"setName", "[", "\"\<Torus World\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["JavaView",
    FontSlant->"Plain"], "[", "geom", "]"}], ";"}]}], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"c9e14d5a-eafc-4d46-bf81-d6cf0c34ed14"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compute the satellite and register it inside the display.", \
"MathCaption",ExpressionUUID->"bc6991d1-0111-4764-a2f3-6c33a11ac99d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sat", " ", "=", " ", 
   RowBox[{"JavaNew", "[", "\"\<jv.geom.PgElementSet\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LoadClass", "[", "\"\<jvx.geom.PwPlatonic\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PwPlatonic`getSolid", "[", 
   RowBox[{"sat", ",", "PwPlatonic`DODECAHEDRON"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"setName", "[", "\"\<Satellite\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"sat", "@", 
  RowBox[{"setGlobalElementColor", "[", 
   RowBox[{"JavaNew", "[", 
    RowBox[{"\"\<java.awt.Color\>\"", ",", " ", "255", ",", "150", ",", "0"}],
     "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"scale", "[", 
    RowBox[{"1.", "/", "5."}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"showVertices", "[", "False", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"showVertexNormals", "[", "True", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"addGeometry", "[", "sat", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sat", "@", 
   RowBox[{"update", "[", "sat", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{3.7937835346451263`*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"d50613f4-2be6-4ccb-9819-0c3bf2747fd0"]
}, Open  ]],

Cell["\<\
This function will be called upon initial-pick events, which are issued when \
the i-key is being pressed while picking a point on the torus geometry with a \
mouse.\
\>", "MathCaption",ExpressionUUID->"d22be99c-7cd4-46e8-b2d2-194f14f6c80e"],

Cell["\<\
pickInitial[pos_,message_]:=
\tJavaBlock[
\t\tIf [pos@getGeometry[] =!= geom, Return[Null]];
\t\tPwPlatonic`setSolid[sat,PwPlatonic`DODECAHEDRON];
\t\tsat@scale[1./5.];
\t\tsat@translate[pos@getVertex[]];
\t\tsat@update[sat];
\t]\
\>", "Input",
 PageWidth:>WindowWidth,
 ShowSpecialCharacters->False,
 CellLabel->"In[30]:=",ExpressionUUID->"f040a99a-db05-4568-b440-d2d5ada19315"],

Cell["\<\
Register a listener of pick events. See the documentation of the class \
jvx.math.MathPickListener for further methods, like dragInitial for receiving \
events while the mouse is dragged (while keeping i-key pressed).\
\>", "MathCaption",ExpressionUUID->"2b42280c-d27e-4fab-bbbd-8e3fcfa6aca6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"listener", "=", 
   RowBox[{"JavaNew", "[", "\"\<jvx.math.MathPickListener\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listener", "@", 
   RowBox[{"setHandler", "[", 
    RowBox[{"\"\<pickInitial\>\"", ",", "\"\<pickInitial\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"listener", "@", 
   RowBox[{"setHandler", "[", 
    RowBox[{"\"\<dragInitial\>\"", ",", "\"\<pickInitial\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"disp", "@", 
   RowBox[{"addPickListener", "[", "listener", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"aa683c21-d1b7-49fb-b018-91981628799f"],

Cell["\<\
Share the kernel to allow further interaction with the geometry and display.\
\>", "MathCaption",ExpressionUUID->"0034d172-e314-4f56-be6a-8404f98043ef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ShareKernel", "[", "]"}]], "Input",
 CellLabel->"In[23]:=",ExpressionUUID->"d4246d94-e0f1-41dd-bb81-e4a9099d7cab"],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[23]=",ExpressionUUID->"3e8a42fd-b36f-4570-a276-c7949f82592d"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "When done with interaction, then call UnshareKernel[]. After calling \
UnshareKernel[] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will no longer receive events from ",
 StyleBox["JavaView",
  FontSlant->"Italic"],
 " unless ShareKernel[] is called again."
}], "MathCaption",ExpressionUUID->"856843cf-842d-437c-8dfa-13c43c9a6b7e"],

Cell[BoxData[
 RowBox[{"UnshareKernel", "[", "]"}]], "Input",
 CellLabel->
  "(sharing) In[29]:=",ExpressionUUID->"104eb2a9-820e-46bb-b0de-35ba336956cc"]
}, Open  ]]
},
ScreenStyleEnvironment->"Brackets",
CellGrouping->Manual,
WindowSize->{627.375, 708.375},
WindowMargins->{{Automatic, 9.375}, {Automatic, 0}},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{"Konrad Polthier"}], "PageHeader"]}, {
   Cell[
    TextData[{"The ", 
      StyleBox["JavaView", FontSlant -> "Italic"], " Packages"}], 
    "PageHeader"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}, {Inherited, 
   Cell[
    TextData[{
     "\[Copyright]1999 Wolfram Research, Inc. All rights reserved."}], 
    "PageFooter"], Inherited}},
PageFooterLines->{True, True},
PrintingOptions->{"FacingPages"->True,
"PrintCellBrackets"->True,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{56.6875, 56.6875}, {56.6875, 56.6875}}},
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"HelpBrowser.nb",
ExpressionUUID->"e52972c2-bbbd-4044-ad6f-8db79386bc89"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 496, 15, 95, "Chapter",ExpressionUUID->"ab88ce86-784f-4fd3-bce8-85432d966a27",
 CellGroupingRules->"SectionGrouping"],
Cell[1057, 37, 352, 7, 26, "Text",ExpressionUUID->"185eb8cd-acb6-4c32-9b7d-cc5cf7d18e39"],
Cell[CellGroupData[{
Cell[1434, 48, 189, 5, 30, "MathCaption",ExpressionUUID->"ea7a7d7b-eb67-425c-acd9-4ee4911319cc"],
Cell[CellGroupData[{
Cell[1648, 57, 233, 5, 32, "Input",ExpressionUUID->"48d0820a-db55-4080-91ee-2088e9640172"],
Cell[1884, 64, 507, 11, 31, "Message",ExpressionUUID->"867000a0-6e38-42b1-ac52-16eda563af95"],
Cell[2394, 77, 231, 4, 16, "Print",ExpressionUUID->"dc425883-d63b-4ef1-8909-dc46852c113c"],
Cell[2628, 83, 226, 4, 16, "Print",ExpressionUUID->"6f6b6098-b0af-423c-ada2-f5f5463009d3"],
Cell[2857, 89, 177, 3, 30, "MathCaption",ExpressionUUID->"80a5a93d-8533-4342-b5e7-d9d7c651ed8c"],
Cell[3037, 94, 211, 5, 20, "Input",ExpressionUUID->"ffcf4b21-0eab-4ab7-b488-9564d9629df5"],
Cell[CellGroupData[{
Cell[3273, 103, 153, 2, 30, "MathCaption",ExpressionUUID->"4f72fef5-52a4-458e-9db4-9c448c3080a1"],
Cell[3429, 107, 861, 24, 82, "Input",ExpressionUUID->"c9e14d5a-eafc-4d46-bf81-d6cf0c34ed14"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4327, 136, 137, 1, 30, "MathCaption",ExpressionUUID->"bc6991d1-0111-4764-a2f3-6c33a11ac99d"],
Cell[4467, 139, 1446, 40, 133, "Input",ExpressionUUID->"d50613f4-2be6-4ccb-9819-0c3bf2747fd0"]
}, Open  ]],
Cell[5928, 182, 251, 4, 41, "MathCaption",ExpressionUUID->"d22be99c-7cd4-46e8-b2d2-194f14f6c80e"],
Cell[6182, 188, 389, 12, 115, "Input",ExpressionUUID->"f040a99a-db05-4568-b440-d2d5ada19315"],
Cell[6574, 202, 303, 4, 41, "MathCaption",ExpressionUUID->"2b42280c-d27e-4fab-bbbd-8e3fcfa6aca6"],
Cell[6880, 208, 700, 18, 57, "Input",ExpressionUUID->"aa683c21-d1b7-49fb-b018-91981628799f"],
Cell[7583, 228, 162, 2, 30, "MathCaption",ExpressionUUID->"0034d172-e314-4f56-be6a-8404f98043ef"],
Cell[CellGroupData[{
Cell[7770, 234, 138, 2, 20, "Input",ExpressionUUID->"d4246d94-e0f1-41dd-bb81-e4a9099d7cab"],
Cell[7911, 238, 107, 1, 19, "Output",ExpressionUUID->"3e8a42fd-b36f-4570-a276-c7949f82592d"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8079, 246, 359, 9, 41, "MathCaption",ExpressionUUID->"856843cf-842d-437c-8dfa-13c43c9a6b7e"],
Cell[8441, 257, 153, 3, 20, "Input",ExpressionUUID->"104eb2a9-820e-46bb-b0de-35ba336956cc"]
}, Open  ]]
}
]
*)

